/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.constraints;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.imp.analysis.constraints.ConstraintTerm;
import org.eclipse.imp.analysis.constraints.IConstraint;
import org.eclipse.imp.analysis.constraints.IConstraintTerm;
import org.eclipse.imp.analysis.constraints.ITermProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintGraph {
    private boolean DEBUG_DECORATION = false;
    private boolean DEBUG_DUMP_RAW = false;
    private boolean DEBUG_DUMP_USEDIN = false;
    private final Collection<IConstraint> fConstraints;
    private final Set<IConstraintTerm> fAllVarbles = new LinkedHashSet<IConstraintTerm>();
    private Map<IConstraintTerm, List<IConstraint>> fUsedIn = new LinkedHashMap<IConstraintTerm, List<IConstraint>>();
    private VariableDecorator fVariableDecorator = new VariableDecorator();

    public ConstraintGraph(Collection<IConstraint> constraints) {
        this.fConstraints = constraints;
        this.initialize();
    }

    void clearAll() {
        this.fAllVarbles.clear();
        this.fUsedIn = new LinkedHashMap<IConstraintTerm, List<IConstraint>>();
    }

    void initialize() {
        this.decorateVarbles();
        if (this.DEBUG_DUMP_RAW) {
            this.dumpVariableList(System.out);
            this.dumpConstraints(System.out);
        }
        if (this.DEBUG_DUMP_USEDIN) {
            this.dumpUsedInLists(System.out);
        }
    }

    public List<IConstraint> getUsedIn(IConstraintTerm v) {
        return this.fUsedIn.get(v);
    }

    public Collection<IConstraint> getConstraints() {
        return this.fConstraints;
    }

    public Set<IConstraintTerm> getVariables() {
        return this.fAllVarbles;
    }

    private void addToUsedInSet(IConstraintTerm v, IConstraint constraint) {
        List<IConstraint> usedIn = this.fUsedIn.get(v);
        if (usedIn == null) {
            usedIn = new ArrayList<IConstraint>();
            this.fUsedIn.put(v, usedIn);
        }
        if (this.DEBUG_DECORATION) {
            System.out.println("  Adding constraint " + constraint.toString() + " to used-in set of " + v.toString());
        }
        usedIn.add(constraint);
    }

    private void decorateConstraintVarbles(IConstraint c) {
        this.fVariableDecorator.setConstraint(c);
        c.processTerms(this.fVariableDecorator);
    }

    private void decorateVarbles() {
        if (this.DEBUG_DECORATION) {
            System.out.println();
            System.out.println("*** Collecting & annotating constraint variables ***");
        }
        for (IConstraint constraint : this.fConstraints) {
            if (this.DEBUG_DECORATION) {
                System.out.println("Pre-processing constraint " + constraint.toString());
            }
            this.decorateConstraintVarbles(constraint);
        }
    }

    public static List<IConstraintTerm> sortedConstraintVariables(Collection<IConstraintTerm> varbles) {
        IConstraintTerm[] va = varbles.toArray(new IConstraintTerm[varbles.size()]);
        Arrays.sort(va, new Comparator<IConstraintTerm>(){

            @Override
            public int compare(IConstraintTerm t1, IConstraintTerm t2) {
                return t1.toString().compareTo(t2.toString());
            }
        });
        return Arrays.asList(va);
    }

    public void dumpVariableList(PrintStream ps) {
        ps.println();
        ps.println("*** Constraint Variables: ***");
        List<IConstraintTerm> scv = ConstraintGraph.sortedConstraintVariables(this.fAllVarbles);
        for (IConstraintTerm t : scv) {
            ps.println(t.toString());
        }
    }

    public void dumpConstraints(PrintStream ps) {
        ps.println(this.toString());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n");
        buf.append("*** Constraints: ***\n");
        ArrayList<String> cs = new ArrayList<String>();
        for (IConstraint c : this.fConstraints) {
            cs.add(c.toString());
        }
        Collections.sort(cs);
        for (String s : cs) {
            buf.append(s).append("\n");
        }
        return buf.toString();
    }

    private void dumpUsedInLists(PrintStream ps) {
        ps.println();
        ps.println("*** Used-In Lists: ***");
        List<IConstraintTerm> scv = ConstraintGraph.sortedConstraintVariables(this.fAllVarbles);
        for (ConstraintTerm constraintTerm : scv) {
            boolean gotOne = false;
            List<IConstraint> usedIn = this.fUsedIn.get(constraintTerm);
            if (usedIn == null) continue;
            for (IConstraint eq : usedIn) {
                if (!gotOne) {
                    ps.println(constraintTerm.toString() + ":");
                    gotOne = true;
                }
                ps.println("              " + eq.toString());
            }
        }
    }

    private class VariableDecorator
    implements ITermProcessor {
        private IConstraint fConstraint;

        private VariableDecorator() {
        }

        void setConstraint(IConstraint c) {
            this.fConstraint = c;
        }

        public void processTerm(IConstraintTerm term) {
            ConstraintGraph.this.addToUsedInSet(term, this.fConstraint);
            if (!ConstraintGraph.this.fAllVarbles.contains(term)) {
                ConstraintGraph.this.fAllVarbles.add(term);
            }
        }
    }
}

