/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.xform.pattern.matching;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchResult {
    final Object fRoot;
    final MatchResult fParent;
    final Map<String, Object> fBindings = new HashMap<String, Object>();
    Object fMatchNode;

    public MatchResult(Object root) {
        this(root, null);
    }

    public MatchResult(Object root, MatchResult parent) {
        this.fRoot = root;
        this.fParent = parent;
    }

    public Object getRoot() {
        return this.fRoot;
    }

    public MatchResult getParent() {
        return this.fParent;
    }

    void setMatchNode(Object node) {
        this.fMatchNode = node;
    }

    public Object getMatchNode() {
        return this.fMatchNode;
    }

    public Map<String, Object> localBindings() {
        return this.fBindings;
    }

    public Map<String, Object> getBindings() {
        HashMap<String, Object> allBindings = new HashMap<String, Object>();
        MatchResult r = this;
        while (r != null) {
            allBindings.putAll(r.fBindings);
            r = r.fParent;
        }
        return allBindings;
    }

    void addBinding(String varName, Object astNode) {
        this.fBindings.put(varName, astNode);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("node = '");
        buff.append(this.fMatchNode);
        buff.append("'; bindings = { ");
        Iterator<String> iter = this.fBindings.keySet().iterator();
        while (iter.hasNext()) {
            String metaVarName = iter.next();
            buff.append(metaVarName);
            buff.append(" => '");
            buff.append(this.fBindings.get(metaVarName));
            buff.append("'");
            if (!iter.hasNext()) continue;
            buff.append(", ");
        }
        buff.append(" }");
        return buff.toString();
    }
}

