/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public void initializeDefaultPreferences() {
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                ColorRegistry registry = null;
                if (PlatformUI.isWorkbenchRunning()) {
                    registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
                }
                IPreferenceStore store = RuntimePlugin.getInstance().getPreferenceStore();
                store.setDefault("emitMessages", false);
                store.setDefault("emitBuilderDiagnostics", false);
                FontData[] fontData = JFaceResources.getFontDescriptor((String)"org.eclipse.jdt.ui.editors.textfont").getFontData();
                if (fontData != null && fontData.length > 0) {
                    PreferenceConverter.setDefault((IPreferenceStore)store, (String)"sourceFont", (FontData[])fontData);
                }
                store.setDefault("tabWidth", 8);
                store.setDefault("dumpTokens", false);
                store.setDefault("matchingBrackets", true);
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)"matchingBracketsColor", (RGB)PreferenceInitializer.findRGB(registry, "org.eclipse.imp.runtime.matchingBracketsColor", new RGB(192, 192, 192)));
            }
        });
    }

    private static RGB findRGB(ColorRegistry registry, String key, RGB defaultRGB) {
        if (registry == null) {
            return defaultRGB;
        }
        RGB rgb = registry.getRGB(key);
        if (rgb != null) {
            return rgb;
        }
        return defaultRGB;
    }
}

