/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.PreferencesUtilities;
import org.eclipse.imp.preferences.fields.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.prefs.BackingStoreException;

public class RadioGroupFieldEditor
extends FieldEditor {
    protected String[] values;
    protected String[] labels;
    protected int numColumns;
    protected int indent = 8;
    protected String value;
    protected Composite radioBox;
    protected Button[] radioButtons;
    protected boolean useGroup;

    protected RadioGroupFieldEditor() {
    }

    public RadioGroupFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int numColumns, String[] values, String[] labels, Composite parent, boolean isEnabled, boolean isRemovable) {
        this(page, tab, service, level, name, labelText, numColumns, values, labels, parent, false);
    }

    public RadioGroupFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int numColumns, String[] values, String[] labels, Composite parent, boolean useGroup) {
        super(page, tab, service, level, name, labelText, parent);
        Assert.isTrue((values.length == labels.length ? 1 : 0) != 0);
        this.values = values;
        this.numColumns = numColumns;
        this.useGroup = useGroup;
        this.labels = labels;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        ((GridData)this.radioBox.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        if (this.useGroup) {
            Composite control = this.getRadioBoxControl(parent);
            GridData gd = new GridData(768);
            control.setLayoutData((Object)gd);
        } else {
            Label control = this.getLabelControl(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = numColumns;
            control.setLayoutData((Object)gd);
            control = this.getRadioBoxControl(parent);
            gd = new GridData();
            gd.horizontalSpan = numColumns;
            gd.horizontalIndent = this.indent;
            control.setLayoutData((Object)gd);
        }
    }

    protected void doSetToolTip() {
        if (this.toolTipText != null) {
            this.getRadioBoxControl().setToolTipText(this.toolTipText);
        }
    }

    protected void doLoad() {
        if (this.radioButtons != null) {
            String value = null;
            if (this.preferencesLevel != null) {
                value = this.preferencesService.getStringPreference(this.preferencesLevel, this.getPreferenceName());
                this.levelFromWhichLoaded = this.preferencesLevel;
                this.setInherited(false);
            } else {
                value = this.preferencesService.getStringPreference(this.getPreferenceName());
                this.levelFromWhichLoaded = this.preferencesService.getApplicableLevel(this.getPreferenceName(), this.preferencesLevel);
                this.setInherited(true);
            }
            if ("default".equals(this.levelFromWhichLoaded)) {
                this.setPresentsDefaultValue(true);
            }
            this.setPreviousStringValue(value);
            this.updateValue(value);
        }
    }

    protected void doLoadDefault() {
        if (this.radioButtons != null) {
            String value = this.preferencesService.getStringPreference("default", this.getPreferenceName());
            this.updateValue(value);
        }
    }

    protected void doLoadLevel(String level) {
        if (this.radioButtons != null) {
            String value = null;
            value = this.preferencesLevel != null ? this.preferencesService.getStringPreference(level, this.getPreferenceName()) : this.preferencesService.getStringPreference(this.getPreferenceName());
            this.updateValue(value);
        }
    }

    protected String doLoadWithInheritance() {
        String levelLoaded = null;
        String[] levels = IPreferencesService.levels;
        int fieldLevelIndex = 0;
        String tmpPreferencesLevel = this.preferencesLevel == null ? levels[0] : this.preferencesLevel;
        for (int i = 0; i < levels.length; ++i) {
            if (!tmpPreferencesLevel.equals(levels[i])) continue;
            fieldLevelIndex = i;
            break;
        }
        String value = null;
        int levelAtWhichFound = -1;
        for (int level = fieldLevelIndex; level < levels.length; ++level) {
            value = this.preferencesService.getStringPreference(levels[level], this.getPreferenceName());
            if (value == null) continue;
            levelAtWhichFound = level;
            levelLoaded = levels[levelAtWhichFound];
            break;
        }
        this.setInherited(fieldLevelIndex != levelAtWhichFound);
        this.updateValue(value);
        this.fieldModified = false;
        this.setPreviousStringValue(value);
        this.setFieldColors();
        return levelLoaded;
    }

    protected void setFieldColors() {
        Composite buttonBox = this.getRadioBoxControl(this.parent);
        Color color = this.isInherited() ? PreferencesUtilities.colorBluish : PreferencesUtilities.colorWhite;
        buttonBox.setBackground(PreferencesUtilities.colorWhite);
        if (this.radioButtons != null) {
            for (int i = 0; i < this.radioButtons.length; ++i) {
                this.radioButtons[i].setBackground(color);
            }
        }
    }

    protected void doStore() {
        String value = this.getStringValue();
        boolean isEmpty = value.equals("");
        if (isEmpty) {
            this.preferencesService.clearPreferenceAtLevel(this.preferencesLevel, this.getPreferenceName());
            this.loadWithInheritance();
            return;
        }
        if (this.isInherited() && !this.fieldModified) {
            return;
        }
        this.preferencesService.setStringPreference(this.preferencesLevel, this.getPreferenceName(), value);
        this.fieldModified = false;
        this.levelFromWhichLoaded = this.preferencesLevel;
        this.setInherited(false);
        this.setPresentsDefaultValue(value.equals(this.preferencesService.getStringPreference("default", this.getPreferenceName())));
        this.setFieldColors();
        IEclipsePreferences node = this.preferencesService.getNodeForLevel(this.preferencesLevel);
        try {
            if (node != null) {
                node.flush();
            }
        }
        catch (BackingStoreException e) {
            System.err.println("RadioGroupFieldEditor.doStore():  BackingStoreException flushing node;  node may not have been flushed:\n\tnode path = " + node.absolutePath() + ", preferences level = " + this.preferencesLevel);
        }
    }

    public void setModifiedMarkOnLabel() {
        if (this.radioBox != null && this.useGroup) {
            Group radioGroup = (Group)this.radioBox;
            radioGroup.setForeground(PreferencesUtilities.colorRed);
        }
    }

    public void clearModifiedMarkOnLabel() {
        if (this.radioBox != null && this.useGroup) {
            Group radioGroup = (Group)this.radioBox;
            radioGroup.setForeground(PreferencesUtilities.colorBlack);
        }
    }

    public Composite getRadioBoxControl() {
        Composite radioBox = this.getRadioBoxControl(this.parent);
        return radioBox;
    }

    public Composite getRadioBoxControl(Composite parent) {
        if (this.radioBox == null) {
            Font font = parent.getFont();
            if (this.useGroup) {
                Group group = new Group(parent, 0);
                group.setFont(font);
                String text = this.getLabelText();
                if (text != null) {
                    group.setText(text);
                }
                this.radioBox = group;
                GridLayout layout = new GridLayout();
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)layout);
            } else {
                this.radioBox = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)layout);
                this.radioBox.setFont(font);
            }
            this.radioButtons = new Button[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                Button radio;
                this.radioButtons[i] = radio = new Button(this.radioBox, 16400);
                radio.setText(this.labels[i]);
                radio.setData((Object)this.values[i]);
                radio.setFont(font);
                radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        RadioGroupFieldEditor.this.value = (String)event.widget.getData();
                        RadioGroupFieldEditor.this.setPresentsDefaultValue(false);
                        RadioGroupFieldEditor.this.setInherited(false);
                    }
                });
            }
            this.radioBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    RadioGroupFieldEditor.this.radioBox = null;
                    RadioGroupFieldEditor.this.radioButtons = null;
                }
            });
        } else {
            this.checkParent((Control)this.radioBox, parent);
        }
        return this.radioBox;
    }

    public Composite getHolder() {
        return this.getRadioBoxControl().getParent();
    }

    public void setFieldValueFromOutside(String newValue) {
        this.setPreviousStringValue(this.getStringValue());
        this.setInherited(false);
        this.setPresentsDefaultValue(false);
        this.levelFromWhichLoaded = null;
        this.updateValue(newValue);
    }

    protected void updateValue(String selectedValue) {
        this.value = selectedValue;
        if (this.radioButtons == null) {
            return;
        }
        this.setPreviousStringValue(this.getStringValue());
        boolean found = false;
        if (this.value != null) {
            for (int i = 0; i < this.radioButtons.length; ++i) {
                Button radio = this.radioButtons[i];
                boolean selection = false;
                if (((String)radio.getData()).equals(this.value)) {
                    selection = true;
                    found = true;
                }
                radio.setSelection(selection);
            }
        }
        if (!found && this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
            this.value = (String)this.radioButtons[0].getData();
            found = true;
        }
        if (found) {
            this.valueChanged();
        }
    }

    protected boolean valueChanged() {
        return this.valueChanged(false);
    }

    protected boolean valueChanged(boolean assumeChanged) {
        boolean valueChanged = assumeChanged || this.inheritanceChanged();
        String newValue = this.getStringValue();
        if (!valueChanged && !newValue.equals(this.getPreviousStringValue())) {
            valueChanged = true;
        }
        if (valueChanged) {
            this.fireValueChanged("field_editor_value", this.getPreviousStringValue(), newValue);
            this.fieldModified = true;
            this.setPreviousStringValue(newValue);
            this.setModifiedMarkOnLabel();
        }
        return valueChanged;
    }

    public Button[] getRadioButtons() {
        return this.radioButtons;
    }

    protected String getPreviousStringValue() {
        return (String)this.previousValue;
    }

    protected void setPreviousStringValue(String value) {
        this.previousValue = value;
    }

    public String getStringValue() {
        return this.value;
    }

    public String getSpecialStringValue() {
        if (!this.hasSpecialValue) {
            throw new IllegalStateException("RadioGroupFieldEditor.getSpecialValue():  field does not have a special value");
        }
        return (String)this.specialValue;
    }

    public void setSpecialValue(String specialValue) {
        if (!this.hasSpecialValue()) {
            throw new IllegalStateException("RadioGroupFieldEditor.setSpecialValue(String): field has no special value");
        }
        if (specialValue == null || specialValue == "") {
            throw new IllegalArgumentException("RadioGroupFieldEditor.setSpecialValue(String):  special value cannot be null or empty");
        }
        this.specialValue = specialValue;
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        if (!this.useGroup) {
            super.setEnabled(enabled, parent);
        }
        for (int i = 0; i < this.radioButtons.length; ++i) {
            this.radioButtons[i].setEnabled(enabled);
        }
    }
}

