/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.parser;

import org.eclipse.imp.services.ILanguageSyntaxProperties;

public class PrefspecsSyntaxProperties
implements ILanguageSyntaxProperties {
    public String getBlockCommentEnd() {
        return null;
    }

    public String getBlockCommentStart() {
        return null;
    }

    public String getSingleLineCommentPrefix() {
        return "//";
    }

    public String getBlockCommentContinuation() {
        return null;
    }

    public String[][] getFences() {
        return new String[][]{{"{", "}"}};
    }

    public String getIdentifierConstituentChars() {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    }

    public int[] getIdentifierComponents(String ident) {
        if (ident == null) {
            return new int[0];
        }
        if (ident.length() == 1) {
            return new int[]{0};
        }
        int[] breaks = new int[ident.length()];
        for (int i = 0; i < ident.length() - 1; ++i) {
            String remainder = ident.substring(i);
            String first = remainder.substring(0, 1);
            String firstLC = first.substring(0, 1).toLowerCase();
            String second = remainder.substring(1, 2);
            String secondLC = second.substring(0, 1).toLowerCase();
            if (this.isLower(first, firstLC) && this.isUpper(second, secondLC)) {
                breaks = this.addIfAbsent(breaks, i + 1);
                continue;
            }
            if (this.isUpper(first, firstLC) && this.isLower(second, secondLC)) {
                breaks = this.addIfAbsent(breaks, i);
                continue;
            }
            if (this.isDigit(ident, i) && !this.isDigit(ident, i + 1)) {
                breaks = this.addIfAbsent(breaks, i + 1);
                continue;
            }
            if (this.isDigit(ident, i) || !this.isDigit(ident, i + 1)) continue;
            breaks = this.addIfAbsent(breaks, i + 1);
        }
        int numBreakPositions = 1;
        for (int last = breaks.length - 1; last > 0; --last) {
            if (breaks[last] <= 0) continue;
            numBreakPositions = last + 1;
            break;
        }
        int[] result = new int[numBreakPositions];
        System.arraycopy(breaks, 0, result, 0, numBreakPositions);
        return result;
    }

    public int[] addIfAbsent(int[] a, int i) {
        for (int j = 0; j < a.length; ++j) {
            if (a[j] == i) {
                return a;
            }
            if (j > 0 && a[j] == 0) break;
        }
        a[j] = i;
        return a;
    }

    public boolean isLower(String s, String l) {
        boolean result = s.compareTo(l) == 0;
        return result;
    }

    public boolean isUpper(String s, String l) {
        boolean result = s.compareTo(l) < 0;
        return result;
    }

    public boolean isDigit(String s, int pos) {
        char c = s.charAt(pos);
        boolean result = c >= '0' && c <= '9';
        return result;
    }

    public boolean isSpecial(String s, int pos) {
        char c = s.charAt(pos);
        switch (c) {
            case '-': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }
}

