/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints.fastrep;

import org.eclipse.imp.analysis.type.constraints.bindings.ITypeBinding;
import org.eclipse.imp.analysis.type.constraints.fastrep.AbstractTypeVariable;
import org.eclipse.imp.analysis.type.constraints.fastrep.TType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TypeEnvironment;
import org.eclipse.imp.analysis.type.constraints.fastrep.WildcardType;
import org.eclipse.imp.core.Assert;
import org.eclipse.imp.model.ISourceProject;

public final class CaptureType
extends AbstractTypeVariable {
    private WildcardType fWildcard;
    private ISourceProject fSrcProject;

    protected CaptureType(TypeEnvironment environment) {
        super(environment);
    }

    protected void initialize(ITypeBinding binding, ISourceProject javaProject) {
        Assert.isTrue((boolean)binding.isCapture());
        super.initialize(binding);
        this.fWildcard = (WildcardType)this.getEnvironment().create(binding.getWildcard());
        this.fSrcProject = javaProject;
    }

    public int getKind() {
        return 13;
    }

    public WildcardType getWildcard() {
        return this.fWildcard;
    }

    public boolean doEquals(TType type) {
        return this.getBindingKey().equals(((CaptureType)type).getBindingKey()) && this.fSrcProject.equals(((CaptureType)type).fSrcProject);
    }

    public int hashCode() {
        return this.getBindingKey().hashCode();
    }

    protected boolean doCanAssignTo(TType lhs) {
        switch (lhs.getKind()) {
            case 1: 
            case 2: {
                return false;
            }
            case 3: 
            case 4: {
                return this.canAssignFirstBoundTo(lhs);
            }
            case 6: {
                return false;
            }
            case 5: 
            case 7: 
            case 8: {
                return this.canAssignOneBoundTo(lhs);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)lhs).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)lhs).checkLowerBound(this.getWildcard());
            }
        }
        return false;
    }

    protected boolean checkLowerBound(TType rhs) {
        if (!this.getWildcard().isSuperWildcardType()) {
            return false;
        }
        return rhs.canAssignTo(this.getWildcard().getBound());
    }

    private boolean canAssignFirstBoundTo(TType lhs) {
        if (this.fWildcard.isExtendsWildcardType() && this.fWildcard.getBound().isArrayType()) {
            return this.fWildcard.getBound().canAssignTo(lhs);
        }
        return false;
    }

    public String getName() {
        return "";
    }

    protected String getPlainPrettySignature() {
        return "capture-of " + this.fWildcard.getPrettySignature();
    }
}

