/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.spec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.imp.formatting.spec.Item;
import org.eclipse.imp.formatting.spec.Rule;
import org.eclipse.imp.formatting.spec.Separator;
import org.eclipse.imp.formatting.spec.Specification;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unparser {
    private Document dom;

    public String unparse(Specification spec) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.newDocument();
            Element root = this.dom.createElement("formatter");
            this.addSpec(spec, root);
            this.dom.appendChild(root);
            return this.printToString(this.dom);
        }
        catch (ParserConfigurationException pce) {
            return null;
        }
    }

    private String printToString(Document dom) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(dom), new StreamResult(output));
            String result = output.toString();
            output.close();
            return result;
        }
        catch (IOException ie) {
            ie.printStackTrace();
            return "";
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void addSpec(Specification spec, Element root) {
        Element language = this.dom.createElement("language");
        language.setTextContent(spec.getLanguage());
        Element rules = this.dom.createElement("rules");
        this.addRules(spec.ruleIterator(), rules);
        Element options = this.dom.createElement("space-options");
        this.addOptions(spec, options);
        Element example = this.dom.createElement("example");
        example.setTextContent(spec.getExample());
        root.appendChild(language);
        root.appendChild(rules);
        root.appendChild(options);
        root.appendChild(example);
    }

    private void addRules(Iterator<Item> list, Element rules) {
        while (list.hasNext()) {
            Element elem;
            Item item = list.next();
            if (item instanceof Rule) {
                Rule rule = (Rule)item;
                elem = this.dom.createElement("rule");
                Element box = this.dom.createElement("box");
                elem.appendChild(box);
                box.setTextContent(rule.getBoxString());
                Element preview = this.dom.createElement("preview");
                elem.appendChild(preview);
                preview.setTextContent(rule.getPatternString());
                rules.appendChild(elem);
                continue;
            }
            if (!(item instanceof Separator)) continue;
            Separator sep = (Separator)item;
            elem = this.dom.createElement("separator");
            String label = sep.getLabel();
            elem.setTextContent(label.length() > 0 ? label : "anonymous");
            rules.appendChild(elem);
        }
    }

    private void addOptions(Specification spec, Element options) {
        Iterator<String> names = spec.getSpaceOptions();
        while (names.hasNext()) {
            String name = names.next();
            Integer value = spec.getSpaceOption(name);
            Element elem = this.dom.createElement("space-option");
            elem.setAttribute("name", name);
            elem.setAttribute("value", value.toString());
            options.appendChild(elem);
        }
    }
}

