/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RotatingQueue<T> {
    private static final int DEFAULT_CAPACITY = 16;
    private static final int DEFAULT_CAPACITY_MASK = 15;
    private T[] queue = new Object[this.capacity];
    private int capacity = 16;
    private int capacityMask = 15;
    private int nextPutIndex = 1;
    private int getIndex = 0;

    private void ensureCapacity() {
        if (this.nextPutIndex == this.getIndex) {
            int size = this.capacity;
            this.capacity <<= 1;
            this.capacityMask = this.capacity - 1;
            Object[] newQueue = new Object[this.capacity];
            if (this.getIndex == 0) {
                System.arraycopy(this.queue, 0, newQueue, 0, this.queue.length);
                this.nextPutIndex = size;
            } else {
                int numElemsTillEnd = size - this.getIndex;
                System.arraycopy(this.queue, this.getIndex, newQueue, 0, numElemsTillEnd);
                System.arraycopy(this.queue, 0, newQueue, numElemsTillEnd, this.getIndex);
                this.getIndex = 0;
                this.nextPutIndex = size;
            }
            this.queue = newQueue;
        }
    }

    public void put(T element) {
        this.ensureCapacity();
        this.queue[this.nextPutIndex] = element;
        this.nextPutIndex = this.nextPutIndex + 1 & this.capacityMask;
    }

    public boolean isEmpty() {
        return this.nextPutIndex == (this.getIndex + 1 & this.capacityMask);
    }

    public T get() {
        if (this.isEmpty()) {
            return null;
        }
        this.getIndex = this.getIndex + 1 & this.capacityMask;
        T element = this.queue[this.getIndex];
        this.queue[this.getIndex] = null;
        return element;
    }
}

