/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.spec;

import java.util.Iterator;
import org.eclipse.imp.formatting.spec.BoxEnvironment;
import org.eclipse.imp.formatting.spec.VariableEnvironment;
import org.eclipse.imp.services.IASTAdapter;

public class BoxStringBuilder {
    private IASTAdapter adapter;

    public BoxStringBuilder(IASTAdapter adapter) {
        this.adapter = adapter;
    }

    public String literal(String source, Object ast) {
        int start = this.adapter.getOffset(ast);
        int len = this.adapter.getLength(ast);
        if (len != 0) {
            int end = start + len;
            String term = source.substring(start, end);
            return "\"" + term.replaceAll("\\\\", "\\\\\\\\").replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t").replaceAll("\"", "\\\\\"") + "\"";
        }
        return "";
    }

    public String substitute(String pattern, VariableEnvironment variables, BoxEnvironment boxes) {
        Iterator iter = variables.keySet().iterator();
        String current = pattern;
        while (iter.hasNext()) {
            Object var = iter.next();
            Object val = variables.get(var);
            String box = (String)boxes.get(val);
            current = this.replaceAll(current, var.toString(), box);
        }
        return current;
    }

    private String replaceAll(String boxString, String var, String val) {
        int i;
        while ((i = boxString.indexOf(var)) != -1) {
            boxString = boxString.substring(0, i - 1) + val + boxString.substring(i + var.length() + 1);
        }
        return boxString;
    }

    public String defaultWrapper(String source, Object ast, Object[] kids, BoxEnvironment boxes) {
        if (this.adapter.isList(ast)) {
            return this.buildList(source, kids, boxes);
        }
        if (this.isExpressionStructured(kids)) {
            return this.buildBox(source, "H", kids, boxes);
        }
        if (this.isBlockStructured(kids)) {
            return this.buildBlock(source, kids, boxes);
        }
        return this.buildBox(source, "V", kids, boxes);
    }

    private boolean isExpressionStructured(Object[] kids) {
        int len = kids.length;
        if (len == 2) {
            return true;
        }
        return len == 3 && this.adapter.getChildren(kids[1]).length == 0;
    }

    private boolean isBlockStructured(Object[] kids) {
        int len = kids.length;
        if (len >= 3) {
            Object first = kids[0];
            Object last = kids[len - 1];
            int lenFirst = this.adapter.getChildren(first).length;
            int lenLast = this.adapter.getChildren(last).length;
            if (lenFirst == 0 && lenLast == 0) {
                return true;
            }
        }
        return false;
    }

    private String buildBox(String source, String op, Object[] kids, BoxEnvironment boxes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(op + " [");
        for (int i = 0; i < kids.length; ++i) {
            if (i != 0) {
                this.appendSeparatorsAndComments(buffer, source, kids[i - 1], kids[i]);
            }
            String box = (String)boxes.get(kids[i]);
            assert (box != null);
            buffer.append(box);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String exampleToBox(String source) {
        String[] nonWhitespace = source.split("[\\s]");
        StringBuffer result = new StringBuffer();
        result.append("HV [");
        for (int i = 0; i < nonWhitespace.length; ++i) {
            String word = nonWhitespace[i];
            if (word.length() <= 0) continue;
            result.append("\"" + word.replaceAll("\"", "\\\"") + "\" ");
        }
        result.append("]");
        return result.toString();
    }

    private void appendSeparatorsAndComments(StringBuffer buffer, String source, Object first, Object second) {
        int startFirst = this.adapter.getOffset(first);
        int lenFirst = this.adapter.getLength(first);
        int startSecond = this.adapter.getOffset(second);
        String middle = source.substring(startFirst + lenFirst, startSecond);
        String[] nonWhitespace = middle.split("[\\s]");
        for (int i = 0; i < nonWhitespace.length; ++i) {
            if (nonWhitespace[i].length() == 0) continue;
            buffer.append("\"" + nonWhitespace[i] + "\"");
        }
    }

    private String buildList(String source, Object[] kids, BoxEnvironment boxes) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < kids.length; ++i) {
            if (i != 0) {
                this.appendSeparatorsAndComments(buffer, source, kids[i - 1], kids[i]);
            }
            String box = (String)boxes.get(kids[i]);
            assert (box != null);
            buffer.append(box);
        }
        return buffer.toString();
    }

    private String buildBlock(String source, Object[] kids, BoxEnvironment boxes) {
        assert (kids.length >= 3);
        StringBuffer buffer = new StringBuffer();
        buffer.append("V [ ");
        buffer.append((String)boxes.get(kids[0]));
        buffer.append("I is=3 [ V [");
        for (int i = 1; i < kids.length - 1; ++i) {
            if (i != 0) {
                this.appendSeparatorsAndComments(buffer, source, kids[i - 1], kids[i]);
            }
            String box = (String)boxes.get(kids[i]);
            assert (box != null);
            buffer.append(box);
        }
        buffer.append("] ]");
        buffer.append((String)boxes.get(kids[kids.length - 1]));
        buffer.append("]");
        return buffer.toString();
    }
}

