/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.annotations.NonNull;
import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ArrayLoadInstruction;
import com.ibm.wala.shrikeBT.ArrayStoreInstruction;
import com.ibm.wala.shrikeBT.BinaryOpInstruction;
import com.ibm.wala.shrikeBT.CheckCastInstruction;
import com.ibm.wala.shrikeBT.ComparisonInstruction;
import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.ConversionInstruction;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.InstanceofInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.ShiftInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.UnaryOpInstruction;
import com.ibm.wala.shrikeBT.Util;
import java.util.ArrayList;

public abstract class Decoder
implements Constants {
    private static final int UNSEEN = -1;
    private static final int INSIDE_INSTRUCTION = -2;
    private static final ExceptionHandler[] noHandlers = new ExceptionHandler[0];
    private static final Instruction[] simpleInstructions = Decoder.makeSimpleInstructions();
    private static final Instruction makeZero = ConstantInstruction.make(0);
    private Instruction[] instructions;
    private ExceptionHandler[][] handlers;
    private int[] instructionsToBytecodes;
    private final ConstantPoolReader constantPool;
    @NonNull
    private final byte[] code;
    @NonNull
    private final int[] rawHandlers;
    private int[] decodedOffset;
    private byte[] decodedSize;
    private ArrayList<Instruction> decoded;
    private int[] belongsToSub;
    private int[] JSRs;
    private RetInfo[] retInfo;

    private static int skip(int a, int b) {
        return a < b ? a : a + 1;
    }

    private static Instruction[] makeSimpleInstructions() {
        int i;
        Instruction[] table = new Instruction[256];
        table[1] = ConstantInstruction.make("L;", null);
        for (i = 2; i <= 8; ++i) {
            table[i] = ConstantInstruction.make("I", new Integer(i - 2 - 1));
        }
        for (i = 9; i <= 10; ++i) {
            table[i] = ConstantInstruction.make("J", new Long(i - 9));
        }
        for (i = 11; i <= 13; ++i) {
            table[i] = ConstantInstruction.make("F", new Float(i - 11));
        }
        for (i = 14; i <= 15; ++i) {
            table[i] = ConstantInstruction.make("D", new Double(i - 14));
        }
        for (i = 26; i <= 45; ++i) {
            table[i] = LoadInstruction.make(indexedTypes[(i - 26) / 4], (i - 26) % 4);
        }
        for (i = 46; i <= 53; ++i) {
            table[i] = ArrayLoadInstruction.make(indexedTypes[i - 46]);
        }
        for (i = 59; i <= 78; ++i) {
            table[i] = StoreInstruction.make(indexedTypes[(i - 59) / 4], (i - 59) % 4);
        }
        for (i = 79; i <= 86; ++i) {
            table[i] = ArrayStoreInstruction.make(indexedTypes[i - 79]);
        }
        table[87] = PopInstruction.make(1);
        table[89] = DupInstruction.make(1, 0);
        table[90] = DupInstruction.make(1, 1);
        table[95] = SwapInstruction.make();
        for (i = 96; i <= 115; ++i) {
            table[i] = BinaryOpInstruction.make(indexedTypes[(i - 96) % 4], BinaryOpInstruction.Operator.values()[(i - 96) / 4]);
        }
        for (i = 116; i <= 119; ++i) {
            table[i] = UnaryOpInstruction.make(indexedTypes[i - 116], UnaryOpInstruction.Operator.NEG);
        }
        for (i = 120; i <= 125; ++i) {
            table[i] = ShiftInstruction.make(indexedTypes[(i - 120) % 2], ShiftInstruction.Operator.values()[(i - 120) / 2]);
        }
        for (i = 126; i <= 131; ++i) {
            table[i] = BinaryOpInstruction.make(indexedTypes[(i - 126) % 2], BinaryOpInstruction.Operator.values()[BinaryOpInstruction.Operator.AND.ordinal() + (i - 126) / 2]);
        }
        for (i = 133; i <= 144; ++i) {
            table[i] = ConversionInstruction.make(indexedTypes[(i - 133) / 3], indexedTypes[Decoder.skip((i - 133) % 3, (i - 133) / 3)]);
        }
        for (i = 145; i <= 147; ++i) {
            table[i] = ConversionInstruction.make("I", indexedTypes[5 + (i - 145)]);
        }
        table[148] = ComparisonInstruction.make("J", ComparisonInstruction.Operator.CMP);
        for (i = 149; i <= 152; ++i) {
            table[i] = ComparisonInstruction.make(indexedTypes[2 + (i - 149) / 2], ComparisonInstruction.Operator.values()[ComparisonInstruction.Operator.CMPL.ordinal() + (i - 149) % 2]);
        }
        for (i = 172; i <= 176; ++i) {
            table[i] = ReturnInstruction.make(indexedTypes[i - 172]);
        }
        table[177] = ReturnInstruction.make("V");
        table[191] = ThrowInstruction.make();
        table[194] = MonitorInstruction.make(true);
        table[195] = MonitorInstruction.make(false);
        table[190] = ArrayLengthInstruction.make();
        return table;
    }

    protected Decoder(byte[] code, int[] rawHandlers, ConstantPoolReader cp) {
        this.code = code;
        this.rawHandlers = rawHandlers;
        this.constantPool = cp;
    }

    public ConstantPoolReader getConstantPool() {
        return this.constantPool;
    }

    private int decodeShort(int index) {
        return this.code[index] << 8 | this.code[index + 1] & 0xFF;
    }

    private int decodeUShort(int index) {
        return (this.code[index] & 0xFF) << 8 | this.code[index + 1] & 0xFF;
    }

    private int decodeInt(int index) {
        return this.code[index] << 24 | (this.code[index + 1] & 0xFF) << 16 | (this.code[index + 2] & 0xFF) << 8 | this.code[index + 3] & 0xFF;
    }

    private Instruction makeConstantPoolLoad(int index) throws InvalidBytecodeException {
        ConstantInstruction ci = ConstantInstruction.make(this.constantPool, index);
        if (ci == null) {
            throw new InvalidBytecodeException("Constant pool item at index " + index + " (type " + this.constantPool.getConstantPoolItemType(index) + ") cannot be loaded");
        }
        return ci;
    }

    private static int elemCount(byte[] stack, int stackPtr) throws InvalidBytecodeException {
        if (stackPtr < 0) {
            throw new InvalidBytecodeException("Stack underflow");
        }
        if (stack[stackPtr] == 2) {
            return 1;
        }
        if (stackPtr < 1) {
            throw new InvalidBytecodeException("Stack underflow");
        }
        if (stack[stackPtr - 1] != 1) {
            throw new InvalidBytecodeException("Trying to manipulate a pair of one-word items but one of them is two words");
        }
        return 2;
    }

    private String getPrimitiveType(int t) throws InvalidBytecodeException {
        switch (t) {
            case 4: {
                return "Z";
            }
            case 5: {
                return "C";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "D";
            }
            case 8: {
                return "B";
            }
            case 9: {
                return "S";
            }
            case 10: {
                return "I";
            }
            case 11: {
                return "J";
            }
        }
        throw new InvalidBytecodeException("Unknown primitive type " + t);
    }

    private boolean doesSubroutineReturn(int sub) {
        for (int j = 0; j < this.retInfo.length; ++j) {
            if (this.retInfo[j] == null || this.retInfo[j].sub != sub) continue;
            return true;
        }
        return false;
    }

    private int findReturnToVar(int v, int addr, boolean[] visited) throws InvalidBytecodeException {
        while (!visited[addr]) {
            int j;
            if (this.retInfo[addr] != null && this.retInfo[addr].retVar == v) {
                return addr;
            }
            int offset = this.decodedOffset[addr];
            if (offset == -1) {
                return 0;
            }
            int size = this.decodedSize[addr];
            Instruction instr = null;
            visited[addr] = true;
            for (j = 0; j < this.rawHandlers.length; j += 4) {
                int r;
                if (this.rawHandlers[j] > addr || addr >= this.rawHandlers[j + 1]) continue;
                int handlerAddr = this.rawHandlers[j + 2];
                if (this.decodedOffset[handlerAddr] < 0) {
                    byte[] stackWords = new byte[this.code.length * 2];
                    this.decodeAt(handlerAddr, 1, stackWords);
                }
                if ((r = this.findReturnToVar(v, handlerAddr, visited)) == 0) continue;
                return r;
            }
            if (this.JSRs[addr] != 0) {
                if (!this.doesSubroutineReturn(this.JSRs[addr])) {
                    return 0;
                }
            } else {
                for (j = 0; j < size; ++j) {
                    instr = this.decoded.get(offset + j);
                    if (instr instanceof StoreInstruction && ((StoreInstruction)instr).getVarIndex() == v) {
                        return 0;
                    }
                    int[] targets = instr.getBranchTargets();
                    for (int k = 0; k < targets.length; ++k) {
                        int r;
                        if (targets[k] < 0 || (r = this.findReturnToVar(v, targets[k], visited)) == 0) continue;
                        return r;
                    }
                }
                if (instr != null && !instr.isFallThrough()) {
                    return 0;
                }
            }
            while (this.decodedOffset[++addr] == -2) {
            }
        }
        return 0;
    }

    private int findReturn(int subAddr) throws InvalidBytecodeException {
        if (this.decodedSize[subAddr] < 1) {
            throw new InvalidBytecodeException("Subroutine at " + subAddr + " does not start with an astore or pop instruction");
        }
        Instruction instr = this.decoded.get(this.decodedOffset[subAddr]);
        if (instr instanceof PopInstruction) {
            return 0;
        }
        if (!(instr instanceof StoreInstruction)) {
            throw new InvalidBytecodeException("Subroutine at " + subAddr + " does not start with an astore or pop instruction");
        }
        int localIndex = ((StoreInstruction)instr).getVarIndex();
        while (this.decodedOffset[++subAddr] == -2) {
        }
        return this.findReturnToVar(localIndex, subAddr, new boolean[this.code.length]);
    }

    private void decodeSubroutine(int jsrAddr, int retToAddr, int subAddr, int stackLen, byte[] stackWords) throws InvalidBytecodeException {
        int retAddr;
        if (this.JSRs == null) {
            this.JSRs = new int[this.code.length];
            this.retInfo = new RetInfo[this.code.length];
        }
        this.JSRs[jsrAddr] = subAddr;
        if (this.decodedOffset[subAddr] < 0) {
            stackWords[stackLen] = 1;
            this.decodeAt(subAddr, ++stackLen, stackWords);
        }
        if ((retAddr = this.findReturn(subAddr)) > 0) {
            RetInfo r = this.retInfo[retAddr];
            r.sub = subAddr;
            this.decodeAt(retToAddr, r.stackLen, (byte[])r.stackWords.clone());
        }
    }

    private void assignReachablesToSubroutine(int addr, int sub) {
        while (this.belongsToSub[addr] < 0) {
            byte size = this.decodedSize[addr];
            this.belongsToSub[addr] = sub;
            for (int j = 0; j < this.rawHandlers.length; j += 4) {
                if (this.rawHandlers[j] > addr || addr >= this.rawHandlers[j + 1]) continue;
                this.assignReachablesToSubroutine(this.rawHandlers[j + 2], sub);
            }
            Instruction instr = null;
            if (size > 0 && this.JSRs[addr] == 0) {
                int offset = this.decodedOffset[addr];
                instr = this.decoded.get(offset + size - 1);
                int[] targets = instr.getBranchTargets();
                for (int k = 0; k < targets.length; ++k) {
                    if (targets[k] < 0) continue;
                    this.assignReachablesToSubroutine(targets[k], sub);
                }
            }
            if (instr != null && !instr.isFallThrough()) {
                return;
            }
            if (this.JSRs[addr] != 0 && !this.doesSubroutineReturn(this.JSRs[addr])) {
                return;
            }
            while (this.decodedOffset[++addr] < 0) {
            }
        }
    }

    private void assignSubroutine(int sub) {
        this.assignReachablesToSubroutine(sub, sub);
        for (int i = 0; i < this.belongsToSub.length; ++i) {
            if (this.JSRs[i] <= 0 || this.belongsToSub[i] != sub || this.belongsToSub[this.JSRs[i]] >= 0) continue;
            this.assignSubroutine(this.JSRs[i]);
        }
    }

    private void computeSubroutineMap() {
        this.belongsToSub = new int[this.code.length];
        for (int i = 0; i < this.belongsToSub.length; ++i) {
            this.belongsToSub[i] = -1;
        }
        this.assignSubroutine(0);
    }

    private int decodeBytecodeInstruction(int index, int stackLen, byte[] stackWords) throws InvalidBytecodeException {
        int opcode = this.code[index] & 0xFF;
        Instruction i = simpleInstructions[opcode];
        if (i != null) {
            this.decoded.add(i);
            return index + 1;
        }
        boolean wide = false;
        block38: while (true) {
            ++index;
            switch (opcode) {
                case 0: {
                    break block38;
                }
                case 16: {
                    i = ConstantInstruction.make(this.code[index]);
                    ++index;
                    break block38;
                }
                case 17: {
                    i = ConstantInstruction.make(this.decodeShort(index));
                    index += 2;
                    break block38;
                }
                case 18: {
                    i = this.makeConstantPoolLoad(this.code[index] & 0xFF);
                    ++index;
                    break block38;
                }
                case 19: {
                    i = this.makeConstantPoolLoad(this.decodeShort(index));
                    index += 2;
                    break block38;
                }
                case 20: {
                    i = this.makeConstantPoolLoad(this.decodeShort(index));
                    index += 2;
                    break block38;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    i = LoadInstruction.make(indexedTypes[opcode - 21], wide ? this.decodeUShort(index) : this.code[index] & 0xFF);
                    index += wide ? 2 : 1;
                    break block38;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    i = StoreInstruction.make(indexedTypes[opcode - 54], wide ? this.decodeUShort(index) : this.code[index] & 0xFF);
                    index += wide ? 2 : 1;
                    break block38;
                }
                case 88: {
                    i = PopInstruction.make(Decoder.elemCount(stackWords, stackLen - 1));
                    break block38;
                }
                case 91: {
                    i = DupInstruction.make(1, Decoder.elemCount(stackWords, stackLen - 2));
                    break block38;
                }
                case 92: {
                    i = DupInstruction.make(Decoder.elemCount(stackWords, stackLen - 1), 0);
                    break block38;
                }
                case 93: {
                    i = DupInstruction.make(Decoder.elemCount(stackWords, stackLen - 1), 1);
                    break block38;
                }
                case 94: {
                    i = DupInstruction.make(Decoder.elemCount(stackWords, stackLen - 1), Decoder.elemCount(stackWords, stackLen - 2));
                    break block38;
                }
                case 132: {
                    int v = wide ? this.decodeUShort(index) : this.code[index] & 0xFF;
                    int c = wide ? this.decodeShort(index + 2) : this.code[index + 1];
                    this.decoded.add(LoadInstruction.make("I", v));
                    this.decoded.add(ConstantInstruction.make(c));
                    this.decoded.add(BinaryOpInstruction.make("I", BinaryOpInstruction.Operator.ADD));
                    i = StoreInstruction.make("I", v);
                    index += wide ? 4 : 2;
                    break block38;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    this.decoded.add(makeZero);
                    i = ConditionalBranchInstruction.make("I", ConditionalBranchInstruction.Operator.values()[opcode - 153], index - 1 + this.decodeShort(index));
                    index += 2;
                    break block38;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    i = ConditionalBranchInstruction.make((short)opcode, index - 1 + this.decodeShort(index));
                    index += 2;
                    break block38;
                }
                case 165: 
                case 166: {
                    i = ConditionalBranchInstruction.make("Ljava/lang/Object;", ConditionalBranchInstruction.Operator.values()[opcode - 165], index - 1 + this.decodeShort(index));
                    index += 2;
                    break block38;
                }
                case 167: {
                    i = GotoInstruction.make(index - 1 + this.decodeShort(index));
                    index += 2;
                    break block38;
                }
                case 168: {
                    index += 2;
                    break block38;
                }
                case 201: {
                    index += 4;
                    break block38;
                }
                case 169: {
                    int v = wide ? this.decodeUShort(index) : this.code[index] & 0xFF;
                    i = GotoInstruction.make(-1 - v);
                    if (this.retInfo == null) {
                        throw new InvalidBytecodeException("'ret' outside of subroutine");
                    }
                    this.retInfo[index - (wide ? 2 : 1)] = new RetInfo(-1, v, stackLen, stackWords);
                    index += wide ? 2 : 1;
                    break block38;
                }
                case 170: {
                    int start = index - 1;
                    while ((index & 3) != 0) {
                        ++index;
                    }
                    int def = start + this.decodeInt(index);
                    int low = this.decodeInt(index + 4);
                    int high = this.decodeInt(index + 8);
                    int[] t = new int[(high - low + 1) * 2];
                    for (int j = 0; j < t.length; j += 2) {
                        t[j] = j / 2 + low;
                        t[j + 1] = start + this.decodeInt(index + 12 + j * 2);
                    }
                    i = SwitchInstruction.make(t, def);
                    index += 12 + (high - low + 1) * 4;
                    break block38;
                }
                case 171: {
                    int start = index - 1;
                    while ((index & 3) != 0) {
                        ++index;
                    }
                    int def = start + this.decodeInt(index);
                    int n = this.decodeInt(index + 4);
                    int[] t = new int[n * 2];
                    for (int j = 0; j < t.length; j += 2) {
                        t[j] = this.decodeInt(index + 8 + j * 4);
                        t[j + 1] = start + this.decodeInt(index + 12 + j * 4);
                    }
                    i = SwitchInstruction.make(t, def);
                    index += 8 + n * 8;
                    break block38;
                }
                case 178: 
                case 180: {
                    int f = this.decodeUShort(index);
                    i = GetInstruction.make(this.constantPool, f, opcode == 178);
                    index += 2;
                    break block38;
                }
                case 179: 
                case 181: {
                    int f = this.decodeUShort(index);
                    i = PutInstruction.make(this.constantPool, f, opcode == 179);
                    index += 2;
                    break block38;
                }
                case 182: 
                case 183: 
                case 184: {
                    int m = this.decodeUShort(index);
                    i = InvokeInstruction.make(this.constantPool, m, opcode);
                    index += 2;
                    break block38;
                }
                case 185: {
                    int m = this.decodeUShort(index);
                    i = InvokeInstruction.make(this.constantPool, m, opcode);
                    index += 4;
                    break block38;
                }
                case 187: {
                    i = NewInstruction.make(this.constantPool.getConstantPoolClassType(this.decodeUShort(index)), 0);
                    index += 2;
                    break block38;
                }
                case 188: {
                    i = NewInstruction.make(Util.makeArray(this.getPrimitiveType(this.code[index])), 1);
                    ++index;
                    break block38;
                }
                case 189: {
                    i = NewInstruction.make(Util.makeArray(this.constantPool.getConstantPoolClassType(this.decodeUShort(index))), 1);
                    index += 2;
                    break block38;
                }
                case 192: {
                    i = CheckCastInstruction.make(this.constantPool.getConstantPoolClassType(this.decodeUShort(index)));
                    index += 2;
                    break block38;
                }
                case 193: {
                    i = InstanceofInstruction.make(this.constantPool.getConstantPoolClassType(this.decodeUShort(index)));
                    index += 2;
                    break block38;
                }
                case 196: {
                    wide = true;
                    opcode = this.code[index] & 0xFF;
                    continue block38;
                }
                case 197: {
                    i = NewInstruction.make(this.constantPool.getConstantPoolClassType(this.decodeUShort(index)), this.code[index + 2] & 0xFF);
                    index += 3;
                    break block38;
                }
                case 198: 
                case 199: {
                    this.decoded.add(ConstantInstruction.make("Ljava/lang/Object;", null));
                    i = ConditionalBranchInstruction.make("Ljava/lang/Object;", ConditionalBranchInstruction.Operator.values()[opcode - 198], index - 1 + this.decodeShort(index));
                    index += 2;
                    break block38;
                }
                case 200: {
                    i = GotoInstruction.make(index - 1 + this.decodeInt(index));
                    index += 4;
                    break block38;
                }
                default: {
                    throw new InvalidBytecodeException("Unknown opcode " + opcode);
                }
            }
            break;
        }
        if (i != null) {
            this.decoded.add(i);
        }
        return index;
    }

    private int applyInstructionToStack(Instruction i, int stackLen, byte[] stackWords) throws InvalidBytecodeException {
        if ((stackLen -= i.getPoppedCount()) < 0) {
            throw new InvalidBytecodeException("Stack underflow");
        }
        if (i instanceof DupInstruction) {
            DupInstruction d = (DupInstruction)i;
            int delta = d.getDelta();
            int size = d.getSize();
            System.arraycopy(stackWords, stackLen + delta, stackWords, stackLen + size + delta, size);
            System.arraycopy(stackWords, stackLen, stackWords, stackLen + size, delta);
            System.arraycopy(stackWords, stackLen + size + delta, stackWords, stackLen, size);
            stackLen += size * 2 + delta;
        } else if (i instanceof SwapInstruction) {
            if (stackWords[stackLen] != stackWords[stackLen + 1]) {
                throw new Error("OP_swap must always be swapping the same size, 1");
            }
            stackLen += 2;
        } else {
            byte pushedWords = i.getPushedWordSize();
            if (pushedWords > 0) {
                stackWords[stackLen] = pushedWords;
                ++stackLen;
            }
        }
        return stackLen;
    }

    private void decodeAt(int index, int stackLen, byte[] stackWords) throws InvalidBytecodeException {
        if (index < 0 || index >= this.decodedOffset.length) {
            throw new InvalidBytecodeException(index, "Branch index " + index + " out of range");
        }
        while (this.decodedOffset[index] < 0) {
            int newIndex;
            int s;
            this.decodedOffset[index] = s = this.decoded.size();
            try {
                int i;
                newIndex = this.decodeBytecodeInstruction(index, stackLen, stackWords);
                int instrCount = this.decoded.size() - s;
                this.decodedSize[index] = (byte)instrCount;
                for (i = index + 1; i < newIndex; ++i) {
                    this.decodedOffset[i] = -2;
                }
                if (instrCount > 0) {
                    for (i = s; i < s + instrCount; ++i) {
                        stackLen = this.applyInstructionToStack(this.decoded.get(i), stackLen, stackWords);
                    }
                    Instruction instr = this.decoded.get(s + instrCount - 1);
                    int[] targets = instr.getBranchTargets();
                    for (int i2 = 0; i2 < targets.length; ++i2) {
                        int t = targets[i2];
                        if (t < 0) continue;
                        this.decodeAt(t, stackLen, (byte[])stackWords.clone());
                    }
                    if (!instr.isFallThrough()) {
                        return;
                    }
                } else {
                    int jIndex = index;
                    int opcode = this.code[jIndex] & 0xFF;
                    if (opcode == 196) {
                        opcode = this.code[++jIndex] & 0xFF;
                    }
                    if (opcode == 168 || opcode == 201) {
                        int offset = opcode == 201 ? this.decodeInt(jIndex) : this.decodeShort(++jIndex);
                        this.decoded.add(GotoInstruction.make(0));
                        this.decodedSize[index] = 1;
                        this.decodeSubroutine(index, newIndex, index + offset, stackLen, stackWords);
                        return;
                    }
                }
            }
            catch (InvalidBytecodeException ex) {
                ex.setIndex(index);
                throw ex;
            }
            catch (Error ex) {
                System.err.println("Fatal error at index " + index);
                throw ex;
            }
            catch (RuntimeException ex) {
                System.err.println("Fatal error at index " + index);
                throw ex;
            }
            if ((index = newIndex) < this.decodedOffset.length) continue;
            throw new InvalidBytecodeException(index, "Fell off end of bytecode array");
        }
    }

    private ExceptionHandler[] makeHandlers(int i, int[] addrMap) {
        int numHandlers = 0;
        for (int j = 0; j < this.rawHandlers.length; j += 4) {
            if (this.rawHandlers[j] > i || i >= this.rawHandlers[j + 1]) continue;
            ++numHandlers;
        }
        return this.makeHandlers(i, numHandlers, addrMap);
    }

    private ExceptionHandler[] makeHandlers(int i, int numHandlers, int[] addrMap) {
        if (numHandlers == 0) {
            return noHandlers;
        }
        ExceptionHandler[] hs = new ExceptionHandler[numHandlers];
        numHandlers = 0;
        for (int j = 0; j < this.rawHandlers.length; j += 4) {
            if (this.rawHandlers[j] > i || i >= this.rawHandlers[j + 1]) continue;
            int classIndex = this.rawHandlers[j + 3];
            String catchClass = classIndex == 0 ? null : this.constantPool.getConstantPoolClassType(classIndex);
            hs[numHandlers] = new ExceptionHandler(addrMap[this.rawHandlers[j + 2]], catchClass);
            ++numHandlers;
        }
        return hs;
    }

    private int computeSubroutineLength(int sub) {
        int len = 1;
        for (int i = sub; i < this.belongsToSub.length; ++i) {
            if (this.belongsToSub[i] != sub) continue;
            len += this.decodedSize[i];
            if (this.JSRs[i] <= 0) continue;
            len += this.computeSubroutineLength(this.JSRs[i]);
        }
        return len;
    }

    private int appendSubroutineCode(int callSite, int newCodeIndex, int[] callerMap) {
        int sub;
        int i;
        this.instructions[callerMap[callSite]] = GotoInstruction.make(newCodeIndex);
        this.instructions[newCodeIndex] = ConstantInstruction.make("Ljava/lang/Object;", null);
        int subStart = ++newCodeIndex;
        int[] map = (int[])callerMap.clone();
        for (i = sub = this.JSRs[callSite]; i < this.belongsToSub.length; ++i) {
            if (this.belongsToSub[i] != sub) continue;
            int s = this.decodedSize[i];
            int offset = this.decodedOffset[i];
            map[i] = newCodeIndex;
            for (int j = 0; j < s; ++j) {
                Instruction instr;
                this.instructions[newCodeIndex] = instr = this.decoded.get(offset + j);
                this.instructionsToBytecodes[newCodeIndex] = i;
                ++newCodeIndex;
            }
        }
        for (i = subStart; i < newCodeIndex; ++i) {
            Instruction instr = this.instructions[i];
            this.instructions[i] = instr instanceof GotoInstruction && ((GotoInstruction)instr).getLabel() < 0 ? GotoInstruction.make(callerMap[callSite] + 1) : instr.redirectTargets(map);
            this.handlers[i] = this.makeHandlers(this.instructionsToBytecodes[i], map);
        }
        this.handlers[subStart - 1] = this.handlers[subStart];
        for (i = sub; i < this.belongsToSub.length; ++i) {
            if (this.belongsToSub[i] != sub || this.JSRs[i] <= 0) continue;
            newCodeIndex = this.appendSubroutineCode(i, newCodeIndex, map);
        }
        return newCodeIndex;
    }

    public final void decode() throws InvalidBytecodeException {
        int i;
        int i2;
        byte[] stackWords = new byte[this.code.length * 2];
        this.decoded = new ArrayList();
        this.decodedOffset = new int[this.code.length];
        for (i2 = 0; i2 < this.decodedOffset.length; ++i2) {
            this.decodedOffset[i2] = -1;
        }
        this.decodedSize = new byte[this.code.length];
        this.decodeAt(0, 0, stackWords);
        for (i2 = 0; i2 < this.rawHandlers.length; i2 += 4) {
            stackWords[0] = 1;
            this.decodeAt(this.rawHandlers[i2 + 2], 1, stackWords);
        }
        if (this.retInfo != null) {
            this.computeSubroutineMap();
            this.retInfo = null;
        }
        int instructionsLen = this.decoded.size();
        if (this.belongsToSub != null) {
            for (int i3 = 0; i3 < this.belongsToSub.length; ++i3) {
                if (this.belongsToSub[i3] == 0) {
                    if (this.JSRs[i3] <= 0) continue;
                    instructionsLen += this.computeSubroutineLength(this.JSRs[i3]);
                    continue;
                }
                if (this.belongsToSub[i3] <= 0) continue;
                instructionsLen -= this.decodedSize[i3];
            }
        }
        this.instructions = new Instruction[instructionsLen];
        this.instructionsToBytecodes = new int[instructionsLen];
        this.handlers = new ExceptionHandler[instructionsLen][];
        int p = 0;
        for (i = 0; i < this.decodedOffset.length; ++i) {
            int offset = this.decodedOffset[i];
            if (offset < 0 || this.belongsToSub != null && this.belongsToSub[i] != 0) continue;
            this.decodedOffset[i] = p;
            int s = this.decodedSize[i];
            for (int j = 0; j < s; ++j) {
                this.instructions[p] = this.decoded.get(offset + j);
                this.instructionsToBytecodes[p] = i;
                ++p;
            }
        }
        for (i = 0; i < p; ++i) {
            this.instructions[i] = this.instructions[i].redirectTargets(this.decodedOffset);
        }
        if (this.JSRs != null) {
            for (i = 0; i < this.JSRs.length; ++i) {
                if (this.JSRs[i] <= 0 || this.belongsToSub[i] != 0) continue;
                p = this.appendSubroutineCode(i, p, this.decodedOffset);
            }
        }
        if (this.rawHandlers.length > 0) {
            ExceptionHandler[] hs = null;
            int handlersValidBefore = -1;
            p = 0;
            for (int i4 = 0; i4 < this.decodedOffset.length; ++i4) {
                int j;
                if (this.decodedOffset[i4] < 0 || this.belongsToSub != null && this.belongsToSub[i4] != 0) continue;
                if (i4 >= handlersValidBefore) {
                    int numHandlers = 0;
                    handlersValidBefore = Integer.MAX_VALUE;
                    for (j = 0; j < this.rawHandlers.length; j += 4) {
                        if (this.rawHandlers[j] <= i4) {
                            if (i4 >= this.rawHandlers[j + 1]) continue;
                            ++numHandlers;
                            handlersValidBefore = Math.min(handlersValidBefore, this.rawHandlers[j + 1]);
                            continue;
                        }
                        handlersValidBefore = Math.min(handlersValidBefore, this.rawHandlers[j]);
                    }
                    hs = this.makeHandlers(i4, numHandlers, this.decodedOffset);
                }
                int s = this.decodedSize[i4];
                for (j = 0; j < s; ++j) {
                    this.handlers[p] = hs;
                    ++p;
                }
            }
        } else {
            for (i = 0; i < this.handlers.length; ++i) {
                this.handlers[i] = noHandlers;
            }
        }
        this.decoded = null;
        this.decodedOffset = null;
        this.decodedSize = null;
        this.belongsToSub = null;
        this.JSRs = null;
    }

    public final Instruction[] getInstructions() {
        if (this.instructions == null) {
            throw new Error("Call decode() before calling getInstructions()");
        }
        return this.instructions;
    }

    public final ExceptionHandler[][] getHandlers() {
        if (this.handlers == null) {
            throw new Error("Call decode() before calling getHandlers()");
        }
        return this.handlers;
    }

    public final int[] getInstructionsToBytecodes() {
        if (this.instructionsToBytecodes == null) {
            throw new Error("Call decode() before calling getInstructionsToBytecodes()");
        }
        return this.instructionsToBytecodes;
    }

    public static class InvalidBytecodeException
    extends Exception {
        private static final long serialVersionUID = -8807125136613458111L;
        private int index;

        InvalidBytecodeException(String s) {
            super(s);
            this.index = -1;
        }

        InvalidBytecodeException(int i, String s) {
            super(s);
            this.index = i;
        }

        void setIndex(int i) {
            if (this.index < 0) {
                this.index = i;
            }
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static class RetInfo {
        int sub;
        final int retVar;
        final int stackLen;
        final byte[] stackWords;

        RetInfo(int sub, int retVar, int stackLen, byte[] stackWords) {
            this.sub = sub;
            this.retVar = retVar;
            this.stackLen = stackLen;
            this.stackWords = stackWords;
        }
    }
}

