/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.cfg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.imp.analysis.cfg.CFGNode;
import org.eclipse.imp.analysis.cfg.SourceCFG;

public class CFGBasicBlockNode
extends CFGNode {
    public final List<Object> fASTNodes = new ArrayList<Object>();

    public CFGBasicBlockNode(Object n1) {
        this.fASTNodes.add(n1);
    }

    public CFGBasicBlockNode(CFGBasicBlockNode bb) {
        this.fASTNodes.addAll(bb.fASTNodes);
    }

    public CFGBasicBlockNode(Object n1, Object n2) {
        this.fASTNodes.add(n1);
        this.fASTNodes.add(n2);
    }

    public void appendASTNode(Object n) {
        this.fASTNodes.add(n);
    }

    public void appendASTNodesFrom(CFGBasicBlockNode n) {
        this.fASTNodes.addAll(n.fASTNodes);
    }

    public String getPrettyName() {
        StringBuffer buff = new StringBuffer();
        buff.append("{");
        Iterator<Object> iter = this.fASTNodes.iterator();
        while (iter.hasNext()) {
            Object n = iter.next();
            buff.append(SourceCFG.printRepFor(n));
            if (!iter.hasNext()) continue;
            buff.append(";");
        }
        buff.append("}");
        return buff.toString();
    }

    public boolean isStartNode() {
        return false;
    }

    public boolean isEndNode() {
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CFGBasicBlockNode)) {
            return false;
        }
        CFGBasicBlockNode other = (CFGBasicBlockNode)o;
        if (this.fASTNodes.size() != other.fASTNodes.size()) {
            return false;
        }
        for (int i = 0; i < this.fASTNodes.size(); ++i) {
            if (this.fASTNodes.get(i) == other.fASTNodes.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 13;
        for (Object n : this.fASTNodes) {
            result = result * 29 + n.hashCode();
        }
        return result;
    }
}

