/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.cfg;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.imp.analysis.cfg.CFGBasicBlockNode;
import org.eclipse.imp.analysis.cfg.CFGConditionalEdge;
import org.eclipse.imp.analysis.cfg.CFGEntryNode;
import org.eclipse.imp.analysis.cfg.CFGExceptionEdge;
import org.eclipse.imp.analysis.cfg.CFGExitNode;
import org.eclipse.imp.analysis.cfg.CFGNode;
import org.eclipse.imp.analysis.cfg.CFGPlainEdge;
import org.eclipse.imp.analysis.cfg.CFGPlainNode;
import org.eclipse.imp.analysis.cfg.CFGSimpleNode;
import org.eclipse.imp.analysis.cfg.SourceCFG;

public class CFGNodeEdgeFactory {
    private Map<Object, CFGNode> fPlainMap = new HashMap<Object, CFGNode>();
    private Map<Object, CFGNode> fEntryMap = new HashMap<Object, CFGNode>();
    private Map<Object, CFGNode> fExitMap = new HashMap<Object, CFGNode>();
    private SourceCFG fCFG;

    public CFGNodeEdgeFactory(SourceCFG cfg) {
        this.fCFG = cfg;
    }

    public CFGNode getEntryNodeFor(Object astNode) {
        CFGNode cfgNode = this.fEntryMap.get(astNode);
        if (cfgNode == null) {
            cfgNode = new CFGEntryNode(astNode);
            this.fEntryMap.put(astNode, cfgNode);
            this.fCFG.addNode(cfgNode);
        }
        return cfgNode;
    }

    public CFGNode getExitNodeFor(Object astNode) {
        CFGNode cfgNode = this.fExitMap.get(astNode);
        if (cfgNode == null) {
            cfgNode = new CFGExitNode(astNode);
            this.fExitMap.put(astNode, cfgNode);
            this.fCFG.addNode(cfgNode);
        }
        return cfgNode;
    }

    public CFGNode mergeNodes(CFGNode n1, CFGNode n2) {
        if (n1 instanceof CFGSimpleNode) {
            CFGSimpleNode node1 = (CFGSimpleNode)n1;
            if (n2 instanceof CFGSimpleNode) {
                CFGSimpleNode node2 = (CFGSimpleNode)n2;
                if (node1.fASTNode == node2.fASTNode) {
                    return this.getPlainNodeFor(node1.fASTNode);
                }
                return this.getBasicBlockNodeFor(node1.fASTNode, node2.fASTNode);
            }
            return this.getBasicBlockNodeFor(node1.fASTNode, (CFGBasicBlockNode)n2);
        }
        CFGBasicBlockNode bb1 = (CFGBasicBlockNode)n1;
        if (n2 instanceof CFGSimpleNode) {
            CFGSimpleNode node2 = (CFGSimpleNode)n2;
            return this.getBasicBlockNodeFor(bb1, node2.fASTNode);
        }
        CFGBasicBlockNode bb2 = (CFGBasicBlockNode)n2;
        return this.getBasicBlockNodeFor(bb1, bb2);
    }

    public CFGNode getPlainNodeFor(Object n) {
        CFGNode cfgNode = this.fPlainMap.get(n);
        if (cfgNode == null) {
            cfgNode = new CFGPlainNode(n);
            this.fPlainMap.put(n, cfgNode);
            this.fCFG.addNode(cfgNode);
        }
        return cfgNode;
    }

    public CFGBasicBlockNode getBasicBlockNodeFor(Object n1, Object n2) {
        CFGBasicBlockNode newNode = new CFGBasicBlockNode(n1, n2);
        this.fCFG.addNode(newNode);
        return newNode;
    }

    public CFGBasicBlockNode getBasicBlockNodeFor(CFGBasicBlockNode bb, Object n2) {
        CFGBasicBlockNode newNode = new CFGBasicBlockNode(bb);
        newNode.appendASTNode(n2);
        this.fCFG.addNode(newNode);
        return newNode;
    }

    public CFGBasicBlockNode getBasicBlockNodeFor(Object n1, CFGBasicBlockNode bb) {
        CFGBasicBlockNode newNode = new CFGBasicBlockNode(n1);
        newNode.appendASTNodesFrom(bb);
        this.fCFG.addNode(newNode);
        return newNode;
    }

    public CFGBasicBlockNode getBasicBlockNodeFor(CFGBasicBlockNode bb1, CFGBasicBlockNode bb2) {
        CFGBasicBlockNode newNode = new CFGBasicBlockNode(bb1);
        newNode.appendASTNodesFrom(bb2);
        this.fCFG.addNode(newNode);
        return newNode;
    }

    public void addEdge(CFGNode from, CFGNode to) {
        CFGPlainEdge edge = new CFGPlainEdge(from, to);
        if (this.fCFG.fDebug) {
            System.out.println(edge);
        }
        this.fCFG.addEdge(edge);
    }

    public void addConditionalEdge(CFGNode from, CFGNode to, boolean label) {
        CFGConditionalEdge edge = new CFGConditionalEdge(from, to, label);
        if (this.fCFG.fDebug) {
            System.out.println(edge);
        }
        this.fCFG.addEdge(edge);
    }

    public void addExceptionEdge(CFGNode from, CFGNode to, Object label) {
        CFGExceptionEdge<Object> edge = new CFGExceptionEdge<Object>(from, to, label);
        if (this.fCFG.fDebug) {
            System.out.println(edge);
        }
        this.fCFG.addEdge(edge);
    }
}

