/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints.fastrep;

import org.eclipse.imp.analysis.type.constraints.bindings.ITypeBinding;
import org.eclipse.imp.analysis.type.constraints.fastrep.CaptureType;
import org.eclipse.imp.analysis.type.constraints.fastrep.FastTypeAdapter;
import org.eclipse.imp.analysis.type.constraints.fastrep.GenericType;
import org.eclipse.imp.analysis.type.constraints.fastrep.HierarchyType;
import org.eclipse.imp.analysis.type.constraints.fastrep.RawType;
import org.eclipse.imp.analysis.type.constraints.fastrep.StandardType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TypeEnvironment;
import org.eclipse.imp.analysis.type.constraints.fastrep.WildcardType;
import org.eclipse.imp.core.Assert;
import org.eclipse.jdt.core.IType;

public final class ParameterizedType
extends HierarchyType {
    private GenericType fTypeDeclaration;
    private TType[] fTypeArguments;

    protected ParameterizedType(TypeEnvironment environment) {
        super(environment);
    }

    protected void initialize(ITypeBinding binding, IType javaElementType) {
        Assert.isTrue((boolean)binding.isParameterizedType());
        super.initialize(binding, javaElementType);
        TypeEnvironment environment = this.getEnvironment();
        this.fTypeDeclaration = (GenericType)environment.create(binding.getTypeDeclaration());
        ITypeBinding[] typeArguments = binding.getTypeArguments();
        this.fTypeArguments = new TType[typeArguments.length];
        for (int i = 0; i < typeArguments.length; ++i) {
            this.fTypeArguments[i] = environment.create(typeArguments[i]);
        }
    }

    public int getKind() {
        return 7;
    }

    public TType getTypeDeclaration() {
        return this.fTypeDeclaration;
    }

    public TType getErasure() {
        return this.fTypeDeclaration;
    }

    public TType[] getTypeArguments() {
        return (TType[])this.fTypeArguments.clone();
    }

    public boolean doEquals(TType type) {
        ParameterizedType other = (ParameterizedType)type;
        if (!this.fTypeDeclaration.equals(other.fTypeDeclaration)) {
            return false;
        }
        if (this.fTypeArguments.length != other.fTypeArguments.length) {
            return false;
        }
        for (int i = 0; i < this.fTypeArguments.length; ++i) {
            if (this.fTypeArguments[i].equals(other.fTypeArguments[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.fTypeDeclaration.hashCode();
        for (int i = 0; i < this.fTypeArguments.length; ++i) {
            result += this.fTypeArguments[i].hashCode();
        }
        return result;
    }

    protected boolean doCanAssignTo(TType lhs) {
        int targetType = lhs.getKind();
        switch (targetType) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return this.canAssignToStandardType((StandardType)lhs);
            }
            case 6: {
                return false;
            }
            case 7: {
                return this.canAssignToParameterizedType((ParameterizedType)lhs);
            }
            case 8: {
                return this.canAssignToRawType((RawType)lhs);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)lhs).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)lhs).checkLowerBound(this);
            }
        }
        return false;
    }

    protected boolean isTypeEquivalentTo(TType other) {
        int otherElementType = other.getKind();
        if (otherElementType == 8 || otherElementType == 6) {
            return this.getErasure().isTypeEquivalentTo(other.getErasure());
        }
        return super.isTypeEquivalentTo(other);
    }

    private boolean canAssignToRawType(RawType target) {
        return this.fTypeDeclaration.isSubType(target.getGenericType());
    }

    private boolean canAssignToParameterizedType(ParameterizedType target) {
        GenericType targetDeclaration = target.fTypeDeclaration;
        ParameterizedType sameSourceType = this.findSameDeclaration(targetDeclaration);
        if (sameSourceType == null) {
            return false;
        }
        TType[] targetArguments = target.fTypeArguments;
        TType[] sourceArguments = sameSourceType.fTypeArguments;
        if (targetArguments.length != sourceArguments.length) {
            return false;
        }
        for (int i = 0; i < sourceArguments.length; ++i) {
            if (targetArguments[i].checkTypeArgument(sourceArguments[i])) continue;
            return false;
        }
        return true;
    }

    private ParameterizedType findSameDeclaration(GenericType targetDeclaration) {
        if (this.fTypeDeclaration.equals(targetDeclaration)) {
            return this;
        }
        ParameterizedType result = null;
        TType type = this.getSuperclass();
        if (type != null && type.getKind() == 7 && (result = ((ParameterizedType)type).findSameDeclaration(targetDeclaration)) != null) {
            return result;
        }
        TType[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            type = interfaces[i];
            if (type == null || type.getKind() != 7 || (result = ((ParameterizedType)type).findSameDeclaration(targetDeclaration)) == null) continue;
            return result;
        }
        return null;
    }

    public String getName() {
        StringBuffer result = new StringBuffer(FastTypeAdapter.getInstance().getShortName(this.getTypeRepresentation()));
        result.append("<");
        result.append(this.fTypeArguments[0].getName());
        for (int i = 1; i < this.fTypeArguments.length; ++i) {
            result.append(", ");
            result.append(this.fTypeArguments[i].getName());
        }
        result.append(">");
        return result.toString();
    }

    protected String getPlainPrettySignature() {
        StringBuffer result = new StringBuffer(FastTypeAdapter.getInstance().getFullyQualifiedName(this.getTypeRepresentation()));
        result.append("<");
        result.append(this.fTypeArguments[0].getPlainPrettySignature());
        for (int i = 1; i < this.fTypeArguments.length; ++i) {
            result.append(", ");
            result.append(this.fTypeArguments[i].getPlainPrettySignature());
        }
        result.append(">");
        return result.toString();
    }
}

