/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.indexing.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.imp.pdb.analysis.AnalysisException;
import org.eclipse.imp.pdb.analysis.AnalysisManager;
import org.eclipse.imp.pdb.analysis.IFactGenerator;
import org.eclipse.imp.pdb.analysis.IFactGeneratorFactory;
import org.eclipse.imp.pdb.analysis.IFactUpdater;
import org.eclipse.imp.pdb.facts.db.FactBase;
import org.eclipse.imp.pdb.facts.db.IFactContext;
import org.eclipse.imp.pdb.facts.db.IFactKey;
import org.eclipse.imp.pdb.facts.db.context.ISourceEntityContext;
import org.eclipse.imp.pdb.facts.type.Type;

public class Indexer
extends Job {
    private static final int RESCHEDULE_DELAY_MSEC = 10000;
    private static final Indexer sInstance = new Indexer();
    private final Map<IPath, Set<IndexerDescriptor>> fScannerMap = new HashMap<IPath, Set<IndexerDescriptor>>();
    private final Stack<WorkItem> fWorkQueue = new Stack();
    private boolean fInitialized = false;

    public static Indexer getInstance() {
        return sInstance;
    }

    public static void initialize(long initialDelay) {
        Indexer.getInstance().initializeAndSchedule(initialDelay);
    }

    private Indexer() {
        super("IMP PDB Indexer");
    }

    private void initializeAndSchedule(long initialDelay) {
        if (!this.fInitialized) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ChangedResourceHandler());
            this.schedule(initialDelay);
            this.fInitialized = true;
        }
    }

    public void keepFactUpdated(IFactKey key) {
        Type resultType = key.getType();
        IFactContext context = key.getContext();
        if (!(context instanceof ISourceEntityContext)) {
            throw new IllegalArgumentException("Fact key has non-resource context");
        }
        ISourceEntityContext srcContext = (ISourceEntityContext)context;
        IResource r = srcContext.getEntity().getResource();
        IFactGeneratorFactory genFactory = AnalysisManager.getInstance().findGeneratorFactory(key);
        IndexerDescriptor indexerDesc = new IndexerDescriptor(key, genFactory.create(resultType));
        if (genFactory == null) {
            throw new IllegalArgumentException("No factory registered for fact type: " + resultType);
        }
        if (!FactBase.getInstance().getAllKeys().contains(key)) {
            this.fWorkQueue.push(new WorkItem(indexerDesc, r));
        }
        this.addIndexer(r.getFullPath(), indexerDesc);
    }

    private void addIndexer(IPath path, IndexerDescriptor desc) {
        Set<IndexerDescriptor> indexers = this.fScannerMap.get(path);
        if (indexers == null) {
            indexers = new HashSet<IndexerDescriptor>();
            this.fScannerMap.put(path, indexers);
        }
        indexers.add(desc);
    }

    public void cancelFactUpdating(IFactKey key) {
        Type resultType = key.getType();
        IFactContext context = key.getContext();
        if (!(context instanceof ISourceEntityContext)) {
            throw new IllegalArgumentException("Fact key has non-resource context");
        }
        ISourceEntityContext srcContext = (ISourceEntityContext)context;
        IResource r = srcContext.getEntity().getResource();
        this.removeIndexer(r.getFullPath(), key);
    }

    private void removeIndexer(IPath path, IFactKey key) {
        Set<IndexerDescriptor> indexers = this.fScannerMap.get(path);
        if (indexers == null) {
            return;
        }
        Iterator<IndexerDescriptor> iter = indexers.iterator();
        while (iter.hasNext()) {
            IndexerDescriptor indexerDesc = iter.next();
            if (!indexerDesc.fKey.equals(key)) continue;
            iter.remove();
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        FactBase factBase = FactBase.getInstance();
        while (!this.fWorkQueue.isEmpty()) {
            WorkItem item = this.fWorkQueue.pop();
            try {
                IndexerDescriptor indexer = item.fIndexer;
                IResource res = item.fResource;
                IFactKey key = indexer.fKey;
                IFactGenerator generator = indexer.fGenerator;
                if (generator instanceof IFactUpdater) {
                    IFactUpdater updater = (IFactUpdater)((Object)generator);
                    updater.update(factBase, key.getType(), key.getContext(), res);
                    continue;
                }
                generator.generate(factBase, key.getType(), key.getContext());
            }
            catch (AnalysisException e) {
                e.printStackTrace();
            }
        }
        this.schedule(10000L);
        return new Status(0, "org.eclipse.imp.pdb", "");
    }

    private class WorkItem {
        private IndexerDescriptor fIndexer;
        private IResource fResource;

        public WorkItem(IndexerDescriptor indexer2, IResource r) {
            this.fIndexer = indexer2;
            this.fResource = r;
        }

        public String toString() {
            return "Indexer work item for <" + this.fIndexer + "> on resource " + this.fResource.getFullPath().toPortableString();
        }
    }

    private class IndexerDescriptor {
        private IFactKey fKey;
        private IFactGenerator fGenerator;

        public IndexerDescriptor(IFactKey key, IFactGenerator gen) {
            this.fKey = key;
            this.fGenerator = gen;
        }

        public String toString() {
            return "Indexer for key " + this.fKey + " via generator " + this.fGenerator;
        }
    }

    private final class ChangedResourceHandler
    implements IResourceChangeListener {
        private ChangedResourceHandler() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IPath rp;
            IResource r = event.getResource();
            if (r == null) {
                return;
            }
            IPath rpPrefix = rp = r.getFullPath();
            while (rpPrefix.segmentCount() > 0) {
                Set indexers = (Set)Indexer.this.fScannerMap.get(rpPrefix);
                if (indexers == null) continue;
                for (IndexerDescriptor indexer : indexers) {
                    Indexer.this.fWorkQueue.push(new WorkItem(indexer, r));
                }
            }
        }
    }
}

