/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.shared;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.impl.fast.BigDecimalValue;
import org.eclipse.imp.pdb.facts.impl.shared.SharedValueFactory;
import org.eclipse.imp.pdb.facts.impl.util.sharing.IShareable;

public class SharedBigDecimalValue
extends BigDecimalValue
implements IShareable {
    public SharedBigDecimalValue(BigDecimal bigDecimal) {
        super(bigDecimal);
    }

    public IInteger toInteger() {
        return SharedValueFactory.getInstance().integer(this.value.toBigInteger());
    }

    public IReal floor() {
        return SharedValueFactory.getInstance().real(this.value.setScale(0, RoundingMode.FLOOR));
    }

    public IReal round() {
        return SharedValueFactory.getInstance().real(this.value.setScale(0, RoundingMode.HALF_UP));
    }

    public IReal add(IReal other) {
        return SharedValueFactory.getInstance().real(this.value.add(((SharedBigDecimalValue)other).value));
    }

    public IReal subtract(IReal other) {
        return SharedValueFactory.getInstance().real(this.value.subtract(((SharedBigDecimalValue)other).value));
    }

    public IReal multiply(IReal other) {
        return SharedValueFactory.getInstance().real(this.value.multiply(((SharedBigDecimalValue)other).value));
    }

    public IReal divide(IReal other, int precision) {
        MathContext mc = new MathContext(precision, RoundingMode.HALF_UP);
        return SharedValueFactory.getInstance().real(this.value.divide(((SharedBigDecimalValue)other).value, mc));
    }

    public IReal negate() {
        return SharedValueFactory.getInstance().real(this.value.negate());
    }

    public IInteger unscaled() {
        return SharedValueFactory.getInstance().integer(this.value.unscaledValue());
    }

    public IBool greater(IReal other) {
        return SharedValueFactory.getInstance().bool(this.compare(other) > 0);
    }

    public IBool greaterEqual(IReal other) {
        return SharedValueFactory.getInstance().bool(this.compare(other) >= 0);
    }

    public IBool less(IReal other) {
        return SharedValueFactory.getInstance().bool(this.compare(other) < 0);
    }

    public IBool lessEqual(IReal other) {
        return SharedValueFactory.getInstance().bool(this.compare(other) <= 0);
    }

    public boolean equivalent(IShareable shareable) {
        return super.equals(shareable);
    }

    public boolean equals(Object o) {
        return this == o;
    }
}

