/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.shared;

import java.util.Iterator;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.List;
import org.eclipse.imp.pdb.facts.impl.shared.SharedListWriter;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesList;
import org.eclipse.imp.pdb.facts.impl.util.sharing.IShareable;
import org.eclipse.imp.pdb.facts.type.Type;

public class SharedList
extends List
implements IShareable {
    protected SharedList(Type elementType, ShareableValuesList data) {
        super(elementType, data);
    }

    public IList append(IValue element) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.append(element);
        Type newElementType = this.elementType.lub(element.getType());
        return new SharedListWriter(newElementType, newData).done();
    }

    public IList concat(IList other) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        Iterator otherIterator = other.iterator();
        while (otherIterator.hasNext()) {
            newData.append(otherIterator.next());
        }
        Type newElementType = this.elementType.lub(other.getElementType());
        return new SharedListWriter(newElementType, newData).done();
    }

    public IList insert(IValue element) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.insert(element);
        Type newElementType = this.elementType.lub(element.getType());
        return new SharedListWriter(newElementType, newData).done();
    }

    public IList put(int index, IValue element) throws IndexOutOfBoundsException {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.set(index, element);
        Type newElementType = this.elementType.lub(element.getType());
        return new SharedListWriter(newElementType, newData).done();
    }

    public IList delete(int index) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.remove(index);
        return new SharedListWriter(this.elementType, newData).done();
    }

    public IList delete(IValue element) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.remove(element);
        return new SharedListWriter(this.elementType, newData).done();
    }

    public IList reverse() {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.reverse();
        return new SharedListWriter(this.elementType, newData).done();
    }

    public IList sublist(int offset, int length) {
        ShareableValuesList newData = this.data.subList(offset, length);
        return new SharedListWriter(this.elementType, newData).done();
    }

    public boolean equivalent(IShareable shareable) {
        return super.equals(shareable);
    }

    public boolean equals(Object o) {
        return this == o;
    }
}

