/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.spec;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.imp.formatting.spec.Item;
import org.eclipse.imp.formatting.spec.Parser;
import org.eclipse.imp.formatting.spec.Separator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Specification {
    private String language;
    private List<Item> items = new LinkedList<Item>();
    private Map<String, Integer> spaceOptions = new HashMap<String, Integer>();
    private String example = "";
    private Object exampleAst;
    private Parser parser;

    public Specification(String language, Parser parser) {
        this(parser);
        this.language = language;
    }

    public Specification(Parser parser) {
        this.parser = parser;
    }

    public void setSpaceOption(String key, int value) {
        this.spaceOptions.put(key, value);
    }

    public int getSpaceOption(String key) {
        return this.spaceOptions.get(key);
    }

    public void removeSpaceOption(String key) {
        this.spaceOptions.remove(key);
    }

    public Iterator<String> getSpaceOptions() {
        return this.spaceOptions.keySet().iterator();
    }

    public Parser getParser() {
        return this.parser;
    }

    public void addRule(Item rule) {
        this.items.add(rule);
    }

    public void addRule(int index, Item rule) {
        this.items.add(index, rule);
    }

    public void removeRule(int index) {
        this.items.remove(index);
    }

    public List getRules() {
        return this.items;
    }

    public Iterator<Item> ruleIterator() {
        return this.items.listIterator();
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Object getExampleAst() {
        return this.exampleAst;
    }

    public void setExampleAst(Object object) {
        this.exampleAst = object;
    }

    public void removeRule(Item tmpRule) {
        this.items.remove(tmpRule);
    }

    public void addSeparator(int i, Separator sep) {
        this.items.add(i, sep);
    }

    public void addSeparator(Separator sep) {
        this.items.add(sep);
    }

    public void removeSeparator(Separator sep) {
        this.items.remove(sep);
    }

    public void move(int index, Item item) {
        this.items.remove(item);
        this.items.add(index, item);
    }

    public void move(int index, Item[] toBeMoved) {
        for (Item item : toBeMoved) {
            this.items.remove(item);
            this.items.add(index++, item);
        }
    }
}

