/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.spec;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.imp.formatting.spec.BoxEnvironment;
import org.eclipse.imp.formatting.spec.BoxStringBuilder;
import org.eclipse.imp.formatting.spec.Item;
import org.eclipse.imp.formatting.spec.Matcher;
import org.eclipse.imp.formatting.spec.Rule;
import org.eclipse.imp.formatting.spec.SpaceOptionBinder;
import org.eclipse.imp.formatting.spec.Specification;
import org.eclipse.imp.formatting.spec.VariableEnvironment;
import org.eclipse.imp.services.IASTAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer {
    private IASTAdapter adapter;
    private Matcher matcher;
    private BoxStringBuilder builder;
    private BoxEnvironment boxes;
    private Map<String, List<Rule>> ruleMap;
    private Specification spec;
    private SpaceOptionBinder binder;

    public Transformer(Specification spec, IASTAdapter adapter) {
        this.adapter = adapter;
        this.matcher = new Matcher(adapter);
        this.builder = new BoxStringBuilder(adapter);
        this.boxes = new BoxEnvironment();
        this.binder = new SpaceOptionBinder(spec);
        this.spec = spec;
        this.ruleMap = new HashMap<String, List<Rule>>();
    }

    private void initializeRuleMap(Specification spec) {
        this.ruleMap.clear();
        Iterator<Item> iter = spec.ruleIterator();
        while (iter.hasNext()) {
            Item item = iter.next();
            if (!(item instanceof Rule)) continue;
            this.initRule((Rule)item);
        }
    }

    private void initRule(Rule rule) {
        Object pattern = rule.getPatternAst();
        if (pattern != null) {
            String outermost = this.adapter.getTypeOf(pattern);
            List<Rule> list = this.ruleMap.get(outermost);
            if (list == null) {
                list = new LinkedList<Rule>();
            }
            list.add(rule);
            this.ruleMap.put(outermost, list);
        }
    }

    public String getBox(Object ast) {
        return (String)this.boxes.get(ast);
    }

    public String transformToBox(String source, Object ast) {
        this.initializeRuleMap(this.spec);
        this.transform(source, ast);
        String box = (String)this.boxes.get(ast);
        this.boxes.clear();
        box = this.binder.bind(box);
        return "V vs=2 [" + box + "]";
    }

    private void transform(String source, Object ast) {
        VariableEnvironment environment;
        Rule found;
        Object[] kids = this.adapter.getChildren(ast);
        if (kids.length == 0) {
            this.boxes.put(ast, this.builder.literal(source, ast));
            return;
        }
        for (int i = 0; i < kids.length; ++i) {
            this.transform(source, kids[i]);
        }
        List<Rule> rules = this.findRules(ast);
        if (!rules.isEmpty() && (found = this.matchRule(rules, ast, environment = new VariableEnvironment())) != null) {
            String box = this.builder.substitute(found.getBoxString(), environment, this.boxes);
            this.boxes.put(ast, box);
            return;
        }
        this.boxes.put(ast, this.builder.defaultWrapper(source, ast, kids, this.boxes));
    }

    private Rule matchRule(List<Rule> rules, Object ast, VariableEnvironment environment) {
        for (Rule rule : rules) {
            environment.clear();
            if (rule.getPatternAst() == null || !this.matcher.match(rule.getPatternAst(), ast, environment)) continue;
            return rule;
        }
        return null;
    }

    private List<Rule> findRules(Object ast) {
        LinkedList rules = this.ruleMap.get(this.adapter.getTypeOf(ast));
        return rules != null ? rules : new LinkedList();
    }
}

