/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.INumber;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.impl.AbstractNumberValue;
import org.eclipse.imp.pdb.facts.impl.BoolValue;
import org.eclipse.imp.pdb.facts.impl.RealValue;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntegerValue
extends AbstractNumberValue
implements IInteger {
    private final BigInteger fValue;

    IntegerValue(int i) {
        super(TypeFactory.getInstance().integerType());
        this.fValue = BigInteger.valueOf(i);
    }

    IntegerValue(long i) {
        super(TypeFactory.getInstance().integerType());
        this.fValue = BigInteger.valueOf(i);
    }

    IntegerValue(BigInteger i) {
        super(TypeFactory.getInstance().integerType());
        this.fValue = i;
    }

    IntegerValue(byte[] a) {
        this(new BigInteger(a));
    }

    @Override
    public IInteger toInteger() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            return this.fValue.equals(((IntegerValue)o).fValue);
        }
        return false;
    }

    @Override
    public IInteger add(IInteger other) {
        return new IntegerValue(this.fValue.add(((IntegerValue)other).fValue));
    }

    @Override
    public IReal add(IReal other) {
        return (IReal)other.add(this);
    }

    @Override
    public IInteger negate() {
        return new IntegerValue(this.fValue.negate());
    }

    @Override
    public IInteger subtract(IInteger other) {
        return new IntegerValue(this.fValue.subtract(((IntegerValue)other).fValue));
    }

    @Override
    public INumber subtract(IReal other) {
        return this.toReal().subtract(other);
    }

    @Override
    public IInteger multiply(IInteger other) {
        return new IntegerValue(this.fValue.multiply(((IntegerValue)other).fValue));
    }

    @Override
    public IReal multiply(IReal other) {
        return (IReal)other.multiply(this);
    }

    @Override
    public IInteger divide(IInteger other) {
        return new IntegerValue(this.fValue.divide(((IntegerValue)other).fValue));
    }

    @Override
    public INumber divide(IInteger other, int precision) {
        return this.toReal().divide(other, precision);
    }

    @Override
    public IReal divide(IReal other, int precision) {
        return this.toReal().divide(other, precision);
    }

    @Override
    public IInteger remainder(IInteger other) {
        return new IntegerValue(this.fValue.remainder(((IntegerValue)other).fValue));
    }

    @Override
    public IInteger mod(IInteger other) {
        return new IntegerValue(this.fValue.mod(((IntegerValue)other).fValue));
    }

    @Override
    public IBool less(IInteger other) {
        return new BoolValue(this.compare(other) < 0);
    }

    @Override
    public IBool less(IReal other) {
        return other.greaterEqual(this);
    }

    @Override
    public IBool lessEqual(IInteger other) {
        return new BoolValue(this.compare(other) <= 0);
    }

    @Override
    public IBool lessEqual(IReal other) {
        return other.greater(this);
    }

    @Override
    public IBool greater(IInteger other) {
        return new BoolValue(this.compare(other) > 0);
    }

    @Override
    public IBool greater(IReal other) {
        return other.lessEqual(this);
    }

    @Override
    public IBool greaterEqual(IInteger other) {
        return new BoolValue(this.compare(other) >= 0);
    }

    @Override
    public IBool greaterEqual(IReal other) {
        return other.less(this);
    }

    @Override
    public IReal toReal() {
        return new RealValue(new BigDecimal(this.fValue));
    }

    @Override
    public int compare(IInteger other) {
        return this.fValue.compareTo(((IntegerValue)other).fValue);
    }

    @Override
    public int compare(INumber other) {
        if (other.getType().isIntegerType()) {
            return this.compare(other.toInteger());
        }
        return this.toReal().compare(other);
    }

    public int hashCode() {
        return this.fValue.hashCode();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitInteger(this);
    }

    @Override
    public String getStringRepresentation() {
        return this.fValue.toString();
    }

    @Override
    public byte[] getTwosComplementRepresentation() {
        return this.fValue.toByteArray();
    }

    @Override
    public int intValue() {
        return this.fValue.intValue();
    }

    @Override
    public long longValue() {
        return this.fValue.longValue();
    }

    @Override
    public int signum() {
        return this.fValue.signum();
    }

    @Override
    public IInteger abs() {
        return new IntegerValue(this.fValue.abs());
    }
}

