/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Iterator;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.List;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesList;
import org.eclipse.imp.pdb.facts.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListWriter
implements IListWriter {
    protected final Type elementType;
    protected final ShareableValuesList data;
    protected IList constructedList;

    protected ListWriter(Type elementType) {
        this.elementType = elementType;
        this.data = new ShareableValuesList();
        this.constructedList = null;
    }

    protected ListWriter(Type elementType, ShareableValuesList data) {
        this.elementType = elementType;
        this.data = data;
        this.constructedList = null;
    }

    public void append(IValue element) {
        this.checkMutation();
        this.data.append(element);
    }

    @Override
    public void append(IValue ... elems) {
        this.checkMutation();
        for (IValue elem : elems) {
            this.data.append(elem);
        }
    }

    @Override
    public void appendAll(Iterable<? extends IValue> collection) {
        this.checkMutation();
        Iterator<? extends IValue> collectionIterator = collection.iterator();
        while (collectionIterator.hasNext()) {
            this.data.append(collectionIterator.next());
        }
    }

    public void insert(IValue elem) {
        this.checkMutation();
        this.data.insert(elem);
    }

    @Override
    public void insert(IValue ... elements) {
        this.insert(elements, 0, elements.length);
    }

    @Override
    public void insert(IValue[] elements, int start, int length) {
        this.checkMutation();
        this.checkBounds(elements, start, length);
        for (int i = start + length - 1; i >= start; --i) {
            this.data.insert(elements[i]);
        }
    }

    @Override
    public void insertAll(Iterable<IValue> collection) {
        this.checkMutation();
        Iterator<IValue> collectionIterator = collection.iterator();
        while (collectionIterator.hasNext()) {
            this.data.insert(collectionIterator.next());
        }
    }

    public void insertAt(int index, IValue element) {
        this.checkMutation();
        this.data.insertAt(index, element);
    }

    @Override
    public void insertAt(int index, IValue ... elements) {
        this.insertAt(index, elements, 0, 0);
    }

    @Override
    public void insertAt(int index, IValue[] elements, int start, int length) {
        this.checkMutation();
        this.checkBounds(elements, start, length);
        for (int i = start + length - 1; i >= start; --i) {
            this.data.insertAt(index, elements[i]);
        }
    }

    @Override
    public void replaceAt(int index, IValue element) {
        this.checkMutation();
        this.data.set(index, element);
    }

    @Override
    public void delete(int index) {
        this.checkMutation();
        this.data.remove(index);
    }

    @Override
    public void delete(IValue element) {
        this.checkMutation();
        this.data.remove(element);
    }

    protected void checkMutation() {
        if (this.constructedList != null) {
            throw new UnsupportedOperationException("Mutation of a finalized list is not supported.");
        }
    }

    private void checkBounds(IValue[] elems, int start, int length) {
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException("start < 0");
        }
        if (start + length > elems.length) {
            throw new ArrayIndexOutOfBoundsException("(start + length) > elems.length");
        }
    }

    @Override
    public IList done() {
        if (this.constructedList == null) {
            this.constructedList = new List(this.elementType, this.data);
        }
        return this.constructedList;
    }
}

