/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesHashSet;
import org.eclipse.imp.pdb.facts.util.ShareableHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueIndexedHashMap<V>
implements Map<IValue, V> {
    private static final int INITIAL_LOG_SIZE = 4;
    private int modSize;
    private int hashMask;
    private Entry<V>[] data;
    private int threshold;
    private int load;

    public ValueIndexedHashMap() {
        this.modSize = 4;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
    }

    public ValueIndexedHashMap(ValueIndexedHashMap<V> valueIndexedHashMap) {
        this.modSize = valueIndexedHashMap.modSize;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = (Entry[])valueIndexedHashMap.data.clone();
        this.threshold = tableSize;
        this.load = valueIndexedHashMap.load;
    }

    @Override
    public void clear() {
        this.modSize = 4;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
    }

    private void rehash() {
        ++this.modSize;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        Entry[] newData = new Entry[tableSize];
        this.threshold = tableSize;
        Entry<V>[] oldData = this.data;
        for (int i = oldData.length - 1; i >= 0; --i) {
            Entry<V> entry = oldData[i];
            if (entry == null) continue;
            Entry<V> lastUnchangedEntryChain = entry;
            int newLastUnchangedEntryChainIndex = entry.hash & this.hashMask;
            Entry e = entry.next;
            while (e != null) {
                int newIndex = e.hash & this.hashMask;
                if (newIndex != newLastUnchangedEntryChainIndex) {
                    lastUnchangedEntryChain = e;
                    newLastUnchangedEntryChainIndex = newIndex;
                }
                e = e.next;
            }
            newData[newLastUnchangedEntryChainIndex] = lastUnchangedEntryChain;
            while (entry != lastUnchangedEntryChain) {
                int hash = entry.hash;
                int position = hash & this.hashMask;
                newData[position] = new Entry(hash, entry.key, entry.value, newData[position]);
                entry = entry.next;
            }
        }
        this.data = newData;
    }

    private void ensureCapacity() {
        if (this.load > this.threshold) {
            this.rehash();
        }
    }

    private void replaceValue(int position, Entry<V> entry, V newValue) {
        Entry<V> e = this.data[position];
        this.data[position] = new Entry<V>(entry.hash, entry.key, newValue, entry.next);
        while (e != entry) {
            this.data[position] = new Entry(e.hash, e.key, e.value, this.data[position]);
            e = e.next;
        }
    }

    @Override
    public V put(IValue key, V value) {
        this.ensureCapacity();
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<V> currentStartEntry = this.data[position];
        if (currentStartEntry != null) {
            Entry<V> entry = currentStartEntry;
            do {
                if (hash != entry.hash || !entry.key.isEqual(key)) continue;
                this.replaceValue(position, entry, value);
                return entry.value;
            } while ((entry = entry.next) != null);
        }
        this.data[position] = new Entry<V>(hash, key, value, currentStartEntry);
        ++this.load;
        return null;
    }

    @Override
    public V remove(Object object) {
        IValue key = (IValue)object;
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<V> currentStartEntry = this.data[position];
        if (currentStartEntry != null) {
            Entry<V> entry = currentStartEntry;
            do {
                if (hash != entry.hash || !entry.key.isEqual(key)) continue;
                Entry<V> e = this.data[position];
                this.data[position] = entry.next;
                while (e != entry) {
                    this.data[position] = new Entry(e.hash, e.key, e.value, this.data[position]);
                    e = e.next;
                }
                --this.load;
                return entry.value;
            } while ((entry = entry.next) != null);
        }
        return null;
    }

    @Override
    public V get(Object object) {
        IValue key = (IValue)object;
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<V> entry = this.data[position];
        while (entry != null) {
            if (hash == entry.hash && key.isEqual(entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean contains(IValue key) {
        return this.get(key) != null;
    }

    @Override
    public int size() {
        return this.load;
    }

    @Override
    public boolean isEmpty() {
        return this.load == 0;
    }

    public Iterator<Map.Entry<IValue, V>> entryIterator() {
        return new EntryIterator(this);
    }

    public Iterator<IValue> keysIterator() {
        return new KeysIterator(this);
    }

    public Iterator<V> valuesIterator() {
        return new ValuesIterator(this);
    }

    @Override
    public void putAll(Map<? extends IValue, ? extends V> otherMap) {
        Set<Map.Entry<IValue, V>> entrySet = otherMap.entrySet();
        for (Map.Entry<IValue, V> next : entrySet) {
            this.put(next.getKey(), next.getValue());
        }
    }

    @Override
    public boolean containsKey(Object object) {
        IValue key = (IValue)object;
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<V> entry = this.data[position];
        while (entry != null) {
            if (hash == entry.hash && key.isEqual(entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<V> valuesIterator = this.valuesIterator();
        while (valuesIterator.hasNext()) {
            V nextValue = valuesIterator.next();
            if (nextValue != value && (nextValue == null || !nextValue.equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<IValue, V>> entrySet() {
        ShareableHashSet<Map.Entry<IValue, Map.Entry<IValue, V>>> entrySet = new ShareableHashSet<Map.Entry<IValue, Map.Entry<IValue, V>>>();
        Iterator<Map.Entry<IValue, V>> entriesIterator = this.entryIterator();
        while (entriesIterator.hasNext()) {
            entrySet.add(entriesIterator.next());
        }
        return entrySet;
    }

    @Override
    public Set<IValue> keySet() {
        ShareableValuesHashSet keysSet = new ShareableValuesHashSet();
        Iterator<IValue> keysIterator = this.keysIterator();
        while (keysIterator.hasNext()) {
            keysSet.add(keysIterator.next());
        }
        return keysSet;
    }

    @Override
    public Collection<V> values() {
        ShareableHashSet<V> valuesSet = new ShareableHashSet<V>();
        Iterator<V> valuesIterator = this.valuesIterator();
        while (valuesIterator.hasNext()) {
            valuesSet.add(valuesIterator.next());
        }
        return valuesSet;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (int i = 0; i < this.data.length; ++i) {
            buffer.append('[');
            Entry<V> e = this.data[i];
            if (e != null) {
                buffer.append(e);
                e = e.next;
                while (e != null) {
                    buffer.append(',');
                    buffer.append(e);
                    e = e.next;
                }
            }
            buffer.append(']');
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int hash = 0;
        Iterator<IValue> keysIterator = this.keysIterator();
        while (keysIterator.hasNext()) {
            hash ^= keysIterator.next().hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            ValueIndexedHashMap other = (ValueIndexedHashMap)o;
            if (other.size() != this.size()) {
                return false;
            }
            if (this.isEmpty()) {
                return true;
            }
            Iterator<Map.Entry<IValue, V>> otherIterator = other.entryIterator();
            while (otherIterator.hasNext()) {
                V thisValue;
                Map.Entry<IValue, V> entry = otherIterator.next();
                V otherValue = entry.getValue();
                if (otherValue == (thisValue = this.get(entry.getKey())) || thisValue == null || thisValue.equals(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValuesIterator<V>
    implements Iterator<V> {
        private final EntryIterator<V> entryIterator;

        public ValuesIterator(ValueIndexedHashMap<V> valueIndexedHashMap) {
            this.entryIterator = new EntryIterator<V>(valueIndexedHashMap);
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public V next() {
            return ((Entry)this.entryIterator.next()).value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeysIterator<V>
    implements Iterator<IValue> {
        private final EntryIterator<V> entryIterator;

        public KeysIterator(ValueIndexedHashMap<V> valueIndexedHashMap) {
            this.entryIterator = new EntryIterator<V>(valueIndexedHashMap);
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public IValue next() {
            return ((Entry)this.entryIterator.next()).key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryIterator<V>
    implements Iterator<Map.Entry<IValue, V>> {
        private final Entry<V>[] data;
        private Entry<V> current;
        private int index;

        public EntryIterator(ValueIndexedHashMap<V> valueIndexedHashMap) {
            this.data = ((ValueIndexedHashMap)valueIndexedHashMap).data;
            this.index = this.data.length - 1;
            this.current = new Entry<Object>(0, null, null, this.data[this.index]);
            this.locateNext();
        }

        private void locateNext() {
            Entry next = this.current.next;
            if (next != null) {
                this.current = next;
                return;
            }
            for (int i = this.index - 1; i >= 0; --i) {
                Entry<V> entry = this.data[i];
                if (entry == null) continue;
                this.current = entry;
                this.index = i;
                return;
            }
            this.current = null;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Entry<V> next() {
            if (!this.hasNext()) {
                throw new UnsupportedOperationException("There are no more elements in this iterator.");
            }
            Entry<V> entry = this.current;
            this.locateNext();
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<V>
    implements Map.Entry<IValue, V> {
        public final int hash;
        public final IValue key;
        public final V value;
        public final Entry<V> next;

        public Entry(int hash, IValue key, V value, Entry<V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public IValue getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("The setting of values is not supported by this map implementation.");
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('<');
            buffer.append(this.key);
            buffer.append(':');
            buffer.append(this.value);
            buffer.append('>');
            return buffer.toString();
        }
    }
}

