/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints.fastrep;

import org.eclipse.imp.analysis.type.constraints.fastrep.BindingKey;
import org.eclipse.imp.analysis.type.constraints.fastrep.CaptureType;
import org.eclipse.imp.analysis.type.constraints.fastrep.FastTypeAdapter;
import org.eclipse.imp.analysis.type.constraints.fastrep.HierarchyType;
import org.eclipse.imp.analysis.type.constraints.fastrep.PrimitiveType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TypeEnvironment;
import org.eclipse.imp.analysis.type.constraints.fastrep.WildcardType;

public class StandardType
extends HierarchyType {
    private static final String OBJECT_KEY = BindingKey.createTypeBindingKey("java.lang.Object");
    private static final String CLONEABLE_KEY = BindingKey.createTypeBindingKey("java.lang.Cloneable");
    private static final String SERIALIZABLE_KEY = BindingKey.createTypeBindingKey("java.io.Serializable");

    protected StandardType(TypeEnvironment environment) {
        super(environment);
    }

    public int getKind() {
        return 5;
    }

    public boolean isJavaLangObject() {
        return OBJECT_KEY.equals(this.getBindingKey());
    }

    public boolean isJavaLangCloneable() {
        return CLONEABLE_KEY.equals(this.getBindingKey());
    }

    public boolean isJavaIoSerializable() {
        return SERIALIZABLE_KEY.equals(this.getBindingKey());
    }

    public boolean doEquals(TType type) {
        return this.getTypeRepresentation().equals(((StandardType)type).getTypeRepresentation());
    }

    public int hashCode() {
        return this.getTypeRepresentation().hashCode();
    }

    protected boolean doCanAssignTo(TType lhs) {
        switch (lhs.getKind()) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return this.canAssignToPrimitive((PrimitiveType)lhs);
            }
            case 4: {
                return false;
            }
            case 5: {
                return this.canAssignToStandardType((StandardType)lhs);
            }
            case 6: {
                return false;
            }
            case 7: {
                return this.isSubType((HierarchyType)lhs);
            }
            case 8: {
                return this.isSubType((HierarchyType)lhs);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)lhs).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)lhs).checkLowerBound(this);
            }
        }
        return false;
    }

    private boolean canAssignToPrimitive(PrimitiveType type) {
        PrimitiveType source = this.getEnvironment().createUnBoxed(this);
        return source != null && source.canAssignTo(type);
    }

    public String getName() {
        return FastTypeAdapter.getInstance().getShortName(this.getTypeRepresentation());
    }

    protected String getPlainPrettySignature() {
        return FastTypeAdapter.getInstance().getFullyQualifiedName(this.getTypeRepresentation());
    }
}

