/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.analysis;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.pdb.PDBPlugin;
import org.eclipse.imp.pdb.analysis.AnalysisException;
import org.eclipse.imp.pdb.analysis.AnalysisFactoryElement;
import org.eclipse.imp.pdb.analysis.IAnalysisDescriptor;
import org.eclipse.imp.pdb.analysis.IFactGenerator;
import org.eclipse.imp.pdb.analysis.IFactGeneratorFactory;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.db.FactBase;
import org.eclipse.imp.pdb.facts.db.IFactKey;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.preferences.PreferenceCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisManager {
    public static final String ANALYSIS_FACTORY_EXTENSION = "analyzerFactory";
    static final AnalysisManager sInstance = new AnalysisManager();
    private static final boolean DEBUG_DISCOVERY = true;
    private final Map<IAnalysisDescriptor, IFactGeneratorFactory> fAnalysisFactoryMap = new HashMap<IAnalysisDescriptor, IFactGeneratorFactory>();
    private final Map<Type, IFactGeneratorFactory> fFactTypeMap = new HashMap<Type, IFactGeneratorFactory>();
    private final FactBase fFactBase = FactBase.getInstance();

    public static AnalysisManager getInstance() {
        return sInstance;
    }

    private AnalysisManager() {
        this.discoverAnalyzers();
    }

    public IFactGeneratorFactory findGeneratorFactory(IFactKey factKey) {
        Type factType = factKey.getType();
        IFactGeneratorFactory factory = this.fFactTypeMap.get(factType);
        return factory;
    }

    public void registerAnalysisFactory(IAnalysisDescriptor desc, IFactGeneratorFactory factory) {
        this.fAnalysisFactoryMap.put(desc, factory);
        for (Type factType : desc.getOutputDescriptors()) {
            this.fFactTypeMap.put(factType, factory);
        }
    }

    private void discoverAnalyzers() {
        this.fAnalysisFactoryMap.clear();
        this.fFactTypeMap.clear();
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.imp.pdb", ANALYSIS_FACTORY_EXTENSION);
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            if (elements != null) {
                int n;
                AnalysisFactoryElement[] factories = new AnalysisFactoryElement[elements.length];
                for (n = 0; n < elements.length; ++n) {
                    IConfigurationElement element = elements[n];
                    factories[n] = new AnalysisFactoryElement(element);
                }
                for (n = 0; n < factories.length; ++n) {
                    AnalysisFactoryElement factoryElement = factories[n];
                    for (IAnalysisDescriptor desc : factoryElement.getDescriptors()) {
                        IFactGeneratorFactory factory = factoryElement.getFactory();
                        this.fAnalysisFactoryMap.put(desc, factory);
                        for (Type factType : desc.getOutputDescriptors()) {
                            this.fFactTypeMap.put(factType, factory);
                        }
                    }
                    if (!PreferenceCache.emitMessages) continue;
                    PDBPlugin.getInstance().writeInfoMsg("Found analyzer extension " + factoryElement.getName());
                }
            } else {
                PDBPlugin.getInstance().logException("No analyzers defined", null);
            }
        }
        catch (Throwable e) {
            ErrorHandler.reportError((String)"IMP Analysis Registry error", (Throwable)e);
        }
    }

    public IValue produceFact(IFactKey factKey) throws AnalysisException {
        this.discoverAnalyzers();
        Type factType = factKey.getType();
        IFactGeneratorFactory factory = this.fFactTypeMap.get(factType);
        if (factory == null) {
            throw new AnalysisException("Unable to find generator factory for fact of type " + factType);
        }
        IFactGenerator analyzer = factory.create(factType);
        try {
            analyzer.generate(this.fFactBase, factType, factKey.getContext());
        }
        catch (AnalysisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AnalysisException("Exception encountered while producing " + factKey + ": " + e.getMessage(), e);
        }
        IValue result = this.fFactBase.getFact(factKey);
        return result;
    }

    public void produceFactAsynchronously(IFactKey factKey) throws AnalysisException {
        Type factType = factKey.getType();
        IFactGeneratorFactory factory = this.fFactTypeMap.get(factType);
        if (factory == null) {
            throw new AnalysisException("Unable to find generator factory for fact of type " + factType);
        }
        throw new UnsupportedOperationException("produceFactAsynchronously()");
    }

    public Set<IAnalysisDescriptor> getAnalysisDescriptorSet() {
        return this.fAnalysisFactoryMap.keySet();
    }
}

