/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.java.hosted.debug;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IToggleBreakpointsHandler;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;

public abstract class JavaBreakpointHandler
implements IToggleBreakpointsHandler {
    private static final String JDT_DEBUG_PLUGIN_ID = "org.eclipse.jdt.debug";
    private final String fStratumID;

    public JavaBreakpointHandler(String stratumID) {
        this.fStratumID = stratumID;
    }

    public void setLineBreakpoint(IFile file, int lineNumber) throws CoreException {
        String srcFileName = file.getName();
        String typeName = srcFileName.substring(0, srcFileName.lastIndexOf(46));
        HashMap<String, String> bkptAttributes = new HashMap<String, String>();
        bkptAttributes.put("org.eclipse.jdt.debug.core.sourceName", srcFileName);
        bkptAttributes.put("org.eclipse.jdt.debug.core.typeName", typeName);
        try {
            IJavaStratumLineBreakpoint bkpt = JDIDebugModel.createStratumBreakpoint((IResource)file, (String)this.fStratumID, (String)srcFileName, (String)file.getFullPath().toString(), null, (int)lineNumber, (int)-1, (int)-1, (int)0, (boolean)true, bkptAttributes);
        }
        catch (CoreException e) {
            RuntimePlugin.getInstance().logException("Unable to set stratum breakpoint on file " + srcFileName, (Throwable)e);
        }
    }

    public void clearLineBreakpoint(IFile file, int lineNumber) throws CoreException {
        String srcFileName = file.getName();
        try {
            IJavaLineBreakpoint lineBkpt = JavaBreakpointHandler.findStratumBreakpoint((IResource)file, lineNumber);
            if (lineBkpt != null) {
                lineBkpt.delete();
            }
        }
        catch (CoreException e) {
            RuntimePlugin.getInstance().logException("Unable to clear line breakpoint on file " + srcFileName, (Throwable)e);
        }
    }

    public void disableLineBreakpoint(IFile file, int lineNumber) throws CoreException {
        String srcFileName = file.getName();
        try {
            IJavaLineBreakpoint lineBkpt = JavaBreakpointHandler.findStratumBreakpoint((IResource)file, lineNumber);
            if (lineBkpt != null) {
                lineBkpt.setEnabled(false);
            }
        }
        catch (CoreException e) {
            RuntimePlugin.getInstance().logException("Unable to disable line breakpoint on file " + srcFileName, (Throwable)e);
        }
    }

    public void enableLineBreakpoint(IFile file, int lineNumber) throws CoreException {
        String srcFileName = file.getName();
        try {
            IJavaLineBreakpoint lineBkpt = JavaBreakpointHandler.findStratumBreakpoint((IResource)file, lineNumber);
            if (lineBkpt != null) {
                lineBkpt.setEnabled(true);
            }
        }
        catch (CoreException e) {
            RuntimePlugin.getInstance().logException("Unable to enable line breakpoint on file " + srcFileName, (Throwable)e);
        }
    }

    public static IJavaLineBreakpoint findStratumBreakpoint(IResource resource, int lineNumber) throws CoreException {
        String modelId = JDT_DEBUG_PLUGIN_ID;
        String markerType = "org.eclipse.jdt.debug.javaStratumLineBreakpointMarker";
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        for (int i = 0; i < breakpoints.length; ++i) {
            IJavaLineBreakpoint breakpoint;
            IMarker marker;
            if (!(breakpoints[i] instanceof IJavaLineBreakpoint) || (marker = (breakpoint = (IJavaLineBreakpoint)breakpoints[i]).getMarker()) == null || !marker.exists() || !marker.getType().equals(markerType) || breakpoint.getLineNumber() != lineNumber || !resource.equals(marker.getResource())) continue;
            return breakpoint;
        }
        return null;
    }
}

