/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.pageinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.PreferencesPageInfo;
import org.eclipse.ui.console.MessageConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesTabInfo {
    private PreferencesPageInfo parent = null;
    private String name = null;
    private List<ConcreteFieldInfo> concreteFields = new ArrayList<ConcreteFieldInfo>();
    private boolean isEditable = true;
    private boolean isRemovable = true;
    private boolean isUsed = true;

    public PreferencesTabInfo(PreferencesPageInfo parent, String name) {
        if (parent == null) {
            throw new IllegalArgumentException("PreferencesTabInfo(..):  page is null; not allowed");
        }
        if (name == null) {
            throw new IllegalArgumentException("PreferencesTabInfo(..):  name is null; not allowed");
        }
        String[] levels = IPreferencesService.levels;
        boolean nameOK = false;
        for (int i = 0; i < levels.length; ++i) {
            if (!name.equals(levels[i])) continue;
            nameOK = true;
            break;
        }
        if (!nameOK) {
            throw new IllegalArgumentException("PreferencesTabInfo.setName(..):  name = '" + name + "' does not correspond to a legal tab name");
        }
        if (parent.hasTabInfo(name)) {
            throw new IllegalArgumentException("PreferencesTabInfo.setName(..):  name = '" + name + "' represents a duplicate tab; not allowed");
        }
        this.parent = parent;
        parent.addTabInfo(this);
        this.name = name;
    }

    public PreferencesPageInfo getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public void setIsEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public boolean getIsEditable() {
        return this.isEditable;
    }

    public void setIsRemovable(boolean isRemovable) {
        if (this.getName().equals("default") && isRemovable) {
            throw new IllegalArgumentException("PreferencesTabInfo.setIsRemovable(..):  cannot set isRemovable ");
        }
        this.isRemovable = isRemovable;
    }

    public boolean getIsRemovable() {
        if (this.getName().equals("default")) {
            return false;
        }
        return this.isRemovable;
    }

    public void setIsUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public boolean getIsUsed() {
        return this.isUsed;
    }

    public void add(ConcreteFieldInfo field) {
        if (field == null || this.concreteFields.contains(field)) {
            return;
        }
        this.concreteFields.add(field);
    }

    public void removeConcreteField(ConcreteFieldInfo vField) {
        if (vField == null) {
            return;
        }
        this.concreteFields.remove(vField);
    }

    public Iterator<ConcreteFieldInfo> getConcreteFields() {
        return this.concreteFields.iterator();
    }

    public void dump(String prefix, MessageConsoleStream out) {
        String indent = prefix + "  ";
        out.println(prefix + "Tab '" + this.getName() + "'");
        out.println(indent + "isUsed = " + this.getIsUsed());
        out.println(indent + "isEditable = " + this.getIsEditable());
        out.println(indent + "isRemovable = " + this.getIsRemovable());
        out.println(indent + "Concrete fields:");
        for (ConcreteFieldInfo field : this.concreteFields) {
            field.dump(indent + " ", out);
        }
    }
}

