/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler.codegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.prefspecs.compiler.DynamicEnumValueSource;
import org.eclipse.imp.prefspecs.compiler.IEnumValueSource;
import org.eclipse.imp.prefspecs.compiler.LiteralEnumValueSource;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteBooleanFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteColorFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteComboFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteDirListFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteDirectoryFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteDoubleFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteFileFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteFontFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteIntFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteRadioFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteStringFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.PreferencesPageInfo;
import org.eclipse.imp.prefspecs.pageinfo.PreferencesTabInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualBooleanFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualColorFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualComboFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualDoubleFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualFontFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualIntFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualRadioFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualStringFieldInfo;
import org.eclipse.ui.console.MessageConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesFactory {
    private final MessageConsoleStream fConsoleStream;

    public PreferencesFactory(MessageConsoleStream consoleStream) {
        this.fConsoleStream = consoleStream;
    }

    public IFile generatePreferencesConstants(List<PreferencesPageInfo> pageInfos, ISourceProject project, String projectSourceLocation, String packageName2, String className, IProgressMonitor mon) {
        String fileText = PreferencesFactory.generateConstantsPartBeforeFields(packageName2, className);
        fileText = PreferencesFactory.generateConstantsFields(pageInfos, fileText);
        fileText = PreferencesFactory.generateConstantsAfterFields(fileText);
        IFile constantsFile = this.createFileWithText(fileText, project, projectSourceLocation, packageName2, className, mon);
        return constantsFile;
    }

    public IFile generatePreferencesInitializers(List<PreferencesPageInfo> pageInfos, String pluginPkgName, String pluginClassName, String constantsClassName, ISourceProject project, String projectSourceLocation, String packageName2, String className, IProgressMonitor mon) {
        String fileText = PreferencesFactory.generateInitializersPartBeforeFields(pluginPkgName, pluginClassName, packageName2, className);
        fileText = PreferencesFactory.generateInitializersFields(pageInfos, constantsClassName, fileText);
        fileText = PreferencesFactory.generateInitializersAfterFields(pluginClassName, fileText);
        IFile initializersFile = this.createFileWithText(fileText, project, projectSourceLocation, packageName2, className, mon);
        return initializersFile;
    }

    public IFile generatePreferencesPage(PreferencesPageInfo pageInfo, String pluginPkgName, String pluginClassName, String constantsClassName, String initializerClassName, ISourceProject project, String projectSourceLocation, String packageName2, String className, IProgressMonitor mon) {
        StringBuilder sb = new StringBuilder();
        PreferencesFactory.generatePageBeforeTabs(sb, pluginPkgName, pluginClassName, packageName2, className);
        PreferencesFactory.generateTabs(sb, pageInfo);
        PreferencesFactory.generatePageAfterTabs(sb, initializerClassName);
        IFile prefPageFile = this.createFileWithText(sb.toString(), project, projectSourceLocation, packageName2, className, mon);
        return prefPageFile;
    }

    protected static void generatePageBeforeTabs(StringBuilder fileText, String pluginPackageName, String pluginClassName, String packageName2, String className) {
        if (className.endsWith(".java")) {
            className = className.substring(0, className.length() - 5);
        }
        fileText.append("package " + packageName2 + ";\n\n");
        fileText.append("import org.eclipse.swt.widgets.TabFolder;");
        fileText.append("import org.eclipse.imp.preferences.IPreferencesService;");
        fileText.append("import org.eclipse.imp.preferences.PreferencesInitializer;");
        fileText.append("import org.eclipse.imp.preferences.PreferencesTab;");
        fileText.append("import org.eclipse.imp.preferences.TabbedPreferencesPage;");
        fileText.append("import " + pluginPackageName + "." + pluginClassName + ";");
        fileText.append("\n\n/**\n");
        fileText.append(" * A preference page class.\n");
        fileText.append(" */\n");
        fileText.append("\n\n");
        fileText.append("public class " + className + " extends TabbedPreferencesPage {\n");
        fileText.append("\tpublic " + className + "() {\n");
        fileText.append("\t\tsuper();\n");
        fileText.append("\t\tprefService = " + pluginClassName + ".getInstance().getPreferencesService();\n");
        fileText.append("\t}\n\n");
        fileText.append("\tprotected PreferencesTab[] createTabs(IPreferencesService prefService,\n");
        fileText.append("\t\tTabbedPreferencesPage page, TabFolder tabFolder) {\n");
    }

    private static void generateTabs(StringBuilder fileText, PreferencesPageInfo pageInfo) {
        int tabCount = 0;
        Iterator<PreferencesTabInfo> tabIter = pageInfo.getTabInfos();
        while (tabIter.hasNext()) {
            PreferencesTabInfo tab = tabIter.next();
            if (!tab.getIsUsed()) continue;
            ++tabCount;
        }
        String pageName2 = pageInfo.getPageName();
        fileText.append("\t\tPreferencesTab[] tabs = new PreferencesTab[" + tabCount + "];\n");
        fileText.append("\n");
        tabIter = pageInfo.getTabInfos();
        int tabIdx = 0;
        while (tabIter.hasNext()) {
            PreferencesTabInfo tab = tabIter.next();
            if (!tab.getIsUsed()) continue;
            String tabName = tab.getName();
            String upperTab = Character.toUpperCase(tabName.charAt(0)) + tabName.substring(1);
            String tabClass = pageName2.replaceAll("\\.", "") + upperTab + "Tab";
            String tabVar = tabName + "Tab";
            fileText.append("\t\t" + tabClass + " " + tabVar + " = new " + tabClass + "(prefService);\n");
            fileText.append("\t\t" + tabVar + ".createTabContents(page, tabFolder);\n");
            fileText.append("\t\ttabs[" + tabIdx + "] = " + tabVar + ";\n");
            fileText.append("\n");
            ++tabIdx;
        }
    }

    protected static void generatePageAfterTabs(StringBuilder fileText, String initializerClassName) {
        fileText.append("\t\treturn tabs;\n");
        fileText.append("\t}\n");
        fileText.append("\n");
        fileText.append("\tpublic PreferencesInitializer getPreferenceInitializer() {\n");
        fileText.append("\t\treturn new " + initializerClassName + "();\n");
        fileText.append("\t}\n");
        fileText.append("}\n");
    }

    public IFile generateDefaultTab(PreferencesPageInfo pageInfo, String pluginPkgName, String pluginClassName, String constantsClassName, String initializerClassName, ISourceProject project, String projectSourceLocation, String packageName2, String className, IProgressMonitor mon) {
        if (pageInfo.getTabInfo("default") == null) {
            return null;
        }
        String fileText = PreferencesFactory.generateTabBeforeFields(pageInfo, pluginPkgName, pluginClassName, packageName2, className, initializerClassName, "default");
        fileText = PreferencesFactory.generateTabFields(pageInfo, constantsClassName, fileText, "default");
        fileText = PreferencesFactory.generateTabAfterFields(fileText);
        IFile initializersFile = this.createFileWithText(fileText, project, projectSourceLocation, packageName2, className, mon);
        return initializersFile;
    }

    public IFile generateConfigurationTab(PreferencesPageInfo pageInfo, String pluginPkgName, String pluginClassName, String constantsClassName, ISourceProject project, String projectSourceLocation, String packageName2, String className, IProgressMonitor mon) {
        if (pageInfo.getTabInfo("configuration") == null) {
            return null;
        }
        String fileText = PreferencesFactory.generateTabBeforeFields(pageInfo, pluginPkgName, pluginClassName, packageName2, className, null, "configuration");
        fileText = PreferencesFactory.generateTabFields(pageInfo, constantsClassName, fileText, "configuration");
        fileText = PreferencesFactory.generateTabAfterFields(fileText);
        IFile initializersFile = this.createFileWithText(fileText, project, projectSourceLocation, packageName2, className, mon);
        return initializersFile;
    }

    public IFile generateInstanceTab(PreferencesPageInfo pageInfo, String pluginPkgName, String pluginClassName, String constantsClassName, ISourceProject project, String projectSourceLocation, String packageName2, String className, IProgressMonitor mon) {
        if (pageInfo.getTabInfo("instance") == null) {
            return null;
        }
        String fileText = PreferencesFactory.generateTabBeforeFields(pageInfo, pluginPkgName, pluginClassName, packageName2, className, null, "instance");
        fileText = PreferencesFactory.generateTabFields(pageInfo, constantsClassName, fileText, "instance");
        fileText = PreferencesFactory.generateTabAfterFields(fileText);
        IFile initializersFile = this.createFileWithText(fileText, project, projectSourceLocation, packageName2, className, mon);
        return initializersFile;
    }

    public IFile generateProjectTab(PreferencesPageInfo pageInfo, String pluginPkgName, String pluginClassName, String constantsClassName, ISourceProject project, String projectSourceLocation, String packageName2, String className, IProgressMonitor mon) {
        if (pageInfo.getTabInfo("project") == null) {
            return null;
        }
        String fileText = PreferencesFactory.generateTabBeforeFields(pageInfo, pluginPkgName, pluginClassName, packageName2, className, null, "project");
        fileText = PreferencesFactory.generateTabFields(pageInfo, constantsClassName, fileText, "project");
        fileText = PreferencesFactory.generateTabAfterFields(fileText);
        fileText = PreferencesFactory.regenerateEndOfProjectTab(pageInfo, fileText);
        IFile initializersFile = this.createFileWithText(fileText, project, projectSourceLocation, packageName2, className, mon);
        return initializersFile;
    }

    protected static String generateConstantsPartBeforeFields(String packageName2, String className) {
        if (className.endsWith(".java")) {
            className = className.substring(0, className.length() - 5);
        }
        String fileText = "package " + packageName2 + ";\n\n";
        fileText = fileText + "/**\n";
        fileText = fileText + " * Constant definitions for preferences.\n";
        fileText = fileText + " *\n";
        fileText = fileText + " * The preferences service uses Strings as keys for preference values,\n";
        fileText = fileText + " * so Strings defined here are used here to designate preference fields.\n";
        fileText = fileText + " * These strings are generated automatically from a preferences specification.\n";
        fileText = fileText + " * Other constants may be defined here manually.\n";
        fileText = fileText + " *\n";
        fileText = fileText + " */\n";
        fileText = fileText + "\n\n";
        fileText = fileText + "public class " + className + " {\n";
        return fileText;
    }

    protected static String generateConstantsFields(List<PreferencesPageInfo> pageInfos, String fileText) {
        for (PreferencesPageInfo pageInfo : pageInfos) {
            Iterator<VirtualFieldInfo> vFields = pageInfo.getVirtualFieldInfos();
            while (vFields.hasNext()) {
                VirtualFieldInfo vField = vFields.next();
                fileText = fileText + "\n\tpublic static final String P_" + vField.getName().toUpperCase() + " = \"" + vField.getName() + "\"" + ";\n";
            }
        }
        return fileText;
    }

    protected static String generateConstantsAfterFields(String fileText) {
        return fileText + "\n}\n";
    }

    protected static String generateInitializersPartBeforeFields(String pluginPackageName, String pluginClassName, String packageName2, String className) {
        if (className.endsWith(".java")) {
            className = className.substring(0, className.length() - 5);
        }
        String fileText = "package " + packageName2 + ";\n\n";
        fileText = fileText + "import org.eclipse.imp.preferences.PreferencesInitializer;\n";
        fileText = fileText + "import org.eclipse.imp.preferences.IPreferencesService;\n";
        fileText = fileText + "import " + pluginPackageName + "." + pluginClassName + ";\n\n";
        fileText = fileText + "/**\n";
        fileText = fileText + " * Initializations of default values for preferences.\n";
        fileText = fileText + " */\n";
        fileText = fileText + "public class " + className + " extends PreferencesInitializer {\n";
        fileText = fileText + "\t/*\n";
        fileText = fileText + "\t * (non-Javadoc)\n";
        fileText = fileText + "\t * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()\n";
        fileText = fileText + "\t */\n";
        fileText = fileText + "\tpublic void initializeDefaultPreferences() {\n";
        fileText = fileText + "\t\tIPreferencesService service = " + pluginClassName + ".getInstance().getPreferencesService();\n\n";
        return fileText;
    }

    protected static String generateInitializersFields(List<PreferencesPageInfo> pageInfos, String constantsClassName, String fileText) {
        for (PreferencesPageInfo pageInfo : pageInfos) {
            Iterator<VirtualFieldInfo> vFields = pageInfo.getVirtualFieldInfos();
            while (vFields.hasNext()) {
                VirtualFieldInfo vFont;
                VirtualFieldInfo vField = vFields.next();
                if (vField instanceof VirtualBooleanFieldInfo) {
                    VirtualBooleanFieldInfo vBool = (VirtualBooleanFieldInfo)vField;
                    fileText = fileText + "\t\tservice.setBooleanPreference(IPreferencesService.DEFAULT_LEVEL, " + constantsClassName + "." + PreferencesFactory.preferenceConstantForName(vBool.getName()) + ", " + vBool.getDefaultValue() + ");\n";
                    continue;
                }
                if (vField instanceof VirtualIntFieldInfo) {
                    VirtualIntFieldInfo vInt = (VirtualIntFieldInfo)vField;
                    fileText = fileText + "\t\tservice.setIntPreference(IPreferencesService.DEFAULT_LEVEL, " + constantsClassName + "." + PreferencesFactory.preferenceConstantForName(vInt.getName()) + ", " + vInt.getDefaultValue() + ");\n";
                    continue;
                }
                if (vField instanceof VirtualDoubleFieldInfo) {
                    VirtualDoubleFieldInfo vDouble = (VirtualDoubleFieldInfo)vField;
                    fileText = fileText + "\t\tservice.setDoublePreference(IPreferencesService.DEFAULT_LEVEL, " + constantsClassName + "." + PreferencesFactory.preferenceConstantForName(vDouble.getName()) + ", " + vDouble.getDefaultValue() + ");\n";
                    continue;
                }
                if (vField instanceof VirtualFontFieldInfo) {
                    vFont = (VirtualFontFieldInfo)vField;
                    fileText = fileText + "\t\tservice.setStringPreference(IPreferencesService.DEFAULT_LEVEL, " + constantsClassName + "." + PreferencesFactory.preferenceConstantForName(vFont.getName()) + ", " + ((VirtualFontFieldInfo)vFont).getDefaultName() + ");\n";
                    continue;
                }
                if (vField instanceof VirtualColorFieldInfo) {
                    vFont = (VirtualColorFieldInfo)vField;
                    fileText = fileText + "\t\tservice.setStringPreference(IPreferencesService.DEFAULT_LEVEL, " + constantsClassName + "." + PreferencesFactory.preferenceConstantForName(vFont.getName()) + ", \"" + ((VirtualColorFieldInfo)vFont).getDefaultColor() + "\");\n";
                    continue;
                }
                if (vField instanceof VirtualStringFieldInfo) {
                    VirtualStringFieldInfo vString = (VirtualStringFieldInfo)vField;
                    fileText = fileText + "\t\tservice.setStringPreference(IPreferencesService.DEFAULT_LEVEL, " + constantsClassName + "." + PreferencesFactory.preferenceConstantForName(vString.getName()) + ", " + vString.getDefaultValue() + ");\n";
                    continue;
                }
                if (vField instanceof VirtualComboFieldInfo) {
                    VirtualComboFieldInfo vCombo = (VirtualComboFieldInfo)vField;
                    fileText = fileText + "\t\tservice.setStringPreference(IPreferencesService.DEFAULT_LEVEL, " + constantsClassName + "." + PreferencesFactory.preferenceConstantForName(vCombo.getName()) + ", " + PreferencesFactory.getEnumDefaultValueExpr(vCombo.getValueSource()) + ");\n";
                    continue;
                }
                if (vField instanceof VirtualRadioFieldInfo) {
                    VirtualRadioFieldInfo vRadio = (VirtualRadioFieldInfo)vField;
                    fileText = fileText + "\t\tservice.setStringPreference(IPreferencesService.DEFAULT_LEVEL, " + constantsClassName + "." + PreferencesFactory.preferenceConstantForName(vRadio.getName()) + ", " + PreferencesFactory.getEnumDefaultValueExpr(vRadio.getValueSource()) + ");\n";
                    continue;
                }
                fileText = fileText + "\t\t//Encountered unimplemented initialization for field = " + vField.getName() + "\n";
            }
        }
        return fileText;
    }

    private static String getEnumDefaultValueExpr(IEnumValueSource vs) {
        if (vs instanceof LiteralEnumValueSource) {
            LiteralEnumValueSource levs = (LiteralEnumValueSource)vs;
            return "\"" + levs.getDefaultKey() + "\"";
        }
        if (vs instanceof DynamicEnumValueSource) {
            DynamicEnumValueSource devs = (DynamicEnumValueSource)vs;
            return "new " + devs.getQualClassName() + "().getDefaultLabel()";
        }
        return "";
    }

    protected static String generateInitializersAfterFields(String pluginClassName, String fileText) {
        fileText = fileText + "\t}\n\n";
        fileText = fileText + "\t/*\n";
        fileText = fileText + "\t * Clear (remove) any preferences set on the given level.\n";
        fileText = fileText + "\t */\n";
        fileText = fileText + "\tpublic void clearPreferencesOnLevel(String level) {\n";
        fileText = fileText + "\t\tIPreferencesService service = " + pluginClassName + ".getInstance().getPreferencesService();\n";
        fileText = fileText + "\t\tservice.clearPreferencesAtLevel(level);\n\n";
        fileText = fileText + "\t}\n}\n";
        return fileText;
    }

    protected static String generateTabBeforeFields(PreferencesPageInfo pageInfo, String pluginPackageName, String pluginClassName, String packageName2, String className, String initializerClassName, String levelName) {
        if (className.endsWith(".java")) {
            className = className.substring(0, className.length() - 5);
        }
        levelName = levelName.toLowerCase();
        String levelNameUpperInitial = levelName.substring(0, 1).toUpperCase() + levelName.substring(1, levelName.length());
        String fileText = "package " + packageName2 + ";\n\n";
        fileText = fileText + "import java.util.List;\n";
        fileText = fileText + "import java.util.ArrayList;\n";
        fileText = fileText + "import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;\n";
        fileText = fileText + "import org.eclipse.core.runtime.preferences.IEclipsePreferences;\n";
        fileText = fileText + "import org.eclipse.swt.widgets.Composite;\n";
        fileText = fileText + "import org.eclipse.swt.widgets.Link;\n";
        fileText = fileText + "import org.eclipse.imp.preferences.*;\n";
        fileText = fileText + "import org.eclipse.imp.preferences.fields.*;\n";
        fileText = fileText + "import org.osgi.service.prefs.Preferences;\n";
        fileText = fileText + "\n\n/**\n";
        fileText = fileText + " * The " + levelName + " level preferences tab.\n";
        fileText = fileText + " */\n";
        fileText = fileText + "public class " + className + " extends " + levelNameUpperInitial + "PreferencesTab {\n\n";
        fileText = fileText + "\tpublic " + className + "(IPreferencesService prefService) {\n";
        fileText = fileText + "\t\tsuper(prefService, " + pageInfo.getNoDetails() + ");\n";
        fileText = fileText + "\t}\n\n";
        if (initializerClassName != null) {
            fileText = fileText + "\t/**\n";
            fileText = fileText + "\t * Creates a language-specific preferences initializer.\n";
            fileText = fileText + "\t *\n";
            fileText = fileText + "\t * @return    The preference initializer to be used to initialize\n";
            fileText = fileText + "\t *            preferences in this tab\n";
            fileText = fileText + "\t */\n";
            fileText = fileText + "\tpublic AbstractPreferenceInitializer getPreferenceInitializer() {\n";
            fileText = fileText + "\t\t" + initializerClassName + " preferencesInitializer = new " + initializerClassName + "();\n";
            fileText = fileText + "\t\treturn preferencesInitializer;\n";
            fileText = fileText + "\t}\n\n";
        }
        fileText = fileText + "\t/**\n";
        fileText = fileText + "\t * Creates specific preference fields with settings appropriate to\n";
        fileText = fileText + "\t * the " + levelName + " preferences level.\n";
        fileText = fileText + "\t *\n";
        fileText = fileText + "\t * Overrides an unimplemented method in PreferencesTab.\n";
        fileText = fileText + "\t *\n";
        fileText = fileText + "\t * @return    An array that contains the created preference fields\n";
        fileText = fileText + "\t *\n";
        fileText = fileText + "\t */\n";
        fileText = fileText + "\tprotected FieldEditor[] createFields(TabbedPreferencesPage page, Composite parent)\n\t{\n";
        fileText = fileText + "\t\tList<FieldEditor> fields = new ArrayList<FieldEditor>();\n";
        return fileText;
    }

    protected static String generateTabFields(PreferencesPageInfo pageInfo, String constantsClassName, String fileText, String tabLevel) {
        PreferencesTabInfo tabInfo = pageInfo.getTabInfo(tabLevel);
        Iterator<ConcreteFieldInfo> cFields = tabInfo.getConcreteFields();
        while (cFields.hasNext()) {
            ConcreteFieldInfo cFieldInfo = cFields.next();
            if (cFieldInfo instanceof ConcreteBooleanFieldInfo) {
                ConcreteBooleanFieldInfo cBoolFieldInfo = (ConcreteBooleanFieldInfo)cFieldInfo;
                fileText = fileText + PreferencesFactory.getTextToCreateBooleanField(pageInfo, cBoolFieldInfo, tabLevel);
            } else if (cFieldInfo instanceof ConcreteIntFieldInfo) {
                ConcreteIntFieldInfo cIntFieldInfo = (ConcreteIntFieldInfo)cFieldInfo;
                fileText = fileText + PreferencesFactory.getTextToCreateIntegerField(pageInfo, cIntFieldInfo, tabLevel);
            } else if (cFieldInfo instanceof ConcreteDoubleFieldInfo) {
                ConcreteDoubleFieldInfo cDoubleFieldInfo = (ConcreteDoubleFieldInfo)cFieldInfo;
                fileText = fileText + PreferencesFactory.getTextToCreateDoubleField(pageInfo, cDoubleFieldInfo, tabLevel);
            } else if (cFieldInfo instanceof ConcreteStringFieldInfo) {
                ConcreteStringFieldInfo cStringFieldInfo = (ConcreteStringFieldInfo)cFieldInfo;
                fileText = fileText + PreferencesFactory.getTextToCreateStringField(pageInfo, cStringFieldInfo, tabLevel);
            } else if (cFieldInfo instanceof ConcreteFontFieldInfo) {
                ConcreteFontFieldInfo cFontFieldInfo = (ConcreteFontFieldInfo)cFieldInfo;
                fileText = fileText + PreferencesFactory.getTextToCreateFontField(pageInfo, cFontFieldInfo, tabLevel);
            } else if (cFieldInfo instanceof ConcreteColorFieldInfo) {
                ConcreteColorFieldInfo cColorFieldInfo = (ConcreteColorFieldInfo)cFieldInfo;
                fileText = fileText + PreferencesFactory.getTextToCreateColorField(pageInfo, cColorFieldInfo, tabLevel);
            } else if (cFieldInfo instanceof ConcreteComboFieldInfo) {
                ConcreteComboFieldInfo cComboFieldInfo = (ConcreteComboFieldInfo)cFieldInfo;
                fileText = fileText + PreferencesFactory.getTextToCreateComboField(pageInfo, cComboFieldInfo, tabLevel);
            } else if (cFieldInfo instanceof ConcreteRadioFieldInfo) {
                ConcreteRadioFieldInfo cRadioFieldInfo = (ConcreteRadioFieldInfo)cFieldInfo;
                fileText = fileText + PreferencesFactory.getTextToCreateRadioField(pageInfo, cRadioFieldInfo, tabLevel);
            } else {
                fileText = fileText + "\t\t//Encountered unimplemented initialization for field = " + cFieldInfo.getName() + "\n\n";
            }
            if (!cFieldInfo.getIsConditional()) continue;
            fileText = fileText + PreferencesFactory.generateFieldToggleText(cFieldInfo, fileText);
        }
        return fileText;
    }

    protected static String generateFieldToggleText(ConcreteFieldInfo cFieldInfo, String fileText) {
        boolean onProjectLevel = cFieldInfo.getParentTab().getName().equals("project");
        String condFieldName = cFieldInfo.getConditionField().getName();
        String result = "\n";
        result = result + "\t\tfPrefUtils.createToggleFieldListener(" + condFieldName + ", " + cFieldInfo.getName() + ", " + (cFieldInfo.getConditionalWith() ? "true" : "false") + ");\n";
        String enabledValueString = null;
        enabledValueString = onProjectLevel ? "false;\n" : (cFieldInfo.getConditionalWith() ? condFieldName + ".getBooleanValue();\n" : "!" + condFieldName + ".getBooleanValue();\n");
        String enabledFieldName = "isEnabled" + cFieldInfo.getName();
        result = result + "\t\tboolean " + enabledFieldName + " = " + enabledValueString;
        if (cFieldInfo instanceof ConcreteStringFieldInfo) {
            result = result + "\t\t" + cFieldInfo.getName() + ".getTextControl().setEditable(" + enabledFieldName + ");\n";
            result = result + "\t\t" + cFieldInfo.getName() + ".getTextControl().setEnabled(" + enabledFieldName + ");\n";
            result = result + "\t\t" + cFieldInfo.getName() + ".setEnabled(" + enabledFieldName + ", " + cFieldInfo.getName() + ".getParent());\n\n";
        } else if (cFieldInfo instanceof ConcreteBooleanFieldInfo) {
            result = result + "\t\t" + cFieldInfo.getName() + ".getChangeControl().setEnabled(" + enabledFieldName + ");\n";
            result = result + "\t\t" + cFieldInfo.getName() + ".setEnabled(" + enabledFieldName + ", " + cFieldInfo.getName() + ".getParent());\n\n";
        }
        return result;
    }

    protected static String getTextToCreateBooleanField(PreferencesPageInfo pageInfo, ConcreteBooleanFieldInfo fieldInfo, String tabLevel) {
        boolean editable = !tabLevel.equals("project");
        String label = fieldInfo.getLabel() != null ? fieldInfo.getLabel() : PreferencesFactory.createLabelFor(fieldInfo.getName());
        String toolTip = fieldInfo.getToolTip();
        String result = "\n";
        result = result + "\t\tBooleanFieldEditor " + fieldInfo.getName() + " = fPrefUtils.makeNewBooleanField(\n";
        result = result + "\t\t\tpage, this, fPrefService,\n";
        result = result + "\t\t\t\"" + tabLevel + "\", \"" + fieldInfo.getName() + "\", \"" + label + "\",\n";
        result = result + "\t\t\t\"" + (toolTip != null ? toolTip : "") + "\",\n";
        result = result + "\t\t\tparent,\n";
        result = result + "\t\t\t" + editable + ", " + editable + ",\n";
        result = result + "\t\t\t" + fieldInfo.getHasSpecialValue() + ", " + fieldInfo.getSpecialValue() + ",\n";
        result = result + "\t\t\tfalse, false,\n";
        result = result + "\t\t\t" + fieldInfo.getIsRemovable() + ");\n";
        result = result + "\t\tfields.add(" + fieldInfo.getName() + ");\n\n";
        if (!pageInfo.getNoDetails()) {
            String linkName = fieldInfo.getName() + "DetailsLink";
            result = result + "\t\tLink " + linkName + " = fPrefUtils.createDetailsLink(parent, " + fieldInfo.getName() + ", " + fieldInfo.getName() + ".getChangeControl().getParent()" + ", \"Details ...\");\n\n";
            result = result + "\t\t" + linkName + ".setEnabled(" + editable + ");\n";
            result = result + "\t\tfDetailsLinks.add(" + linkName + ");\n\n";
        }
        return result;
    }

    private static String createLabelFor(String name) {
        StringBuilder sb = new StringBuilder();
        int from = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            if (i < name.length() - 1 && Character.isUpperCase(name.charAt(i + 1))) {
                sb.append(name.charAt(from));
                from = i;
                continue;
            }
            if (i == from) continue;
            if (i > 0 && from > 0) {
                sb.append(' ');
            }
            if (from > 0 && i > from + 1) {
                PreferencesFactory.appendLowerWord(name, from, i, sb);
            } else {
                sb.append(name.substring(from, i));
            }
            from = i;
        }
        if (from < name.length()) {
            if (from > 0) {
                sb.append(' ');
                PreferencesFactory.appendLowerWord(name, from, name.length(), sb);
            } else {
                sb.append(name.substring(from, name.length()));
            }
        }
        return sb.toString();
    }

    private static void appendLowerWord(String s, int from, int to, StringBuilder sb) {
        if (from > 0 && to > from + 1) {
            sb.append(Character.toLowerCase(s.charAt(from)));
        } else {
            sb.append(s.charAt(from));
        }
        sb.append(s.substring(from + 1, to));
    }

    protected static String getTextToCreateIntegerField(PreferencesPageInfo pageInfo, ConcreteIntFieldInfo fieldInfo, String tabLevel) {
        boolean editable = !tabLevel.equals("project");
        String label = fieldInfo.getLabel() != null ? fieldInfo.getLabel() : PreferencesFactory.createLabelFor(fieldInfo.getName());
        String toolTip = fieldInfo.getToolTip();
        String result = "\n";
        result = result + "\t\tIntegerFieldEditor " + fieldInfo.getName() + " = fPrefUtils.makeNewIntegerField(\n";
        result = result + "\t\t\tpage, this, fPrefService,\n";
        result = result + "\t\t\t\"" + tabLevel + "\", \"" + fieldInfo.getName() + "\", \"" + label + "\",\n";
        result = result + "\t\t\t\"" + (toolTip != null ? toolTip : "") + "\",\n";
        result = result + "\t\t\tparent,\n";
        result = result + "\t\t\t" + editable + ", " + editable + ",\n";
        result = result + "\t\t\t" + fieldInfo.getHasSpecialValue() + ", String.valueOf(" + fieldInfo.getSpecialValue() + "),\n";
        result = result + "\t\t\tfalse, \"0\",\n";
        result = result + "\t\t\t" + fieldInfo.getIsRemovable() + ");\n";
        result = result + "\t\tfields.add(" + fieldInfo.getName() + ");\n\n";
        if (!pageInfo.getNoDetails()) {
            String linkName = fieldInfo.getName() + "DetailsLink";
            result = result + "\t\tLink " + fieldInfo.getName() + "DetailsLink = fPrefUtils.createDetailsLink(parent, " + fieldInfo.getName() + ", " + fieldInfo.getName() + ".getTextControl().getParent()" + ", \"Details ...\");\n\n";
            result = result + "\t\t" + linkName + ".setEnabled(" + editable + ");\n";
            result = result + "\t\tfDetailsLinks.add(" + linkName + ");\n\n";
        }
        return result;
    }

    protected static String getTextToCreateDoubleField(PreferencesPageInfo pageInfo, ConcreteDoubleFieldInfo fieldInfo, String tabLevel) {
        boolean editable = !tabLevel.equals("project");
        String label = fieldInfo.getLabel() != null ? fieldInfo.getLabel() : PreferencesFactory.createLabelFor(fieldInfo.getName());
        String toolTip = fieldInfo.getToolTip();
        String result = "\n";
        result = result + "\t\tDoubleFieldEditor " + fieldInfo.getName() + " = fPrefUtils.makeNewDoubleField(\n";
        result = result + "\t\t\tpage, this, fPrefService,\n";
        result = result + "\t\t\t\"" + tabLevel + "\", \"" + fieldInfo.getName() + "\", \"" + label + "\",\n";
        result = result + "\t\t\t\"" + (toolTip != null ? toolTip : "") + "\",\n";
        result = result + "\t\t\tparent,\n";
        result = result + "\t\t\t" + editable + ", " + editable + ",\n";
        result = result + "\t\t\tfalse, \"0\",\n";
        result = result + "\t\t\t" + fieldInfo.getIsRemovable() + ");\n";
        result = result + "\t\tfields.add(" + fieldInfo.getName() + ");\n\n";
        if (!pageInfo.getNoDetails()) {
            String linkName = fieldInfo.getName() + "DetailsLink";
            result = result + "\t\tLink " + fieldInfo.getName() + "DetailsLink = fPrefUtils.createDetailsLink(parent, " + fieldInfo.getName() + ", " + fieldInfo.getName() + ".getTextControl().getParent()" + ", \"Details ...\");\n\n";
            result = result + "\t\t" + linkName + ".setEnabled(" + editable + ");\n";
            result = result + "\t\tfDetailsLinks.add(" + linkName + ");\n\n";
        }
        return result;
    }

    protected static String getTextToCreateStringField(PreferencesPageInfo pageInfo, ConcreteStringFieldInfo fieldInfo, String tabLevel) {
        boolean editable = !tabLevel.equals("project");
        String label = fieldInfo.getLabel() != null ? fieldInfo.getLabel() : PreferencesFactory.createLabelFor(fieldInfo.getName());
        String toolTip = fieldInfo.getToolTip();
        String result = "\n";
        if (fieldInfo instanceof ConcreteDirListFieldInfo) {
            result = result + "\t\tDirectoryListFieldEditor " + fieldInfo.getName() + " = fPrefUtils.makeNewDirectoryListField(\n";
        } else if (fieldInfo instanceof ConcreteFileFieldInfo) {
            result = result + "\t\tFileFieldEditor " + fieldInfo.getName() + " = fPrefUtils.makeNewFileField(\n";
        } else if (fieldInfo instanceof ConcreteDirectoryFieldInfo) {
            result = result + "\t\tDirectoryFieldEditor " + fieldInfo.getName() + " = fPrefUtils.makeNewDirectoryField(\n";
        } else if (fieldInfo instanceof ConcreteStringFieldInfo) {
            result = result + "\t\tStringFieldEditor " + fieldInfo.getName() + " = fPrefUtils.makeNewStringField(\n";
        }
        result = result + "\t\t\tpage, this, fPrefService,\n";
        result = result + "\t\t\t\"" + tabLevel + "\", \"" + fieldInfo.getName() + "\", \"" + label + "\",\n";
        result = result + "\t\t\t\"" + (toolTip != null ? toolTip : "") + "\",\n";
        result = result + "\t\t\tparent,\n";
        result = result + "\t\t\t" + editable + ", " + editable + ",\n";
        result = result + "\t\t\t" + fieldInfo.getHasSpecialValue() + ", \"" + PreferencesFactory.stripQuotes(fieldInfo.getSpecialValue()) + "\",\n";
        result = result + "\t\t\t" + fieldInfo.getEmptyValueAllowed() + ", \"" + PreferencesFactory.stripQuotes(fieldInfo.getEmptyValue()) + "\",\n";
        result = result + "\t\t\t" + fieldInfo.getIsRemovable() + ");\n";
        if (fieldInfo.getValidatorQualClass() != null && fieldInfo.getValidatorQualClass().length() > 0) {
            result = result + "\t\t" + fieldInfo.getName() + ".setValidator(new " + fieldInfo.getValidatorQualClass() + "());\n";
        }
        result = result + "\t\tfields.add(" + fieldInfo.getName() + ");\n\n";
        if (!pageInfo.getNoDetails()) {
            String linkName = fieldInfo.getName() + "DetailsLink";
            result = result + "\t\tLink " + linkName + " = fPrefUtils.createDetailsLink(parent, " + fieldInfo.getName() + ", " + fieldInfo.getName() + ".getTextControl().getParent()" + ", \"Details ...\");\n\n";
            result = result + "\t\t" + linkName + ".setEnabled(" + editable + ");\n";
            result = result + "\t\tfDetailsLinks.add(" + linkName + ");\n\n";
        }
        return result;
    }

    protected static String getTextToCreateFontField(PreferencesPageInfo pageInfo, ConcreteFontFieldInfo fieldInfo, String tabLevel) {
        boolean editable = !tabLevel.equals("project");
        String label = fieldInfo.getLabel() != null ? fieldInfo.getLabel() : PreferencesFactory.createLabelFor(fieldInfo.getName());
        String toolTip = fieldInfo.getToolTip();
        String result = "\n";
        result = result + "\t\tFontFieldEditor " + fieldInfo.getName() + " = fPrefUtils.makeNewFontField(\n";
        result = result + "\t\t\tpage, this, fPrefService,\n";
        result = result + "\t\t\t\"" + tabLevel + "\", \"" + fieldInfo.getName() + "\", \"" + label + "\",\n";
        result = result + "\t\t\t\"" + (toolTip != null ? toolTip : "") + "\",\n";
        result = result + "\t\t\tparent,\n";
        result = result + "\t\t\t" + editable + ", " + editable + ",\n";
        result = result + "\t\t\t" + fieldInfo.getIsRemovable() + ");\n";
        result = result + "\t\tfields.add(" + fieldInfo.getName() + ");\n\n";
        if (!pageInfo.getNoDetails()) {
            String linkName = fieldInfo.getName() + "DetailsLink";
            result = result + "\t\tLink " + linkName + " = fPrefUtils.createDetailsLink(parent, " + fieldInfo.getName() + ", " + fieldInfo.getName() + ".getChangeControl().getParent()" + ", \"Details ...\");\n\n";
            result = result + "\t\t" + linkName + ".setEnabled(" + editable + ");\n";
            result = result + "\t\tfDetailsLinks.add(" + linkName + ");\n\n";
        }
        return result;
    }

    protected static String getTextToCreateColorField(PreferencesPageInfo pageInfo, ConcreteColorFieldInfo fieldInfo, String tabLevel) {
        boolean editable = !tabLevel.equals("project");
        String label = fieldInfo.getLabel() != null ? fieldInfo.getLabel() : PreferencesFactory.createLabelFor(fieldInfo.getName());
        String toolTip = fieldInfo.getToolTip();
        String result = "\n";
        result = result + "\t\tColorFieldEditor " + fieldInfo.getName() + " = fPrefUtils.makeNewColorField(\n";
        result = result + "\t\t\tpage, this, fPrefService,\n";
        result = result + "\t\t\t\"" + tabLevel + "\", \"" + fieldInfo.getName() + "\", \"" + label + "\",\n";
        result = result + "\t\t\t\"" + (toolTip != null ? toolTip : "") + "\",\n";
        result = result + "\t\t\tparent,\n";
        result = result + "\t\t\t" + editable + ", " + editable + ",\n";
        result = result + "\t\t\t" + fieldInfo.getIsRemovable() + ");\n";
        result = result + "\t\tfields.add(" + fieldInfo.getName() + ");\n\n";
        if (!pageInfo.getNoDetails()) {
            String linkName = fieldInfo.getName() + "DetailsLink";
            result = result + "\t\tLink " + linkName + " = fPrefUtils.createDetailsLink(parent, " + fieldInfo.getName() + ", " + fieldInfo.getName() + ".getChangeControl().getParent()" + ", \"Details ...\");\n\n";
            result = result + "\t\t" + linkName + ".setEnabled(" + editable + ");\n";
            result = result + "\t\tfDetailsLinks.add(" + linkName + ");\n\n";
        }
        return result;
    }

    protected static String getTextToCreateComboField(PreferencesPageInfo pageInfo, ConcreteComboFieldInfo fieldInfo, String tabLevel) {
        boolean editable = !tabLevel.equals("project");
        String label = fieldInfo.getLabel() != null ? fieldInfo.getLabel() : PreferencesFactory.createLabelFor(fieldInfo.getName());
        String toolTip = fieldInfo.getToolTip();
        String result = "\n";
        if (fieldInfo.getValueSource() instanceof DynamicEnumValueSource) {
            DynamicEnumValueSource evs = (DynamicEnumValueSource)fieldInfo.getValueSource();
            result = result + "\t\tIEnumValueProvider evp = new " + evs.getQualClassName() + "();\n";
        }
        result = result + "\t\tComboFieldEditor " + fieldInfo.getName() + " = fPrefUtils.makeNewComboField(\n";
        result = result + "\t\t\tpage, this, fPrefService,\n";
        result = result + "\t\t\t\"" + tabLevel + "\", \"" + fieldInfo.getName() + "\", \"" + label + "\",\n";
        result = result + "\t\t\t\"" + (toolTip != null ? toolTip : "") + "\",\n";
        result = result + "\t\t\t" + fieldInfo.getNumColumns() + ",\n";
        result = result + "\t\t\t" + PreferencesFactory.getValueStringsExpr(fieldInfo.getValueSource()) + ",\n";
        result = result + "\t\t\t" + PreferencesFactory.getLabelStringsExpr(fieldInfo.getValueSource()) + ",\n";
        result = result + "\t\t\tparent,\n";
        result = result + "\t\t\t" + editable + ",\n";
        result = result + "\t\t\t" + fieldInfo.getIsRemovable() + ");\n";
        result = result + "\t\tfields.add(" + fieldInfo.getName() + ");\n\n";
        if (!pageInfo.getNoDetails()) {
            String linkName = fieldInfo.getName() + "DetailsLink";
            result = result + "\t\tLink " + linkName + " = fPrefUtils.createDetailsLink(parent, " + fieldInfo.getName() + ", " + fieldInfo.getName() + ".getComboBoxControl().getParent()" + ", \"Details ...\");\n\n";
            result = result + "\t\t" + linkName + ".setEnabled(" + editable + ");\n";
            result = result + "\t\tfDetailsLinks.add(" + linkName + ");\n\n";
        }
        return result;
    }

    protected static String getTextToCreateRadioField(PreferencesPageInfo pageInfo, ConcreteRadioFieldInfo fieldInfo, String tabLevel) {
        boolean editable = !tabLevel.equals("project");
        String label = fieldInfo.getLabel() != null ? fieldInfo.getLabel() : PreferencesFactory.createLabelFor(fieldInfo.getName());
        String toolTip = fieldInfo.getToolTip();
        String result = "\n";
        if (fieldInfo.getValueSource() instanceof DynamicEnumValueSource) {
            DynamicEnumValueSource evs = (DynamicEnumValueSource)fieldInfo.getValueSource();
            result = result + "\t\tIEnumValueProvider evp = new " + evs.getQualClassName() + "();\n";
        }
        result = result + "\t\tRadioGroupFieldEditor " + fieldInfo.getName() + " = fPrefUtils.makeNewRadioGroupField(\n";
        result = result + "\t\t\tpage, this, fPrefService,\n";
        result = result + "\t\t\t\"" + tabLevel + "\", \"" + fieldInfo.getName() + "\", \"" + label + "\",\n";
        result = result + "\t\t\t\"" + (toolTip != null ? toolTip : "") + "\",\n";
        result = result + "\t\t\t" + fieldInfo.getNumColumns() + ",\n";
        result = result + "\t\t\t" + PreferencesFactory.getValueStringsExpr(fieldInfo.getValueSource()) + ",\n";
        result = result + "\t\t\t" + PreferencesFactory.getLabelStringsExpr(fieldInfo.getValueSource()) + ",\n";
        result = result + "\t\t\tparent,\n";
        result = result + "\t\t\ttrue,\n";
        result = result + "\t\t\t" + editable + ",\n";
        result = result + "\t\t\t" + fieldInfo.getIsRemovable() + ");\n";
        result = result + "\t\tfields.add(" + fieldInfo.getName() + ");\n\n";
        if (!pageInfo.getNoDetails()) {
            String linkName = fieldInfo.getName() + "DetailsLink";
            result = result + "\t\tLink " + linkName + " = fPrefUtils.createDetailsLink(parent, " + fieldInfo.getName() + ", " + fieldInfo.getName() + ".getRadioBoxControl().getParent()" + ", \"Details ...\");\n\n";
            result = result + "\t\t" + linkName + ".setEnabled(" + editable + ");\n";
            result = result + "\t\tfDetailsLinks.add(" + linkName + ");\n\n";
        }
        return result;
    }

    protected static String generateTabAfterFields(String fileText) {
        fileText = fileText + "\t\treturn fields.toArray(new FieldEditor[fields.size()]);\n";
        return fileText + "\t}\n}\n";
    }

    protected static String regenerateEndOfProjectTab(PreferencesPageInfo pageInfo, String fileText) {
        String fieldName;
        ConcreteFieldInfo cFieldInfo;
        fileText = fileText.substring(0, fileText.lastIndexOf("}")) + "\n\n";
        fileText = fileText + "\tprotected void addressProjectSelection(IPreferencesService.ProjectSelectionEvent event, Composite composite)\n";
        fileText = fileText + "\t{\n";
        fileText = fileText + "\t\tboolean haveCurrentListeners = false;\n\n";
        fileText = fileText + "\t\tPreferences oldNode = event.getPrevious();\n";
        fileText = fileText + "\t\tPreferences newNode = event.getNew();\n\n";
        fileText = fileText + "\t\tif (oldNode == null && newNode == null) {\n";
        fileText = fileText + "\t\t\t// Happens sometimes when you clear the project selection.\n";
        fileText = fileText + "\t\t\t// Nothing, really, to do in this case ...\n";
        fileText = fileText + "\t\t\treturn;\n";
        fileText = fileText + "\t\t}\n\n";
        fileText = fileText + "\t\t// If oldeNode is not null, we want to remove any preference-change listeners from it\n";
        fileText = fileText + "\t\tif (oldNode != null && oldNode instanceof IEclipsePreferences && haveCurrentListeners) {\n";
        fileText = fileText + "\t\t\tremoveProjectPreferenceChangeListeners();\n";
        fileText = fileText + "\t\t\thaveCurrentListeners = false;\n";
        fileText = fileText + "\t\t} else {\n";
        fileText = fileText + "\t\t\t// Print an advisory message if you want to\n";
        fileText = fileText + "\t\t}\n\n";
        fileText = fileText + "\t\t// Declare local references to the fields\n";
        PreferencesTabInfo tabInfo = pageInfo.getTabInfo("project");
        Iterator<ConcreteFieldInfo> cFields = tabInfo.getConcreteFields();
        int i = 0;
        while (cFields.hasNext()) {
            cFieldInfo = cFields.next();
            String fieldTypeName = null;
            fieldTypeName = cFieldInfo instanceof ConcreteBooleanFieldInfo ? "BooleanFieldEditor" : (cFieldInfo instanceof ConcreteDirListFieldInfo ? "DirectoryListFieldEditor" : (cFieldInfo instanceof ConcreteFileFieldInfo ? "FileFieldEditor" : (cFieldInfo instanceof ConcreteIntFieldInfo ? "IntegerFieldEditor" : (cFieldInfo instanceof ConcreteDoubleFieldInfo ? "DoubleFieldEditor" : (cFieldInfo instanceof ConcreteStringFieldInfo ? "StringFieldEditor" : (cFieldInfo instanceof ConcreteFontFieldInfo ? "FontFieldEditor" : (cFieldInfo instanceof ConcreteColorFieldInfo ? "ColorFieldEditor" : (cFieldInfo instanceof ConcreteComboFieldInfo ? "ComboFieldEditor" : (cFieldInfo instanceof ConcreteRadioFieldInfo ? "RadioGroupFieldEditor" : "UnrecognizedFieldType")))))))));
            fileText = fileText + "\t\t" + fieldTypeName + " " + cFieldInfo.getName() + " = (" + fieldTypeName + ") fFields[" + i + "];\n";
            fileText = fileText + "\t\tLink " + cFieldInfo.getName() + "DetailsLink" + " = (Link) fDetailsLinks.get(" + i + ");\n";
            ++i;
        }
        fileText = fileText + "\n";
        fileText = fileText + "\t\t// If we have a new project preferences node, then do various things\n";
        fileText = fileText + "\t\t// to set up the project's preferences\n";
        fileText = fileText + "\t\tif (newNode != null && newNode instanceof IEclipsePreferences) {\n";
        fileText = fileText + "\t\t\t// If the containing composite is not disposed, then set field values\n";
        fileText = fileText + "\t\t\t// and make them enabled and editable (as appropriate to the type of field)\n\n";
        fileText = fileText + "\t\t\tif (!composite.isDisposed()) {\n";
        fileText = fileText + "\t\t\t\t// Note:  Where there are toggles between fields, it is a good idea to set the\n";
        fileText = fileText + "\t\t\t\t// properties of the dependent field here according to the values they should have\n";
        fileText = fileText + "\t\t\t\t// based on the independent field.  There should be listeners to take care of \n";
        fileText = fileText + "\t\t\t\t// that sort of adjustment once the tab is established, but when properties are\n";
        fileText = fileText + "\t\t\t\t// first initialized here, the properties may not always be set correctly through\n";
        fileText = fileText + "\t\t\t\t// the toggle.  I'm not entirely sure why that happens, except that there may be\n";
        fileText = fileText + "\t\t\t\t// a race condition between the setting of the dependent values by the listener\n";
        fileText = fileText + "\t\t\t\t// and the setting of those values here.  If the values are set by the listener\n";
        fileText = fileText + "\t\t\t\t// first (which might be surprising, but may be possible) then they will be\n";
        fileText = fileText + "\t\t\t\t// overwritten by values set here--so the values set here should be consistent\n";
        fileText = fileText + "\t\t\t\t// with what the listener would set.\n\n";
        tabInfo = pageInfo.getTabInfo("project");
        cFields = tabInfo.getConcreteFields();
        while (cFields.hasNext()) {
            cFieldInfo = cFields.next();
            fieldName = cFieldInfo.getName();
            String enabledRepresentation = null;
            if (!cFieldInfo.getIsConditional()) {
                enabledRepresentation = Boolean.toString(cFieldInfo.getIsEditable());
            } else {
                enabledRepresentation = cFieldInfo.getConditionField().getName() + ".getBooleanValue()";
                if (!cFieldInfo.getConditionalWith()) {
                    enabledRepresentation = "!" + enabledRepresentation;
                }
            }
            if (cFieldInfo instanceof ConcreteBooleanFieldInfo) {
                fileText = fileText + "\t\t\t\tfPrefUtils.setField(" + fieldName + ", " + fieldName + ".getHolder());\n";
                fileText = fileText + "\t\t\t\t" + fieldName + ".getChangeControl().setEnabled(" + enabledRepresentation + ");\n";
            } else if (cFieldInfo instanceof ConcreteIntFieldInfo || cFieldInfo instanceof ConcreteStringFieldInfo) {
                fileText = fileText + "\t\t\t\tfPrefUtils.setField(" + fieldName + ", " + fieldName + ".getHolder());\n";
                fileText = fileText + "\t\t\t\t" + fieldName + ".getTextControl().setEditable(" + enabledRepresentation + ");\n";
                fileText = fileText + "\t\t\t\t" + fieldName + ".getTextControl().setEnabled(" + enabledRepresentation + ");\n";
                fileText = fileText + "\t\t\t\t" + fieldName + ".setEnabled(" + enabledRepresentation + ", " + fieldName + ".getParent());\n";
            }
            fileText = fileText + "\t\t\t\t" + fieldName + "DetailsLink.setEnabled(selectedProjectCombo.getText().length() > 0);\n\n";
        }
        fileText = fileText + "\t\t\t\tclearModifiedMarksOnLabels();\n";
        fileText = fileText + "\t\t\t}\n\n";
        fileText = fileText + "\t\t\t// Add property change listeners\n";
        tabInfo = pageInfo.getTabInfo("project");
        cFields = tabInfo.getConcreteFields();
        while (cFields.hasNext()) {
            cFieldInfo = cFields.next();
            fieldName = cFieldInfo.getName();
            fileText = fileText + "\t\t\tif (" + fieldName + ".getHolder() != null) addProjectPreferenceChangeListeners(" + fieldName + ", \"" + fieldName + "\", " + fieldName + ".getHolder());\n";
        }
        fileText = fileText + "\n\t\t\thaveCurrentListeners = true;\n";
        fileText = fileText + "\t\t}\n\n";
        fileText = fileText + "\t\t// Or if we don't have a new project preferences node ...\n";
        fileText = fileText + "\t\tif (newNode == null || !(newNode instanceof IEclipsePreferences)) {\n";
        fileText = fileText + "\t\t\t// May happen when the preferences page is first brought up, or\n";
        fileText = fileText + "\t\t\t// if we allow the project to be deselected\\nn";
        fileText = fileText + "\t\t\t// Clear the preferences from the store\n";
        fileText = fileText + "\t\t\tfPrefService.clearPreferencesAtLevel(IPreferencesService.PROJECT_LEVEL);\n\n";
        fileText = fileText + "\t\t\t// Disable fields and make them non-editable\n";
        fileText = fileText + "\t\t\tif (!composite.isDisposed()) {\n";
        tabInfo = pageInfo.getTabInfo("project");
        cFields = tabInfo.getConcreteFields();
        while (cFields.hasNext()) {
            cFieldInfo = cFields.next();
            fieldName = cFieldInfo.getName();
            if (cFieldInfo instanceof ConcreteBooleanFieldInfo) {
                fileText = fileText + "\t\t\t\t" + fieldName + ".getChangeControl().setEnabled(false);\n\n";
                continue;
            }
            if (!(cFieldInfo instanceof ConcreteIntFieldInfo) && !(cFieldInfo instanceof ConcreteStringFieldInfo)) continue;
            fileText = fileText + "\t\t\t\t" + fieldName + ".getTextControl().setEditable(false);\n";
            fileText = fileText + "\t\t\t\t" + fieldName + ".getTextControl().setEnabled(false);\n";
            fileText = fileText + "\t\t\t\t" + fieldName + ".setEnabled(false, " + fieldName + ".getParent());\n\n";
        }
        fileText = fileText + "\t\t\t}\n\n";
        fileText = fileText + "\t\t\t// Remove listeners\n";
        fileText = fileText + "\t\t\tremoveProjectPreferenceChangeListeners();\n";
        fileText = fileText + "\t\t\thaveCurrentListeners = false;\n";
        fileText = fileText + "\t\t\t// To help assure that field properties are established properly\n";
        fileText = fileText + "\t\t\tperformApply();\n";
        fileText = fileText + "\t\t}\n";
        fileText = fileText + "\t}\n\n";
        fileText = fileText + "\n}\n";
        return fileText;
    }

    protected IFile createFileWithText(String fileText, ISourceProject project, String projectSourceLocation, String packageName2, String className, IProgressMonitor mon) {
        IFolder packageFolder = null;
        String packageFolderName = packageName2.replace(".", "/");
        String createdPath = null;
        String[] pathSegs = (projectSourceLocation + packageFolderName).split("/");
        for (int i = 0; i < pathSegs.length; ++i) {
            createdPath = createdPath == null ? pathSegs[i] : createdPath + "/" + pathSegs[i];
            packageFolder = project.getRawProject().getFolder(createdPath);
            try {
                if (packageFolder.exists()) continue;
                packageFolder.create(true, true, mon);
                if (packageFolder.exists()) continue;
                this.fConsoleStream.println("PreferencesFactory.createFileWithText(): cannot find or create package folder; returning null\tpackage folder = " + packageFolder.getLocation().toString());
                return null;
            }
            catch (CoreException e) {
                this.fConsoleStream.println("PreferencesFactory.createFileWithText(): CoreException finding or creating package folder; returning null\tpackage folder = " + packageFolder.getLocation().toString());
                return null;
            }
        }
        String fileName = className;
        if (!fileName.endsWith(".java")) {
            fileName = fileName + ".java";
        }
        IFile file = packageFolder.getFile(fileName);
        try {
            if (file.exists()) {
                file.setContents((InputStream)new ByteArrayInputStream(fileText.getBytes()), true, true, mon);
            } else {
                file.create((InputStream)new ByteArrayInputStream(fileText.getBytes()), true, mon);
            }
        }
        catch (CoreException e) {
            this.fConsoleStream.println("PreferencesFactory.createFileWithText(): CoreException creating file; returning null");
            return null;
        }
        return file;
    }

    protected static String preferenceConstantForName(String name) {
        return "P_" + name.toUpperCase();
    }

    public static String stripQuotes(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            if (s.charAt(0) == '\"') {
                return "";
            }
            return s;
        }
        int newStart = s.charAt(0) == '\"' ? 1 : 0;
        int newEnd = s.charAt(s.length() - 1) == '\"' ? s.length() - 1 : s.length();
        return s.substring(newStart, newEnd);
    }

    public static String toStringArrayLiteral(String[] strings) {
        StringBuilder sb = new StringBuilder();
        sb.append("new String[] { ");
        for (int i = 0; i < strings.length; ++i) {
            String s;
            if (i > 0) {
                sb.append(", ");
            }
            if ((s = strings[i]) != null) {
                PreferencesFactory.appendWithQuotes(s, sb);
                continue;
            }
            sb.append("null");
        }
        sb.append(" }");
        return sb.toString();
    }

    public static String toStringArrayLiteral(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        sb.append("new String[] { ");
        for (int i = 0; i < strings.size(); ++i) {
            String s;
            if (i > 0) {
                sb.append(", ");
            }
            if ((s = strings.get(i)) != null) {
                PreferencesFactory.appendWithQuotes(s, sb);
                continue;
            }
            sb.append("null");
        }
        sb.append(" }");
        return sb.toString();
    }

    public static String getValueStringsExpr(IEnumValueSource vs) {
        if (vs instanceof LiteralEnumValueSource) {
            LiteralEnumValueSource levs = (LiteralEnumValueSource)vs;
            List<String> labels = levs.getValues();
            return PreferencesFactory.toStringArrayLiteral(labels);
        }
        if (vs instanceof DynamicEnumValueSource) {
            return "evp.getValues()";
        }
        throw new IllegalStateException("Unexpected type of enum value source: " + vs.getClass().getCanonicalName());
    }

    private static void appendWithQuotes(String s, StringBuilder sb) {
        if (!s.startsWith("\"")) {
            sb.append("\"");
        }
        sb.append(s);
        if (!s.endsWith("\"")) {
            sb.append("\"");
        }
    }

    public static String getLabelStringsExpr(IEnumValueSource vs) {
        StringBuilder sb = new StringBuilder();
        if (vs instanceof LiteralEnumValueSource) {
            LiteralEnumValueSource levs = (LiteralEnumValueSource)vs;
            List<String> values = levs.getValues();
            List<String> labels = levs.getLabels();
            sb.append("new String[] { ");
            for (int i = 0; i < labels.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                if (labels.get(i) != null) {
                    PreferencesFactory.appendWithQuotes(labels.get(i), sb);
                    continue;
                }
                PreferencesFactory.appendWithQuotes(PreferencesFactory.createLabelFor(values.get(i)), sb);
            }
            sb.append(" }");
        } else if (vs instanceof DynamicEnumValueSource) {
            sb.append("evp.getLabels()");
        }
        return sb.toString();
    }
}

