/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.pageinfo;

import org.eclipse.imp.prefspecs.pageinfo.PreferencesPageInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualFieldInfo;
import org.eclipse.ui.console.MessageConsoleStream;

public class VirtualIntFieldInfo
extends VirtualFieldInfo {
    protected int defaultValue = 0;
    protected int specialValue = 0;
    protected boolean hasRangeSpec = false;
    protected int rangeHigh = Integer.MAX_VALUE;
    protected int rangeLow = Integer.MIN_VALUE;

    public VirtualIntFieldInfo(PreferencesPageInfo parentPage, String name) {
        super(parentPage, name);
    }

    public VirtualIntFieldInfo(PreferencesPageInfo parentPage, String name, int defValue) {
        this(parentPage, name);
        this.defaultValue = defValue;
    }

    public VirtualIntFieldInfo(PreferencesPageInfo parentPage, String name, int defValue, boolean hasSpecialValue, int specialValue) {
        this(parentPage, name, defValue);
        this.hasSpecialValue = hasSpecialValue;
        this.specialValue = specialValue;
    }

    public void setDefaultValue(int i) {
        if (i < this.getRangeLow() || i > this.getRangeHigh()) {
            throw new IllegalArgumentException("VirtualIntFieldInfo.setDefaultValue(int):  attempt to set default value = " + i + " outside of range = " + this.getRangeLow() + ".." + this.getRangeHigh());
        }
        this.defaultValue = i;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setSpecialValue(int i) {
        if (!this.getHasSpecialValue()) {
            throw new IllegalArgumentException("VirtualIntFieldInfo.setSpecialValue(int):  attempt to set special value when field has no special value");
        }
        if (i < this.getRangeLow() || i > this.getRangeHigh()) {
            throw new IllegalArgumentException("VirtualIntFieldInfo.setSpecialValue(int):  attempt to set special value = " + i + " outside of range = " + this.getRangeLow() + ".." + this.getRangeHigh());
        }
        this.specialValue = i;
    }

    public int getSpecialValue() {
        return this.specialValue;
    }

    public boolean hasRangeSpec() {
        return this.hasRangeSpec;
    }

    public void setRange(int low, int high) {
        if (high < low) {
            throw new IllegalArgumentException("VirtualIntField.setRange(int,int):  given high value = " + high + " is less than low value " + low);
        }
        this.hasRangeSpec = true;
        this.rangeLow = low;
        this.rangeHigh = high;
    }

    public int getRangeHigh() {
        return this.rangeHigh;
    }

    public int getRangeLow() {
        return this.rangeLow;
    }

    public void dump(String prefix, MessageConsoleStream out) {
        super.dump(prefix, out);
        String indent = prefix + "  ";
        out.println(indent + "hasSpecialValue  = " + this.getHasSpecialValue());
        out.println(indent + "specialValue     = " + this.getSpecialValue());
        out.println(indent + "defaultVallue    = " + this.getDefaultValue());
    }
}

