/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.editor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.imp.lpg.LPGRuntimePlugin;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesService;
import org.eclipse.imp.services.IAutoEditStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class LPGAutoEditStrategy
implements IAutoEditStrategy {
    private IPreferencesService fPrefsService = new PreferencesService(null, LPGRuntimePlugin.getInstance().getLanguageID());
    private static final Pattern NEXT_SEGMENT_PATTERN = Pattern.compile("%([^eE]|([eE][^nN])|([eE][nN][^dD]))");
    private int fIndentWidth;
    private boolean fSpacesForTabs;
    private int fTabWidth;

    public void customizeDocumentCommand(IDocument doc, DocumentCommand cmd) {
        if (!cmd.doit) {
            return;
        }
        this.fSpacesForTabs = this.fPrefsService.getBooleanPreference("spacesForTabs");
        this.fTabWidth = this.fPrefsService.getIntPreference("tabWidth");
        if (cmd.length == 0 && cmd.text != null && this.isLineDelimiter(doc, cmd.text)) {
            this.smartIndentAfterNewline(doc, cmd);
        } else if (!this.fSpacesForTabs && cmd.length == 0 && cmd.text.length() == 1 && cmd.text.charAt(0) == '\t') {
            this.smartIndentOnTab(doc, cmd);
        } else if (this.fSpacesForTabs && cmd.length == 0 && cmd.text.length() > 1 && cmd.text.length() <= this.fTabWidth && cmd.text.trim().length() == 0) {
            this.smartIndentOnTab(doc, cmd);
        }
    }

    private void smartIndentAfterNewline(IDocument doc, DocumentCommand cmd) {
        try {
            this.fIndentWidth = this.fPrefsService.getIntPreference("indentWidth");
            IRegion r = doc.getLineInformation(doc.getLineOfOffset(cmd.offset));
            String thisLine = doc.get(r.getOffset(), r.getLength());
            int thisLineNum = doc.getLineOfOffset(cmd.offset);
            int thisLineStart = doc.getLineOffset(thisLineNum);
            if (thisLine.startsWith("%")) {
                String contents = doc.get();
                int endPos = contents.indexOf("%End", cmd.offset);
                Matcher nextSegMatcher = NEXT_SEGMENT_PATTERN.matcher(contents);
                boolean hasNextSeg = nextSegMatcher.find(cmd.offset);
                int nextSegOffset = hasNextSeg ? nextSegMatcher.start() : doc.getLength();
                boolean segClosed = endPos < nextSegOffset;
                cmd.text = "\n" + this.leadingSpace(this.fIndentWidth);
                if (!segClosed) {
                    cmd.text = cmd.text + "\n%End";
                }
                cmd.caretOffset = cmd.offset;
                cmd.shiftsCaret = true;
            } else if (this.startsWithIgnoreLeadingWhitespace(thisLine, "--")) {
                int indent = this.calculateLinePrefixTo(doc, thisLineNum, "-- ");
                cmd.text = "\n" + this.leadingSpace(indent) + "-- ";
            } else if (thisLine.contains("/.")) {
                boolean blockClosed = this.blockOpenAt(cmd.offset, doc.get());
                int indent = this.calculateLinePrefixTo(doc, doc.getLineOfOffset(r.getOffset()), "/.");
                cmd.text = "\n" + this.leadingSpace(indent + 2);
                if (!blockClosed) {
                    cmd.text = cmd.text + "\n" + this.leadingSpace(indent + 1) + "./";
                }
                cmd.caretOffset = cmd.offset;
                cmd.shiftsCaret = true;
            } else if (this.startsWithIgnoreLeadingWhitespace(thisLine, "|")) {
                int indent = this.calculateLeadingWhitespaceAtOffset(doc, thisLineStart);
                int followingOffset = this.skipWhite(indent + 1, thisLine);
                cmd.text = "\n" + this.leadingSpace(indent) + "| " + this.leadingSpace(followingOffset - indent - 2);
            } else {
                int prevNonBlankLineStart = this.findOffsetOfPrevNonBlankLine(doc, thisLineStart);
                int indent = this.calculateLeadingWhitespaceAtOffset(doc, prevNonBlankLineStart);
                cmd.text = "\n" + this.leadingSpace(indent);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private String leadingSpace(int indentAmount) {
        StringBuilder sb = new StringBuilder();
        if (this.fSpacesForTabs) {
            for (int i = 0; i < indentAmount; ++i) {
                sb.append(' ');
            }
        } else {
            int i;
            for (i = 0; i < indentAmount / this.fTabWidth; ++i) {
                sb.append('\t');
            }
            for (i = 0; i < indentAmount % this.fTabWidth; ++i) {
                sb.append(' ');
            }
        }
        return sb.toString();
    }

    private boolean blockOpenAt(int offset, String contents) {
        int nextBlockOpen = contents.indexOf("/.", offset);
        int nextBlockClosed = contents.indexOf("./", offset);
        boolean blockClosed = nextBlockClosed < nextBlockOpen;
        return blockClosed;
    }

    private int findOffsetOfPrevNonBlankLine(IDocument doc, int offset) throws BadLocationException {
        IRegion r;
        String line;
        int lineNum = doc.getLineOfOffset(offset) + 1;
        while ((line = doc.get((r = doc.getLineInformation(--lineNum)).getOffset(), r.getLength())).trim().length() <= 0 && lineNum > 0) {
        }
        return doc.getLineOffset(lineNum);
    }

    private int skipWhite(int idx, String s) {
        while (idx < s.length() && Character.isWhitespace(s.charAt(idx))) {
            ++idx;
        }
        return idx;
    }

    private boolean startsWithIgnoreLeadingWhitespace(String line, String prefix) {
        int afterWhite;
        for (afterWhite = 0; afterWhite < line.length() && Character.isWhitespace(line.charAt(afterWhite)); ++afterWhite) {
        }
        return line.substring(afterWhite).startsWith(prefix);
    }

    private String getLineContaining(int offset, IDocument doc) throws BadLocationException {
        int lineNum = doc.getLineOfOffset(offset);
        return doc.get(doc.getLineOffset(lineNum), doc.getLineLength(lineNum));
    }

    private String getLine(int lineNum, IDocument doc) throws BadLocationException {
        return doc.get(doc.getLineOffset(lineNum), doc.getLineLength(lineNum));
    }

    private void smartIndentOnTab(IDocument doc, DocumentCommand cmd) {
        try {
            int lineNum = doc.getLineOfOffset(cmd.offset);
            IRegion r = doc.getLineInformation(lineNum);
            int lineStart = doc.getLineOffset(lineNum);
            String line = doc.get(r.getOffset(), r.getLength());
            int lineToHereLen = cmd.offset - lineStart;
            this.fIndentWidth = this.fPrefsService.getIntPreference("indentWidth");
            this.fTabWidth = this.fPrefsService.getIntPreference("tabWidth");
            this.fSpacesForTabs = this.fPrefsService.getBooleanPreference("spacesForTabs");
            if (line.substring(0, lineToHereLen).trim().length() == 0 && !Character.isWhitespace(doc.getChar(cmd.offset))) {
                cmd.text = this.leadingSpace(this.fIndentWidth);
            } else {
                int spacesToInsert = 0;
                int lenToReplace = this.calculateLeadingWhitespaceCharsAtOffset(doc, lineStart);
                if (lineNum > 0 && this.isSegmentStart(this.getLine(lineNum - 1, doc))) {
                    int prevLineLeadingWhitespace = this.calculateLeadingWhitespaceOfLine(doc, lineNum - 1);
                    spacesToInsert = prevLineLeadingWhitespace + this.fIndentWidth;
                } else if (lineNum > 0 && this.isBlockStart(this.getLine(lineNum - 1, doc))) {
                    int prevLineBlockStart = this.calculateLinePrefixTo(doc, lineNum - 1, "/.");
                    spacesToInsert = prevLineBlockStart + 2;
                } else if (lineNum > 0 && this.blockOpenAt(cmd.offset, doc.get()) && line.trim().startsWith("./")) {
                    int prevLineLeadingWhitespace = this.calculateLeadingWhitespaceOfLine(doc, lineNum - 1);
                    spacesToInsert = prevLineLeadingWhitespace - 1;
                } else if (lineNum > 0 && this.isNonTermDef(this.getLine(lineNum - 1, doc)) && line.trim().startsWith("|")) {
                    spacesToInsert = this.calculateLinePrefixTo(doc, lineNum - 1, "::=");
                } else if (lineNum > 0 && line.substring(0, lineToHereLen).trim().length() == 0) {
                    int prevNonBlankLineStart = this.findOffsetOfPrevNonBlankLine(doc, lineStart - 1);
                    spacesToInsert = this.calculateLeadingWhitespaceAtOffset(doc, prevNonBlankLineStart);
                }
                if (spacesToInsert != 0) {
                    cmd.offset = lineStart;
                    cmd.length = lenToReplace;
                    cmd.text = this.leadingSpace(spacesToInsert);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean isNonTermDef(String line) {
        return line.contains("::=");
    }

    private boolean isSegmentStart(String line) {
        Pattern SEGMENT_START_PATTERN = Pattern.compile("%[a-zA-Z]+");
        Matcher m = SEGMENT_START_PATTERN.matcher(line.trim());
        return m.matches();
    }

    private boolean isBlockStart(String line) {
        return line.contains("/.");
    }

    private int calculateLinePrefixTo(IDocument doc, int lineNum, String suffix) throws BadLocationException {
        int prefixLen;
        IRegion r = doc.getLineInformation(lineNum);
        String prevLine = doc.get(r.getOffset(), r.getLength());
        int result = prefixLen = prevLine.indexOf(suffix);
        for (int i = 0; i < prefixLen; ++i) {
            if (prevLine.charAt(i) != '\t') continue;
            result += this.fTabWidth - 1;
        }
        return result;
    }

    private int calculateLeadingWhitespaceCharsAtOffset(IDocument doc, int lineStart) throws BadLocationException {
        int chars = 0;
        for (int idx = lineStart; idx < doc.getLength() && Character.isWhitespace(doc.getChar(idx)) && doc.getChar(idx) != '\n'; ++idx) {
            ++chars;
        }
        return chars;
    }

    private int calculateLeadingWhitespaceAtOffset(IDocument doc, int lineStart) throws BadLocationException {
        int white = 0;
        for (int idx = lineStart; idx < doc.getLength() && Character.isWhitespace(doc.getChar(idx)) && doc.getChar(idx) != '\n'; ++idx) {
            if (doc.getChar(idx) == '\t') {
                white += this.fTabWidth;
                continue;
            }
            ++white;
        }
        return white;
    }

    private int calculateLeadingWhitespaceOfLine(IDocument doc, int lineNum) throws BadLocationException {
        if (lineNum < 0) {
            return 0;
        }
        int lineStart = doc.getLineOffset(lineNum);
        return this.calculateLeadingWhitespaceAtOffset(doc, lineStart);
    }

    private boolean isLineDelimiter(IDocument doc, String text) {
        String[] delimiters = doc.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }
}

