/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl;

import org.eclipse.imp.pdb.facts.IString;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringValue
extends Value
implements IString {
    private final String fValue;

    StringValue(String value) {
        super(TypeFactory.getInstance().stringType());
        if (value == null) {
            throw new IllegalArgumentException("Null string value");
        }
        this.fValue = value;
    }

    @Override
    public String getValue() {
        return this.fValue;
    }

    @Override
    public IString concat(IString other) {
        return new StringValue(this.fValue.concat(other.getValue()));
    }

    @Override
    public int compare(IString other) {
        int result = this.fValue.compareTo(other.getValue());
        return result < 0 ? -1 : (result > 0 ? 1 : 0);
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            return ((StringValue)o).fValue.equals(this.fValue);
        }
        return false;
    }

    public int hashCode() {
        return this.fValue.hashCode();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitString(this);
    }
}

