/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.INumber;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedTypeException;
import org.eclipse.imp.pdb.facts.impl.fast.Value;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;

public abstract class AbstractNumberValue
extends Value
implements INumber {
    private static final TypeFactory typeFactory = TypeFactory.getInstance();

    public INumber add(INumber other) {
        Type otherType = other.getType();
        if (otherType.isIntegerType()) {
            return this.add(other.toInteger());
        }
        if (otherType.isRealType()) {
            return this.add(other.toReal());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), otherType);
    }

    public INumber divide(INumber other, int precision) {
        Type otherType = other.getType();
        if (otherType.isIntegerType()) {
            return this.divide(other.toInteger(), precision);
        }
        if (otherType.isRealType()) {
            return this.divide(other.toReal(), precision);
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), otherType);
    }

    public IBool greater(INumber other) {
        Type otherType = other.getType();
        if (otherType.isIntegerType()) {
            return this.greater(other.toInteger());
        }
        if (otherType.isRealType()) {
            return this.greater(other.toReal());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), otherType);
    }

    public IBool greaterEqual(INumber other) {
        Type otherType = other.getType();
        if (otherType.isIntegerType()) {
            return this.greaterEqual(other.toInteger());
        }
        if (otherType.isRealType()) {
            return this.greaterEqual(other.toReal());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), otherType);
    }

    public IBool less(INumber other) {
        Type otherType = other.getType();
        if (otherType.isIntegerType()) {
            return this.less(other.toInteger());
        }
        if (otherType.isRealType()) {
            return this.less(other.toReal());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), otherType);
    }

    public IBool lessEqual(INumber other) {
        Type otherType = other.getType();
        if (otherType.isIntegerType()) {
            return this.lessEqual(other.toInteger());
        }
        if (otherType.isRealType()) {
            return this.lessEqual(other.toReal());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), otherType);
    }

    public INumber multiply(INumber other) {
        Type otherType = other.getType();
        if (otherType.isIntegerType()) {
            return this.multiply(other.toInteger());
        }
        if (otherType.isRealType()) {
            return this.multiply(other.toReal());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), otherType);
    }

    public INumber subtract(INumber other) {
        Type otherType = other.getType();
        if (otherType.isIntegerType()) {
            return this.subtract(other.toInteger());
        }
        if (otherType.isRealType()) {
            return this.subtract(other.toReal());
        }
        throw new UnexpectedTypeException(typeFactory.numberType(), otherType);
    }
}

