/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Iterator;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.RelationWriter;
import org.eclipse.imp.pdb.facts.impl.fast.SetWriter;
import org.eclipse.imp.pdb.facts.impl.fast.Tuple;
import org.eclipse.imp.pdb.facts.impl.fast.Value;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesHashSet;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Set
extends Value
implements ISet {
    protected static final TypeFactory typeFactory = TypeFactory.getInstance();
    protected static final Type voidType = typeFactory.voidType();
    protected final Type setType;
    protected final Type elementType;
    protected final ShareableValuesHashSet data;

    protected Set(Type elementType, ShareableValuesHashSet data) {
        this.setType = typeFactory.setType(elementType);
        this.elementType = elementType;
        this.data = data;
    }

    protected Set(Type subTypeOfSet, Type elementType, ShareableValuesHashSet data) {
        this.setType = subTypeOfSet;
        this.elementType = elementType;
        this.data = data;
    }

    @Override
    public Type getType() {
        return this.setType;
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.data.iterator();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitSet(this);
    }

    @Override
    public boolean contains(IValue element) {
        return this.data.contains(element);
    }

    @Override
    public boolean isSubsetOf(ISet other) {
        Set otherSet = (Set)other;
        Iterator<IValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (otherSet.data.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public ISet insert(IValue value) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        newData.add(value);
        Type type = this.elementType.lub(value.getType());
        return Set.createSetWriter(type, newData).done();
    }

    public ISet delete(IValue value) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        newData.remove(value);
        return Set.createSetWriter(this.elementType, newData).done();
    }

    public ISet intersect(ISet other) {
        ISet theOtherSet;
        Iterator<Object> setIterator;
        ShareableValuesHashSet commonData = new ShareableValuesHashSet();
        if (other.size() <= this.size()) {
            setIterator = other.iterator();
            theOtherSet = this;
        } else {
            setIterator = this.iterator();
            theOtherSet = other;
        }
        while (setIterator.hasNext()) {
            IValue value = (IValue)setIterator.next();
            if (!theOtherSet.contains(value)) continue;
            commonData.add(value);
        }
        Type type = this.elementType.lub(other.getElementType());
        return Set.createSetWriter(type, commonData).done();
    }

    public ISet subtract(ISet other) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        Iterator setIterator = other.iterator();
        while (setIterator.hasNext()) {
            newData.remove(setIterator.next());
        }
        return Set.createSetWriter(this.elementType, newData).done();
    }

    public ISet union(ISet other) {
        Iterator<IValue> setIterator;
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        Set otherSet = (Set)other;
        if (otherSet.size() <= this.size()) {
            newData = new ShareableValuesHashSet(this.data);
            setIterator = otherSet.iterator();
        } else {
            newData = new ShareableValuesHashSet(otherSet.data);
            setIterator = this.iterator();
        }
        while (setIterator.hasNext()) {
            newData.add(setIterator.next());
        }
        Type newElementType = this.elementType.lub(otherSet.elementType);
        return Set.createSetWriter(newElementType, newData).done();
    }

    @Override
    public IRelation product(ISet other) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        Type tupleType = typeFactory.tupleType(this.elementType, other.getElementType());
        for (IValue left : this.data) {
            for (IValue right : other) {
                IValue[] tuple = new IValue[]{left, right};
                newData.add(new Tuple(tupleType, tuple));
            }
        }
        return new RelationWriter(tupleType, newData).done();
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            Set otherSet = (Set)o;
            if (this.setType != otherSet.setType) {
                return false;
            }
            return this.data.equals(otherSet.data);
        }
        return false;
    }

    @Override
    public boolean isEqual(IValue value) {
        if (value == this) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Set) {
            Set otherSet = (Set)value;
            if (!this.elementType.comparable(otherSet.elementType)) {
                return false;
            }
            return this.data.isEqual(otherSet.data);
        }
        return false;
    }

    protected static ISetWriter createSetWriter(Type elementType, ShareableValuesHashSet data) {
        if (elementType.isTupleType()) {
            return new RelationWriter(elementType, data);
        }
        return new SetWriter(elementType, data);
    }
}

