/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.io;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IExternalValue;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.IString;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.UnsupportedTypeException;
import org.eclipse.imp.pdb.facts.io.IValueWriter;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLWriter
implements IValueWriter {
    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private DocumentBuilder fBuilder;

    public void write(IValue value, OutputStream stream) throws IOException {
        try {
            this.fBuilder = this.dbf.newDocumentBuilder();
            Document doc = this.fBuilder.newDocument();
            Node top = this.yield(value, doc);
            doc.appendChild(top);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(doc), new StreamResult(stream));
        }
        catch (ParserConfigurationException e) {
            throw new IOException("XML configuration is invalid: " + e.getMessage());
        }
        catch (TransformerException e) {
            throw new IOException("Exception while serializing XML: " + e.getMessage());
        }
    }

    public void write(IValue value, OutputStream stream, TypeStore typeStore) throws IOException {
        this.write(value, stream);
    }

    private Node yield(IValue value, Document doc) {
        Type type = value.getType();
        if (type.isAbstractDataType()) {
            Type node = ((IConstructor)value).getConstructorType();
            if (this.isListWrapper(node)) {
                return this.yieldList((INode)value, doc);
            }
            if (this.isSetWrapper(node)) {
                return this.yieldSet((INode)value, doc);
            }
            if (this.isRelationWrapper(node)) {
                return this.yieldRelation((INode)value, doc);
            }
            if (this.isMapWrapper(node)) {
                return this.yieldMap((INode)value, doc);
            }
            return this.yieldTree((INode)value, doc);
        }
        if (type.isStringType()) {
            return this.yieldString((IString)value, doc);
        }
        if (type.isIntegerType()) {
            return this.yieldInt((IInteger)value, doc);
        }
        if (type.isRealType()) {
            return this.yieldDouble((IReal)value, doc);
        }
        if (type.isExternalType()) {
            return this.yieldExternal((IExternalValue)value, doc);
        }
        throw new UnsupportedTypeException("Outermost or nested tuples, lists, sets, relations or maps are not allowed.", type);
    }

    private boolean isListWrapper(Type nodeType) {
        return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isListType();
    }

    private boolean isSetWrapper(Type nodeType) {
        return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isSetType();
    }

    private boolean isRelationWrapper(Type nodeType) {
        return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isRelationType();
    }

    private boolean isMapWrapper(Type nodeType) {
        return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isMapType();
    }

    private Node yieldDouble(IReal value, Document doc) {
        return doc.createTextNode(value.toString());
    }

    private Node yieldInt(IInteger value, Document doc) {
        return doc.createTextNode(value.toString());
    }

    private Node yieldString(IString value, Document doc) {
        return doc.createTextNode(value.getValue());
    }

    private Node yieldExternal(IExternalValue value, Document doc) {
        return doc.createTextNode(value.toString());
    }

    private Node yieldMap(INode node, Document doc) {
        Element treeNode = doc.createElement(node.getName());
        IMap map = (IMap)node.get(0);
        for (IValue key : map) {
            IValue value = map.get(key);
            if (key.getType().isTupleType()) {
                this.appendTupleElements(doc, treeNode, key);
            } else {
                treeNode.appendChild(this.yield(key, doc));
            }
            if (value.getType().isTupleType()) {
                this.appendTupleElements(doc, treeNode, value);
                continue;
            }
            treeNode.appendChild(this.yield(value, doc));
        }
        return treeNode;
    }

    private void appendTupleElements(Document doc, Element treeNode, IValue tupleValue) {
        ITuple tuple = (ITuple)tupleValue;
        for (IValue element : tuple) {
            treeNode.appendChild(this.yield(element, doc));
        }
    }

    private Node yieldRelation(INode node, Document doc) {
        Element treeNode = doc.createElement(node.getName());
        IRelation relation = (IRelation)node.get(0);
        for (IValue tuple : relation) {
            this.appendTupleElements(doc, treeNode, tuple);
        }
        return treeNode;
    }

    private Node yieldSet(INode node, Document doc) {
        Element treeNode = doc.createElement(node.getName());
        ISet set = (ISet)node.get(0);
        for (IValue elem : set) {
            if (elem.getType().isTupleType()) {
                this.appendTupleElements(doc, treeNode, elem);
                continue;
            }
            treeNode.appendChild(this.yield(elem, doc));
        }
        return treeNode;
    }

    private Node yieldList(INode node, Document doc) {
        Element treeNode = doc.createElement(node.getName());
        IList list = (IList)node.get(0);
        for (IValue elem : list) {
            if (elem.getType().isTupleType()) {
                this.appendTupleElements(doc, treeNode, elem);
                continue;
            }
            treeNode.appendChild(this.yield(elem, doc));
        }
        return treeNode;
    }

    private Node yieldTree(INode value, Document doc) {
        Element treeNode = doc.createElement(value.getName());
        for (IValue child : value) {
            if (child.getType().isTupleType()) {
                this.appendTupleElements(doc, treeNode, child);
                continue;
            }
            treeNode.appendChild(this.yield(child, doc));
        }
        return treeNode;
    }
}

