/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.IWriter;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AliasType
extends Type {
    private final String fName;
    private final Type fAliased;
    private final Type fParameters;

    AliasType(String name, Type aliased) {
        this.fName = name;
        this.fAliased = aliased;
        this.fParameters = TypeFactory.getInstance().voidType();
    }

    AliasType(String name, Type aliased, Type parameters) {
        this.fName = name;
        this.fAliased = aliased;
        this.fParameters = parameters;
    }

    @Override
    public boolean isAliasType() {
        return true;
    }

    @Override
    public boolean isParameterized() {
        return !this.fParameters.isVoidType();
    }

    @Override
    public Type getTypeParameters() {
        return this.fParameters;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Type getAliased() {
        return this.fAliased;
    }

    @Override
    public Type getHiddenType() {
        return this.fAliased;
    }

    @Override
    public boolean isSubtypeOf(Type other) {
        if (other == this) {
            return true;
        }
        if (other.isAliasType() && other.getName().equals(this.getName())) {
            return this.fAliased.isSubtypeOf(other) && this.fParameters.isSubtypeOf(other.getTypeParameters());
        }
        return this.fAliased.isSubtypeOf(other);
    }

    @Override
    public Type lub(Type other) {
        if (other == this) {
            return this;
        }
        if (other.isAliasType() && other.getName().equals(this.getName())) {
            Type aliased = this.fAliased.lub(other.getAliased());
            Type params = this.fParameters.lub(other.getTypeParameters());
            return TypeFactory.getInstance().aliasTypeFromTuple(new TypeStore(new TypeStore[0]), this.getName(), aliased, params);
        }
        return this.fAliased.lub(other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fName);
        if (!this.fParameters.isVoidType()) {
            sb.append("[");
            int idx = 0;
            for (Type elemType : this.fParameters) {
                if (idx++ > 0) {
                    sb.append(",");
                }
                sb.append(elemType.toString());
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public int hashCode() {
        return 49991 + 49831 * this.fName.hashCode() + 67349 * this.fAliased.hashCode() + 1433 * this.fParameters.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AliasType) {
            AliasType other = (AliasType)o;
            return this.fName.equals(other.fName) && this.fAliased == other.fAliased && this.fParameters == other.fParameters;
        }
        return false;
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitAlias(this);
    }

    @Override
    public IInteger make(IValueFactory f, int arg) {
        return (IInteger)this.fAliased.make(f, arg);
    }

    @Override
    public IValue make(IValueFactory f) {
        return this.fAliased.make(f);
    }

    @Override
    public IValue make(IValueFactory f, IValue ... children) {
        return this.fAliased.make(f, children);
    }

    @Override
    public IValue make(IValueFactory f, URI url, int startOffset, int length, int startLine, int endLine, int startCol, int endCol) {
        return this.fAliased.make(f, url, startOffset, length, startLine, endLine, startCol, endCol);
    }

    @Override
    public IValue make(IValueFactory f, String path, int startOffset, int length, int startLine, int endLine, int startCol, int endCol) {
        return f.sourceLocation(path, startOffset, length, startLine, endLine, startCol, endCol);
    }

    @Override
    public IValue make(IValueFactory f, URI uri) {
        return f.sourceLocation(uri);
    }

    @Override
    public IValue make(IValueFactory f, double arg) {
        return this.fAliased.make(f, arg);
    }

    @Override
    public IValue make(IValueFactory f, String arg) {
        return this.fAliased.make(f, arg);
    }

    @Override
    public <T extends IWriter> T writer(IValueFactory f) {
        return this.fAliased.writer(f);
    }

    @Override
    public int getArity() {
        return this.fAliased.getArity();
    }

    @Override
    public Type getBound() {
        return this.fAliased.getBound();
    }

    @Override
    public Type getElementType() {
        return this.fAliased.getElementType();
    }

    @Override
    public int getFieldIndex(String fieldName) {
        return this.fAliased.getFieldIndex(fieldName);
    }

    @Override
    public String getFieldName(int i) {
        return this.fAliased.getFieldName(i);
    }

    @Override
    public String getKeyLabel() {
        return this.fAliased.getKeyLabel();
    }

    @Override
    public String getValueLabel() {
        return this.fAliased.getValueLabel();
    }

    @Override
    public Type getFieldType(int i) {
        return this.fAliased.getFieldType(i);
    }

    @Override
    public Type getFieldType(String fieldName) {
        return this.fAliased.getFieldType(fieldName);
    }

    @Override
    public Type getFieldTypes() {
        return this.fAliased.getFieldTypes();
    }

    @Override
    public Type getKeyType() {
        return this.fAliased.getKeyType();
    }

    @Override
    public Type getValueType() {
        return this.fAliased.getValueType();
    }

    @Override
    public boolean comparable(Type other) {
        return this.fAliased.comparable(other);
    }

    @Override
    public Type compose(Type other) {
        return this.fAliased.compose(other);
    }

    @Override
    public boolean hasFieldNames() {
        return this.fAliased.hasFieldNames();
    }

    @Override
    public Type instantiate(TypeStore store, Map<Type, Type> bindings) {
        Type[] params = new Type[]{};
        if (this.isParameterized()) {
            params = new Type[this.fParameters.getArity()];
            int i = 0;
            for (Type p : this.fParameters) {
                params[i++] = p.instantiate(store, bindings);
            }
        }
        return TypeFactory.getInstance().aliasType(store, this.fName, this.fAliased.instantiate(store, bindings), params);
    }

    @Override
    public void match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        super.match(matched, bindings);
        this.fAliased.match(matched, bindings);
    }

    @Override
    public boolean isBoolType() {
        return this.fAliased.isBoolType();
    }

    @Override
    public boolean isRealType() {
        return this.fAliased.isRealType();
    }

    @Override
    public boolean isIntegerType() {
        return this.fAliased.isIntegerType();
    }

    @Override
    public boolean isListType() {
        return this.fAliased.isListType();
    }

    @Override
    public boolean isMapType() {
        return this.fAliased.isMapType();
    }

    @Override
    public boolean isAbstractDataType() {
        return this.fAliased.isAbstractDataType();
    }

    @Override
    public boolean isParameterType() {
        return this.fAliased.isParameterType();
    }

    @Override
    public boolean isRelationType() {
        return this.fAliased.isRelationType();
    }

    @Override
    public boolean isSetType() {
        return this.fAliased.isSetType();
    }

    @Override
    public boolean isSourceLocationType() {
        return this.fAliased.isSourceLocationType();
    }

    @Override
    public boolean isSourceRangeType() {
        return this.fAliased.isSourceRangeType();
    }

    @Override
    public boolean isStringType() {
        return this.fAliased.isStringType();
    }

    @Override
    public boolean isConstructorType() {
        return this.fAliased.isConstructorType();
    }

    @Override
    public boolean isNodeType() {
        return this.fAliased.isNodeType();
    }

    @Override
    public boolean isTupleType() {
        return this.fAliased.isTupleType();
    }

    @Override
    public boolean isValueType() {
        return this.fAliased.isValueType();
    }

    @Override
    public boolean isVoidType() {
        return this.fAliased.isVoidType();
    }

    @Override
    public boolean isExternalType() {
        return this.fAliased.isExternalType();
    }

    @Override
    public Iterator<Type> iterator() {
        return this.fAliased.iterator();
    }

    @Override
    public IValue make(IValueFactory f, boolean arg) {
        return this.fAliased.make(f, arg);
    }

    @Override
    public IValue make(IValueFactory f, TypeStore store, boolean arg) {
        return this.fAliased.make(f, store, arg);
    }

    @Override
    public IValue make(IValueFactory f, TypeStore store, double arg) {
        return this.fAliased.make(f, store, arg);
    }

    @Override
    public IValue make(IValueFactory f, TypeStore store, int arg) {
        return this.fAliased.make(f, store, arg);
    }

    @Override
    public IValue make(IValueFactory f, TypeStore store, String arg) {
        return this.fAliased.make(f, store, arg);
    }

    @Override
    public IValue make(IValueFactory f, TypeStore store, String name, IValue ... children) {
        return this.fAliased.make(f, store, name, children);
    }

    @Override
    public Type select(int ... fields) {
        return this.fAliased.select(fields);
    }

    @Override
    public Type select(String ... names) {
        return this.fAliased.select(names);
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fAliased.hasField(fieldName);
    }

    @Override
    public boolean hasField(String fieldName, TypeStore store) {
        return this.fAliased.hasField(fieldName, store);
    }
}

