/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShareableHashSet<V>
implements Set<V>,
Iterable<V> {
    private static final int INITIAL_LOG_SIZE = 4;
    private int modSize;
    private int hashMask;
    private Entry<V>[] data;
    private int threshold;
    private int load;
    private int currentHashCode;

    public ShareableHashSet() {
        this.modSize = 4;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
        this.currentHashCode = 0;
    }

    public ShareableHashSet(ShareableHashSet<V> sharedHashSet) {
        this.modSize = sharedHashSet.modSize;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = (Entry[])sharedHashSet.data.clone();
        this.threshold = tableSize;
        this.load = sharedHashSet.load;
        this.currentHashCode = sharedHashSet.currentHashCode;
    }

    @Override
    public void clear() {
        this.modSize = 4;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
        this.currentHashCode = 0;
    }

    private void rehash() {
        ++this.modSize;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        Entry[] newData = new Entry[tableSize];
        this.threshold = tableSize;
        Entry<V>[] oldData = this.data;
        for (int i = oldData.length - 1; i >= 0; --i) {
            Entry<V> entry = oldData[i];
            if (entry == null) continue;
            Entry<V> lastUnchangedEntryChain = entry;
            int newLastUnchangedEntryChainIndex = entry.hash & this.hashMask;
            Entry e = entry.next;
            while (e != null) {
                int newIndex = e.hash & this.hashMask;
                if (newIndex != newLastUnchangedEntryChainIndex) {
                    lastUnchangedEntryChain = e;
                    newLastUnchangedEntryChainIndex = newIndex;
                }
                e = e.next;
            }
            newData[newLastUnchangedEntryChainIndex] = lastUnchangedEntryChain;
            while (entry != lastUnchangedEntryChain) {
                int hash = entry.hash;
                int position = hash & this.hashMask;
                newData[position] = new Entry(hash, entry.value, newData[position]);
                entry = entry.next;
            }
        }
        this.data = newData;
    }

    private void ensureCapacity() {
        if (this.load > this.threshold) {
            this.rehash();
        }
    }

    @Override
    public boolean add(V value) {
        this.ensureCapacity();
        int hash = value.hashCode();
        int position = hash & this.hashMask;
        Entry<V> currentStartEntry = this.data[position];
        if (currentStartEntry != null) {
            Entry<V> entry = currentStartEntry;
            do {
                if (hash != entry.hash || !entry.value.equals(value)) continue;
                return false;
            } while ((entry = entry.next) != null);
        }
        this.data[position] = new Entry<V>(hash, value, currentStartEntry);
        ++this.load;
        this.currentHashCode ^= hash;
        return true;
    }

    @Override
    public boolean contains(Object value) {
        int hash = value.hashCode();
        int position = hash & this.hashMask;
        Entry<V> entry = this.data[position];
        while (entry != null) {
            if (hash == entry.hash && value.equals(entry.value)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public boolean remove(Object value) {
        int hash = value.hashCode();
        int position = hash & this.hashMask;
        Entry<V> currentStartEntry = this.data[position];
        if (currentStartEntry != null) {
            Entry<V> entry = currentStartEntry;
            do {
                if (hash != entry.hash || !entry.value.equals(value)) continue;
                Entry<V> e = this.data[position];
                this.data[position] = entry.next;
                while (e != entry) {
                    this.data[position] = new Entry(e.hash, e.value, this.data[position]);
                    e = e.next;
                }
                --this.load;
                this.currentHashCode ^= hash;
                return true;
            } while ((entry = entry.next) != null);
        }
        return false;
    }

    @Override
    public int size() {
        return this.load;
    }

    @Override
    public boolean isEmpty() {
        return this.load == 0;
    }

    @Override
    public Iterator<V> iterator() {
        return new SetIterator(this);
    }

    @Override
    public boolean addAll(Collection<? extends V> collection) {
        boolean changed = false;
        Iterator<V> collectionIterator = collection.iterator();
        while (collectionIterator.hasNext()) {
            changed |= this.add(collectionIterator.next());
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> collectionIterator = collection.iterator();
        while (collectionIterator.hasNext()) {
            if (this.contains(collectionIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        for (V value : this) {
            if (collection.contains(value)) continue;
            this.remove(value);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object value : collection) {
            changed |= this.remove(value);
        }
        return changed;
    }

    @Override
    public Object[] toArray() {
        Object[] values = new Object[this.load];
        Iterator<V> valuesIterator = this.iterator();
        int i = 0;
        while (valuesIterator.hasNext()) {
            values[i++] = valuesIterator.next();
        }
        return values;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.load) {
            return this.toArray();
        }
        Iterator<V> valuesIterator = this.iterator();
        int i = 0;
        while (valuesIterator.hasNext()) {
            array[i++] = valuesIterator.next();
        }
        while (i < this.load) {
            array[i] = null;
            ++i;
        }
        return array;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (int i = 0; i < this.data.length; ++i) {
            buffer.append('[');
            Entry<V> e = this.data[i];
            if (e != null) {
                buffer.append(e);
                e = e.next;
                while (e != null) {
                    buffer.append(',');
                    buffer.append(e);
                    e = e.next;
                }
            }
            buffer.append(']');
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        return this.currentHashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            ShareableHashSet other = (ShareableHashSet)o;
            if (other.currentHashCode != this.currentHashCode) {
                return false;
            }
            if (other.size() != this.size()) {
                return false;
            }
            if (this.isEmpty()) {
                return true;
            }
            Iterator<V> otherIterator = other.iterator();
            while (otherIterator.hasNext()) {
                if (this.contains(otherIterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetIterator<V>
    implements Iterator<V> {
        private final Entry<V>[] data;
        private Entry<V> current;
        private int index;

        public SetIterator(ShareableHashSet<V> sharedHashSet) {
            this.data = ((ShareableHashSet)sharedHashSet).data;
            this.index = this.data.length - 1;
            this.current = new Entry<Object>(0, null, this.data[this.index]);
            this.locateNext();
        }

        private void locateNext() {
            Entry next = this.current.next;
            if (next != null) {
                this.current = next;
                return;
            }
            for (int i = this.index - 1; i >= 0; --i) {
                Entry<V> entry = this.data[i];
                if (entry == null) continue;
                this.current = entry;
                this.index = i;
                return;
            }
            this.current = null;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more elements in this iteration");
            }
            Object value = this.current.value;
            this.locateNext();
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<V> {
        public final int hash;
        public final V value;
        public final Entry<V> next;

        public Entry(int hash, V value, Entry<V> next) {
            this.hash = hash;
            this.value = value;
            this.next = next;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('<');
            buffer.append(this.value);
            buffer.append('>');
            return buffer.toString();
        }
    }
}

