/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.xform.pattern.matching;

import org.eclipse.imp.services.IASTAdapter;
import org.eclipse.imp.services.IASTMatchAdapter;
import org.eclipse.imp.xform.pattern.matching.MatchResult;
import org.eclipse.imp.xform.pattern.parser.ASTPatternParser;
import org.eclipse.imp.xform.pattern.parser.Ast.ActualArgList_ActualArgList;
import org.eclipse.imp.xform.pattern.parser.Ast.BoundConstraint;
import org.eclipse.imp.xform.pattern.parser.Ast.Child;
import org.eclipse.imp.xform.pattern.parser.Ast.ChildList_ChildList;
import org.eclipse.imp.xform.pattern.parser.Ast.ConstraintList_ConstraintList;
import org.eclipse.imp.xform.pattern.parser.Ast.Equals;
import org.eclipse.imp.xform.pattern.parser.Ast.FormalArgList;
import org.eclipse.imp.xform.pattern.parser.Ast.FunctionCall;
import org.eclipse.imp.xform.pattern.parser.Ast.FunctionDef;
import org.eclipse.imp.xform.pattern.parser.Ast.IConstraint;
import org.eclipse.imp.xform.pattern.parser.Ast.INode;
import org.eclipse.imp.xform.pattern.parser.Ast.IOperator;
import org.eclipse.imp.xform.pattern.parser.Ast.IPattern;
import org.eclipse.imp.xform.pattern.parser.Ast.Node;
import org.eclipse.imp.xform.pattern.parser.Ast.NodeType;
import org.eclipse.imp.xform.pattern.parser.Ast.NotEquals;
import org.eclipse.imp.xform.pattern.parser.Ast.OperatorConstraint;
import org.eclipse.imp.xform.pattern.parser.Ast.Pattern;
import org.eclipse.imp.xform.pattern.parser.Ast.PatternNodeToken;
import org.eclipse.imp.xform.pattern.parser.Ast.ScopeBlock;
import org.eclipse.imp.xform.pattern.parser.Ast.optConstraintList;
import org.eclipse.imp.xform.pattern.parser.Ast.optTargetType;

public class Matcher {
    private Pattern fPattern;
    private final IASTAdapter fASTAdapter = ASTPatternParser.getASTAdapter();
    private final ASTPatternParser.SymbolTable fSymbolTable = ASTPatternParser.getSymbolTable();

    public Matcher(Pattern p) {
        this.fPattern = p;
    }

    public MatchResult match(Object ast) {
        if (this.fPattern == null) {
            return null;
        }
        try {
            MatchResult m = new MatchResult(ast);
            if (this.doMatch(this.fPattern.getNode(), ast, m)) {
                return m;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean doMatch(IPattern pattern, Object astNode, MatchResult match) throws Exception {
        INode node = null;
        ScopeBlock block = null;
        if (pattern instanceof Pattern) {
            Pattern p = (Pattern)pattern;
            block = p.getScopeBlock();
            node = p.getNode();
        } else if (pattern instanceof FunctionCall || pattern instanceof Node) {
            node = (INode)pattern;
        }
        if (node instanceof FunctionCall) {
            FunctionCall call = (FunctionCall)node;
            PatternNodeToken name = call.getIDENT();
            FunctionDef def = this.fSymbolTable.lookup(name.toString());
            ActualArgList_ActualArgList actuals = call.getActualArgList();
            FormalArgList formals = def.getFormalArgList();
            if (actuals.size() != formals.size()) {
                throw new IllegalArgumentException("Wrong # of arguments " + actuals.size() + " to pattern function " + name + " (expected " + formals.size() + ").");
            }
            IPattern body = def.getBody();
        } else if (node instanceof Node) {
            Node patternNode = (Node)node;
            NodeType patNodeASTType = patternNode.gettype();
            optTargetType patNodeTargetType = patternNode.gettargetType();
            String typeName = patNodeASTType.getIDENT().toString();
            if (patNodeASTType != null && !this.fASTAdapter.isInstanceOfType(astNode, typeName)) {
                return false;
            }
            if (patNodeTargetType != null && !patNodeTargetType.getIDENT().toString().equals(this.fASTAdapter.getValue("targetType", astNode))) {
                return false;
            }
            if (!this.checkConstraints(patternNode, astNode)) {
                return false;
            }
            ChildList_ChildList patChildren = patternNode.getChildList();
            if (patChildren.size() > 0) {
                Object[] astChildren = this.fASTAdapter.getChildren(astNode);
                for (int i = 0; i < patChildren.size(); ++i) {
                    int j;
                    Child patChild = patChildren.getChildAt(i);
                    for (j = 0; j < astChildren.length && !this.doMatch(patChild.getNode(), astChildren[j], match); ++j) {
                    }
                    if (j != astChildren.length) continue;
                    return false;
                }
            }
            if (patternNode.getname() != null) {
                match.addBinding(patternNode.getname().getIDENT().toString(), astNode);
            }
        }
        match.fMatchNode = astNode;
        return true;
    }

    private boolean checkConstraints(Node patternNode, Object astNode) throws Exception {
        optConstraintList optConstraints = patternNode.getconstraints();
        if (optConstraints != null) {
            ConstraintList_ConstraintList constraints = optConstraints.getConstraintList();
            for (int i = 0; i < constraints.size(); ++i) {
                IConstraint constraint = constraints.getConstraintAt(i);
                if (constraint instanceof OperatorConstraint) {
                    OperatorConstraint cons = (OperatorConstraint)constraint;
                    IOperator op = cons.getOperator();
                    if (op instanceof Equals) {
                        if (((Equals)op).evaluate(cons.getlhs(), cons.getrhs(), astNode)) continue;
                        return false;
                    }
                    if (op instanceof NotEquals) {
                        if (((NotEquals)op).evaluate(cons.getlhs(), cons.getrhs(), astNode)) continue;
                        return false;
                    }
                    throw new Exception("Unable to evaluate operator: " + op.toString());
                }
                if (!(constraint instanceof BoundConstraint)) continue;
            }
        }
        return true;
    }

    public String toString() {
        return "<matcher: " + this.fPattern + ">";
    }

    public IASTMatchAdapter getAdapter() {
        return this.fASTAdapter;
    }
}

