/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.xform.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.imp.xform.XformPlugin;
import org.eclipse.imp.xform.search.ASTSearchContentProvider;
import org.eclipse.imp.xform.search.ASTSearchTableContentProvider;
import org.eclipse.imp.xform.search.ASTSearchTreeContentProvider;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ASTSearchResultPage
extends AbstractTextSearchViewPage {
    private static final Image sSearchHitImage = XformPlugin.getImageDescriptor("icons/astSearchHit.gif").createImage();
    private ASTSearchContentProvider fContentProvider;

    public ASTSearchResultPage(int supportedLayouts) {
        super(supportedLayouts);
    }

    public ASTSearchResultPage() {
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)new ASTLabelProvider());
        this.fContentProvider = new ASTSearchTreeContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)new ASTLabelProvider());
        this.fContentProvider = new ASTSearchTableContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
    }

    protected StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)match.getElement()));
        editorPart.getEditorSite().getSelectionProvider().setSelection((ISelection)new TextSelection(match.getOffset(), match.getLength()));
    }

    private final class ASTLabelProvider
    implements ILabelProvider {
        private ASTLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return sSearchHitImage;
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                return "Matches in '" + file.getFullPath() + "'";
            }
            if (element instanceof Match) {
                Match m = (Match)element;
                return "match at " + m.getOffset() + ":" + m.getLength();
            }
            return "???";
        }
    }
}

