/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.List;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IAutoEditStrategy;
import org.eclipse.imp.services.ILanguageSyntaxProperties;
import org.eclipse.imp.services.base.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class StructuredSourceViewer
extends ProjectionViewer {
    public static final int SHOW_OUTLINE = 51;
    public static final int OPEN_STRUCTURE = 52;
    public static final int SHOW_HIERARCHY = 53;
    public static final int TOGGLE_COMMENT = 54;
    public static final int MARK_OCCURRENCES = 55;
    public static final int INDENT_SELECTION = 60;
    private IInformationPresenter fOutlinePresenter;
    private IInformationPresenter fStructurePresenter;
    private IInformationPresenter fHierarchyPresenter;
    private IAutoEditStrategy fAutoEditStrategy;
    private IParseController fParseController;
    private boolean fIsConfigured;

    public StructuredSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
    }

    public boolean canDoOperation(int operation) {
        switch (operation) {
            case 51: {
                return this.fOutlinePresenter != null;
            }
            case 52: {
                return this.fStructurePresenter != null;
            }
            case 53: {
                return this.fHierarchyPresenter != null;
            }
            case 54: {
                return true;
            }
            case 60: {
                return this.fAutoEditStrategy != null;
            }
        }
        return super.canDoOperation(operation);
    }

    public void doOperation(int operation) {
        if (this.getTextWidget() == null) {
            return;
        }
        switch (operation) {
            case 51: {
                if (this.fOutlinePresenter != null) {
                    this.fOutlinePresenter.showInformation();
                }
                return;
            }
            case 52: {
                if (this.fStructurePresenter != null) {
                    this.fStructurePresenter.showInformation();
                }
                return;
            }
            case 53: {
                if (this.fHierarchyPresenter != null) {
                    this.fHierarchyPresenter.showInformation();
                }
                return;
            }
            case 54: {
                this.doToggleComment();
                return;
            }
            case 60: {
                this.doIndentLines();
                return;
            }
        }
        super.doOperation(operation);
    }

    public void setParseController(IParseController parseController) {
        this.fParseController = parseController;
    }

    public void setFormatter(IContentFormatter formatter) {
        this.fContentFormatter = formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doToggleComment() {
        ILanguageSyntaxProperties syntaxProps = this.fParseController.getSyntaxProperties();
        if (syntaxProps == null) {
            return;
        }
        IDocument doc = this.getDocument();
        DocumentRewriteSession rewriteSession = null;
        Point p = this.getSelectedRange();
        String lineCommentStart = syntaxProps.getSingleLineCommentPrefix();
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)doc;
            rewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        }
        try {
            int selStart = p.x;
            int selLen = p.y;
            int selEnd = selStart + selLen;
            int startLine = doc.getLineOfOffset(selStart);
            int endLine = doc.getLineOfOffset(selEnd);
            if (selLen > 0 && doc.getChar(selEnd - 1) == '\n') {
                --endLine;
            }
            for (int line = startLine; line <= endLine; ++line) {
                int lineStartOffset;
                int offset;
                for (offset = lineStartOffset = doc.getLineOffset(line); Character.isWhitespace(doc.getChar(offset)) && offset < doc.getLength(); ++offset) {
                }
                if (doc.get(offset, lineCommentStart.length()).equals(lineCommentStart)) {
                    int len = lineCommentStart.length();
                    while (Character.isWhitespace(doc.getChar(offset + len))) {
                        ++len;
                    }
                    doc.replace(offset, len, "");
                    continue;
                }
                doc.replace(offset, 0, lineCommentStart + " ");
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        finally {
            if (doc instanceof IDocumentExtension4) {
                IDocumentExtension4 extension = (IDocumentExtension4)doc;
                extension.stopRewriteSession(rewriteSession);
            }
            this.restoreSelection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIndentLines() {
        IDocument doc = this.getDocument();
        DocumentRewriteSession rewriteSession = null;
        Point p = this.getSelectedRange();
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)doc;
            rewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        }
        try {
            int selStart = p.x;
            int selLen = p.y;
            int selEnd = selStart + selLen;
            int startLine = doc.getLineOfOffset(selStart);
            int endLine = doc.getLineOfOffset(selEnd);
            if (selLen > 0 && doc.getChar(selEnd - 1) == '\n') {
                --endLine;
            }
            for (int line = startLine; line <= endLine; ++line) {
                int lineStartOffset;
                int offset = lineStartOffset = doc.getLineOffset(line);
                DocumentCommand cmd = new DocumentCommand(){};
                cmd.offset = lineStartOffset;
                cmd.length = 1;
                cmd.text = Character.toString('\t');
                cmd.doit = true;
                cmd.shiftsCaret = false;
                this.fAutoEditStrategy.customizeDocumentCommand(doc, cmd);
                doc.replace(cmd.offset, cmd.length, cmd.text);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        finally {
            if (doc instanceof IDocumentExtension4) {
                IDocumentExtension4 extension = (IDocumentExtension4)doc;
                extension.stopRewriteSession(rewriteSession);
            }
            this.restoreSelection();
        }
    }

    public void configure(SourceViewerConfiguration configuration) {
        StyledText textWidget = this.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            Color backgroundColor;
            Color foregroundColor = textWidget.getForeground();
            if (foregroundColor != null && foregroundColor.isDisposed()) {
                textWidget.setForeground(null);
            }
            if ((backgroundColor = textWidget.getBackground()) != null && backgroundColor.isDisposed()) {
                textWidget.setBackground(null);
            }
        }
        super.configure(configuration);
        if (configuration instanceof UniversalEditor.StructuredSourceViewerConfiguration) {
            List strategies;
            UniversalEditor.StructuredSourceViewerConfiguration sSVConfiguration = (UniversalEditor.StructuredSourceViewerConfiguration)configuration;
            this.fOutlinePresenter = sSVConfiguration.getOutlinePresenter((ISourceViewer)this);
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.install((ITextViewer)this);
            }
            this.fStructurePresenter = sSVConfiguration.getOutlinePresenter((ISourceViewer)this);
            if (this.fStructurePresenter != null) {
                this.fStructurePresenter.install((ITextViewer)this);
            }
            this.fHierarchyPresenter = sSVConfiguration.getHierarchyPresenter((ISourceViewer)this, true);
            if (this.fHierarchyPresenter != null) {
                this.fHierarchyPresenter.install((ITextViewer)this);
            }
            if (this.fAutoIndentStrategies != null && (strategies = (List)this.fAutoIndentStrategies.get("__dftl_partition_content_type")) != null && strategies.size() > 0) {
                this.fAutoEditStrategy = strategies.get(0) instanceof IAutoEditStrategy ? (IAutoEditStrategy)strategies.get(0) : new DefaultAutoIndentStrategy();
            }
        }
        this.fIsConfigured = true;
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        if (this.fStructurePresenter != null) {
            this.fStructurePresenter.uninstall();
            this.fStructurePresenter = null;
        }
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.uninstall();
            this.fHierarchyPresenter = null;
        }
        super.unconfigure();
        this.fIsConfigured = false;
    }
}

