/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.imp.editor.IProblemChangedListener;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class EditorErrorTickUpdater
implements IProblemChangedListener {
    private UniversalEditor fEditor;
    private ILabelProvider fLabelProvider;

    public EditorErrorTickUpdater(UniversalEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fLabelProvider = ServiceFactory.getInstance().getLabelProvider(editor.fLanguage);
        this.fEditor.getProblemMarkerManager().addListener(this);
    }

    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (!isMarkerChange) {
            return;
        }
        IEditorInput input = this.fEditor.getEditorInput();
        if (input != null) {
            if (!(input instanceof IFileEditorInput)) {
                return;
            }
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            if (file != null) {
                for (int i = 0; i < changedResources.length; ++i) {
                    if (!changedResources[i].equals(file)) continue;
                    this.updateEditorImage(file);
                }
            }
        }
    }

    public void updateEditorImage(IFile file) {
        Image titleImage = this.fEditor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        if (this.fLabelProvider == null) {
            return;
        }
        Image newImage = this.fLabelProvider.getImage((Object)file);
        if (titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private void postImageChange(final Image newImage) {
        Shell shell = this.fEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditorErrorTickUpdater.this.fEditor.updatedTitleImage(newImage);
                }
            });
        }
    }

    public void dispose() {
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
        this.fEditor.getProblemMarkerManager().removeListener(this);
    }
}

