/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesUtilities;
import org.eclipse.imp.preferences.TabbedPreferencesPage;
import org.eclipse.imp.preferences.fields.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class PreferencesTab {
    protected TabbedPreferencesPage fPrefPage = null;
    protected PreferencesUtilities fPrefUtils;
    protected IPreferencesService fPrefService;
    protected FieldEditor[] fFields = null;
    protected boolean fNoDetails = false;
    protected List<Link> fDetailsLinks = new ArrayList<Link>();
    protected String fLevel;
    protected boolean fIsValid = true;
    protected Control[] fButtons = null;
    protected TabItem fTabItem = null;
    public HashMap errorMessages = new HashMap();

    public PreferencesTab(String level, boolean noDetails) {
        this.fLevel = level;
        this.fNoDetails = noDetails;
    }

    public TabItem getTabItem() {
        return this.fTabItem;
    }

    public String getLevel() {
        return this.fLevel;
    }

    public boolean getNoDetails() {
        return this.fNoDetails;
    }

    protected abstract FieldEditor[] createFields(TabbedPreferencesPage var1, Composite var2);

    public abstract Composite createTabContents(TabbedPreferencesPage var1, TabFolder var2);

    public void setErrorMarkOnTab() {
        if (this.errorMessages.isEmpty()) {
            return;
        }
        String label = this.fTabItem.getText();
        if (!label.startsWith("**")) {
            label = "**" + label;
        }
        if (!label.endsWith("**")) {
            label = label + "**";
        }
        this.fTabItem.setText(label);
    }

    public void clearErrorMarkOnTab() {
        if (!this.errorMessages.isEmpty()) {
            return;
        }
        String label = this.fTabItem.getText();
        if (label.startsWith("**")) {
            label = label.substring(2);
        }
        if (label.endsWith("**")) {
            label = label.substring(0, label.length() - 2);
        }
        this.fTabItem.setText(label);
    }

    public void clearErrorMessages(Object key) {
        String currentMessage = (String)this.errorMessages.get(key);
        this.errorMessages.remove(key);
        if (this.fPrefPage == null) {
            return;
        }
        if (this.errorMessages.size() == 0) {
            this.fPrefPage.setErrorMessage(null);
            return;
        }
        Iterator it = this.errorMessages.keySet().iterator();
        Object nextKey = it.next();
        String nextMessage = (String)this.errorMessages.get(nextKey);
        this.fPrefPage.setErrorMessage(nextMessage);
    }

    public void setErrorMessage(Object key, String msg) {
        if (key != null && msg != null) {
            this.errorMessages.put(key, msg);
            this.fPrefPage.setErrorMessage(msg);
        }
    }

    public void clearModifiedMarksOnLabels() {
        for (int i = 0; i < this.fFields.length; ++i) {
            this.fFields[i].clearModifiedMarkOnLabel();
        }
    }

    public void performApply() {
        for (int i = 0; i < this.fFields.length; ++i) {
            this.fFields[i].store();
            this.fFields[i].clearModifiedMarkOnLabel();
        }
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
    }

    public boolean performOk() {
        if (this.fFields != null) {
            for (int i = 0; i < this.fFields.length; ++i) {
                this.fFields[i].store();
                this.fFields[i].clearModifiedMarkOnLabel();
            }
        }
        return true;
    }

    public void setValid(boolean state) {
        boolean bl = this.fIsValid = this.errorMessages.size() == 0;
        if (!this.fIsValid) {
            this.setErrorMarkOnTab();
        } else {
            this.clearErrorMarkOnTab();
        }
        this.fPrefPage.notifyState(this.fIsValid);
        this.updateButtons();
    }

    public boolean isValid() {
        return this.fIsValid;
    }

    public void updateButtons() {
        if (this.fButtons != null) {
            for (int i = 0; i < this.fButtons.length; ++i) {
                Button button = (Button)this.fButtons[i];
                if (button != null && button.getText().startsWith("Restore")) continue;
                button.setEnabled(this.isValid());
            }
        }
    }

    public class TabSelectionListener
    implements SelectionListener {
        private PreferencePage page = null;
        private TabItem item = null;

        public TabSelectionListener(PreferencePage page, TabItem item) {
            this.page = page;
            this.item = item;
        }

        public void widgetSelected(SelectionEvent e) {
            if (PreferencesTab.this.fPrefPage == null) {
                return;
            }
            if (e.item != this.item) {
                return;
            }
            if (PreferencesTab.this.errorMessages.size() == 0) {
                PreferencesTab.this.fPrefPage.setErrorMessage(null);
                return;
            }
            Iterator it = PreferencesTab.this.errorMessages.keySet().iterator();
            Object nextKey = it.next();
            String nextMessage = (String)PreferencesTab.this.errorMessages.get(nextKey);
            PreferencesTab.this.fPrefPage.setErrorMessage(nextMessage);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

