/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import lpg.runtime.ILexStream;
import lpg.runtime.IMessageHandler;
import lpg.runtime.IPrsStream;
import lpg.runtime.IntSegmentedTuple;
import lpg.runtime.ParseErrorCodes;

public class LexStream
implements ILexStream,
ParseErrorCodes {
    static final int DEFAULT_TAB = 1;
    private int index = -1;
    private int streamLength = 0;
    private char[] inputChars;
    private String fileName;
    private IntSegmentedTuple lineOffsets;
    private int tab = 1;
    protected IPrsStream prsStream;
    private IMessageHandler errMsg = null;

    public LexStream() {
        this.lineOffsets = new IntSegmentedTuple(12);
        this.setLineOffset(-1);
    }

    public LexStream(int tab) {
        this();
        this.tab = tab;
    }

    public LexStream(String fileName) throws IOException {
        this(fileName, 1);
    }

    public LexStream(String fileName, int tab) throws IOException {
        this(tab);
        this.initialize(fileName);
    }

    public LexStream(char[] inputChars, String fileName) {
        this();
        this.initialize(inputChars, fileName);
    }

    public LexStream(IntSegmentedTuple lineOffsets, char[] inputChars, String fileName) {
        this.initialize(lineOffsets, inputChars, fileName);
    }

    public LexStream(char[] inputChars, String fileName, int tab) {
        this(tab);
        this.initialize(inputChars, fileName);
    }

    public LexStream(IntSegmentedTuple lineOffsets, char[] inputChars, String fileName, int tab) {
        this.tab = tab;
        this.initialize(lineOffsets, inputChars, fileName);
    }

    public void initialize(String fileName) throws IOException {
        try {
            File f = new File(fileName);
            InputStreamReader in = new InputStreamReader(new FileInputStream(f));
            char[] buffer = new char[(int)f.length()];
            in.read(buffer, 0, buffer.length);
            this.initialize(buffer, fileName);
        }
        catch (Exception e) {
            IOException io = new IOException();
            System.err.println(e.getMessage());
            e.printStackTrace();
            throw io;
        }
    }

    public void initialize(char[] inputChars, String fileName) {
        this.setInputChars(inputChars);
        this.setStreamLength(inputChars.length);
        this.setFileName(fileName);
        this.computeLineOffsets();
    }

    public void initialize(IntSegmentedTuple lineOffsets, char[] inputChars, String fileName) {
        this.lineOffsets = lineOffsets;
        this.setInputChars(inputChars);
        this.setStreamLength(inputChars.length);
        this.setFileName(fileName);
    }

    public void computeLineOffsets() {
        this.lineOffsets.reset();
        this.setLineOffset(-1);
        for (int i = 0; i < this.inputChars.length; ++i) {
            if (this.inputChars[i] != '\n') continue;
            this.setLineOffset(i);
        }
    }

    public void setInputChars(char[] inputChars) {
        this.inputChars = inputChars;
        this.index = -1;
    }

    public char[] getInputChars() {
        return this.inputChars;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setLineOffsets(IntSegmentedTuple lineOffsets) {
        this.lineOffsets = lineOffsets;
    }

    public IntSegmentedTuple getLineOffsets() {
        return this.lineOffsets;
    }

    public void setTab(int tab) {
        this.tab = tab;
    }

    public int getTab() {
        return this.tab;
    }

    public void setStreamIndex(int index) {
        this.index = index;
    }

    public int getStreamIndex() {
        return this.index;
    }

    public void setStreamLength(int streamLength) {
        this.streamLength = streamLength;
    }

    public int getStreamLength() {
        return this.streamLength;
    }

    public void setLineOffset(int i) {
        this.lineOffsets.add(i);
    }

    public int getLineOffset(int i) {
        return this.lineOffsets.get(i);
    }

    public void setPrsStream(IPrsStream prsStream) {
        prsStream.setLexStream(this);
        this.prsStream = prsStream;
    }

    public IPrsStream getIPrsStream() {
        return this.prsStream;
    }

    public IPrsStream getPrsStream() {
        return this.prsStream;
    }

    public String[] orderedExportedSymbols() {
        return null;
    }

    public char getCharValue(int i) {
        return this.inputChars[i];
    }

    public int getIntValue(int i) {
        return this.inputChars[i];
    }

    public int getLine() {
        return this.getLineCount();
    }

    public int getLineCount() {
        return this.lineOffsets.size() - 1;
    }

    public int getLineNumberOfCharAt(int i) {
        int index = this.lineOffsets.binarySearch(i);
        return index < 0 ? -index : (index == 0 ? 1 : index);
    }

    public int getColumnOfCharAt(int i) {
        int lineNo = this.getLineNumberOfCharAt(i);
        int start = this.lineOffsets.get(lineNo - 1);
        if (start + 1 >= this.streamLength) {
            return 1;
        }
        for (int k = start + 1; k < i; ++k) {
            if (this.inputChars[k] != '\t') continue;
            int offset = k - start - 1;
            start -= this.tab - 1 - offset % this.tab;
        }
        return i - start;
    }

    public int getToken() {
        this.index = this.getNext(this.index);
        return this.index;
    }

    public int getToken(int end_token) {
        this.index = this.index < end_token ? this.getNext(this.index) : this.streamLength;
        return this.index;
    }

    public int getKind(int i) {
        return 0;
    }

    int next(int i) {
        return this.getNext(i);
    }

    public int getNext(int i) {
        return ++i < this.streamLength ? i : this.streamLength;
    }

    int previous(int i) {
        return this.getPrevious(i);
    }

    public int getPrevious(int i) {
        return i <= 0 ? 0 : i - 1;
    }

    public String getName(int i) {
        return i >= this.getStreamLength() ? "" : "" + this.getCharValue(i);
    }

    public int peek() {
        return this.getNext(this.index);
    }

    public void reset(int i) {
        this.index = i - 1;
    }

    public void reset() {
        this.index = -1;
    }

    public int badToken() {
        return 0;
    }

    public int getLine(int i) {
        return this.getLineNumberOfCharAt(i);
    }

    public int getColumn(int i) {
        return this.getColumnOfCharAt(i);
    }

    public int getEndLine(int i) {
        return this.getLine(i);
    }

    public int getEndColumn(int i) {
        return this.getColumnOfCharAt(i);
    }

    public boolean afterEol(int i) {
        return i < 1 ? true : this.getLineNumberOfCharAt(i - 1) < this.getLineNumberOfCharAt(i);
    }

    public int getFirstErrorToken(int i) {
        return this.getFirstRealToken(i);
    }

    public int getFirstRealToken(int i) {
        return i;
    }

    public int getLastErrorToken(int i) {
        return this.getLastRealToken(i);
    }

    public int getLastRealToken(int i) {
        return i;
    }

    public void setMessageHandler(IMessageHandler errMsg) {
        this.errMsg = errMsg;
    }

    public IMessageHandler getMessageHandler() {
        return this.errMsg;
    }

    public void makeToken(int startLoc, int endLoc, int kind) {
        if (this.prsStream != null) {
            this.prsStream.makeToken(startLoc, endLoc, kind);
        } else {
            this.reportLexicalError(startLoc, endLoc);
        }
    }

    public void reportLexicalError(int left_loc, int right_loc) {
        int errorCode;
        int n = right_loc >= this.streamLength ? 10 : (errorCode = left_loc == right_loc ? 0 : 11);
        String tokenText = errorCode == 10 ? "End-of-file " : (errorCode == 11 ? "\"" + new String(this.inputChars, left_loc, right_loc - left_loc + 1) + "\" " : "\"" + this.getCharValue(left_loc) + "\" ");
        this.reportLexicalError(errorCode, left_loc, right_loc, 0, 0, new String[]{tokenText});
    }

    public int[] getLocation(int left_loc, int right_loc) {
        int length = (right_loc < this.streamLength ? right_loc : this.streamLength - 1) - left_loc + 1;
        return new int[]{left_loc, length, this.getLineNumberOfCharAt(left_loc), this.getColumnOfCharAt(left_loc), this.getLineNumberOfCharAt(right_loc), this.getColumnOfCharAt(right_loc)};
    }

    public void reportLexicalError(int errorCode, int left_loc, int right_loc, int error_left_loc, int error_right_loc, String[] errorInfo) {
        if (this.errMsg == null) {
            String locationInfo = this.getFileName() + ':' + this.getLineNumberOfCharAt(left_loc) + ':' + this.getColumnOfCharAt(left_loc) + ':' + this.getLineNumberOfCharAt(right_loc) + ':' + this.getColumnOfCharAt(right_loc) + ':' + error_left_loc + ':' + error_right_loc + ':' + errorCode + ": ";
            System.out.print("****Error: " + locationInfo);
            if (errorInfo != null) {
                for (int i = 0; i < errorInfo.length; ++i) {
                    System.out.print(errorInfo[i] + " ");
                }
            }
            System.out.println(errorMsgText[errorCode]);
        } else {
            this.errMsg.handleMessage(errorCode, this.getLocation(left_loc, right_loc), this.getLocation(error_left_loc, error_right_loc), this.getFileName(), errorInfo);
        }
    }

    public void reportError(int errorCode, int leftToken, int rightToken, String errorInfo) {
        String[] stringArray;
        if (errorInfo == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = errorInfo;
        }
        this.reportError(errorCode, leftToken, 0, rightToken, stringArray);
    }

    public void reportError(int errorCode, int leftToken, int rightToken, String[] errorInfo) {
        this.reportError(errorCode, leftToken, 0, rightToken, errorInfo);
    }

    public void reportError(int errorCode, int leftToken, int errorToken, int rightToken, String errorInfo) {
        String[] stringArray;
        if (errorInfo == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = errorInfo;
        }
        this.reportError(errorCode, leftToken, errorToken, rightToken, stringArray);
    }

    public void reportError(int errorCode, int leftToken, int errorToken, int rightToken, String[] errorInfo) {
        this.reportLexicalError(errorCode, leftToken, rightToken, errorToken, errorToken, errorInfo == null ? new String[]{} : errorInfo);
    }

    public String toString(int startOffset, int endOffset) {
        int length = endOffset - startOffset + 1;
        return endOffset >= this.inputChars.length ? "$EOF" : (length <= 0 ? "" : new String(this.inputChars, startOffset, length));
    }
}

