
////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2007 IBM Corporation.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
//Contributors:
//    Stan Sutton (suttons@us.ibm.com) - initial API and implementation
//    Robert Fuhrer (rfuhrer@watson.ibm.com)
////////////////////////////////////////////////////////////////////////////////

package org.eclipse.imp.prefspecs.parser;

public interface PrefspecsParsersym {
    public final static int
      TK_COMMA = 16,
      TK_DOT = 27,
      TK_SEMICOLON = 1,
      TK_PLUS = 43,
      TK_MINUS = 44,
      TK_LEFTPAREN = 63,
      TK_RIGHTPAREN = 64,
      TK_LEFTBRACE = 2,
      TK_RIGHTBRACE = 3,
      TK_PACKAGE = 45,
      TK_PAGE = 28,
      TK_TABS = 46,
      TK_FIELDS = 29,
      TK_CONDITIONALS = 47,
      TK_CHOICETYPE = 30,
      TK_CUSTOM = 48,
      TK_DETAILS = 49,
      TK_DEFAULT = 17,
      TK_CONFIGURATION = 18,
      TK_INSTANCE = 19,
      TK_PROJECT = 20,
      TK_IN = 50,
      TK_OUT = 51,
      TK_BOOLEAN = 31,
      TK_COLOR = 32,
      TK_COMBO = 33,
      TK_DIRECTORY = 34,
      TK_DIRLIST = 35,
      TK_DOUBLE = 36,
      TK_FILE = 37,
      TK_FONT = 38,
      TK_INT = 39,
      TK_RADIO = 40,
      TK_STRING = 41,
      TK_BOLD = 52,
      TK_COLUMNS = 21,
      TK_DEFVALUE = 8,
      TK_DYNAMIC = 53,
      TK_EMPTYALLOWED = 11,
      TK_HASSPECIAL = 9,
      TK_ISEDITABLE = 4,
      TK_ISREMOVABLE = 5,
      TK_ITALIC = 54,
      TK_LABEL = 6,
      TK_NORMAL = 55,
      TK_RANGE = 12,
      TK_TOOLTIP = 7,
      TK_TYPE = 22,
      TK_VALIDATOR = 13,
      TK_VALUES = 23,
      TK_TRUE = 24,
      TK_FALSE = 25,
      TK_ON = 56,
      TK_OFF = 57,
      TK_WITH = 58,
      TK_AGAINST = 59,
      TK_IF = 60,
      TK_UNLESS = 61,
      TK_EOF_TOKEN = 62,
      TK_SINGLE_LINE_COMMENT = 65,
      TK_IDENTIFIER = 15,
      TK_INTEGER = 10,
      TK_STRING_LITERAL = 14,
      TK_DECIMAL = 26,
      TK_DOTS = 42,
      TK_ERROR_TOKEN = 66;

    public final static String orderedTerminalSymbols[] = {
                 "",
                 "SEMICOLON",
                 "LEFTBRACE",
                 "RIGHTBRACE",
                 "ISEDITABLE",
                 "ISREMOVABLE",
                 "LABEL",
                 "TOOLTIP",
                 "DEFVALUE",
                 "HASSPECIAL",
                 "INTEGER",
                 "EMPTYALLOWED",
                 "RANGE",
                 "VALIDATOR",
                 "STRING_LITERAL",
                 "IDENTIFIER",
                 "COMMA",
                 "DEFAULT",
                 "CONFIGURATION",
                 "INSTANCE",
                 "PROJECT",
                 "COLUMNS",
                 "TYPE",
                 "VALUES",
                 "TRUE",
                 "FALSE",
                 "DECIMAL",
                 "DOT",
                 "PAGE",
                 "FIELDS",
                 "CHOICETYPE",
                 "BOOLEAN",
                 "COLOR",
                 "COMBO",
                 "DIRECTORY",
                 "DIRLIST",
                 "DOUBLE",
                 "FILE",
                 "FONT",
                 "INT",
                 "RADIO",
                 "STRING",
                 "DOTS",
                 "PLUS",
                 "MINUS",
                 "PACKAGE",
                 "TABS",
                 "CONDITIONALS",
                 "CUSTOM",
                 "DETAILS",
                 "IN",
                 "OUT",
                 "BOLD",
                 "DYNAMIC",
                 "ITALIC",
                 "NORMAL",
                 "ON",
                 "OFF",
                 "WITH",
                 "AGAINST",
                 "IF",
                 "UNLESS",
                 "EOF_TOKEN",
                 "LEFTPAREN",
                 "RIGHTPAREN",
                 "SINGLE_LINE_COMMENT",
                 "ERROR_TOKEN"
             };

    public final static int numTokenKinds = orderedTerminalSymbols.length;
    public final static boolean isValidForParser = true;
}
