/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.AnnotatedConstructor;
import org.eclipse.imp.pdb.facts.impl.fast.Value;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeStore;
import org.eclipse.imp.pdb.facts.util.ShareableHashMap;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constructor
extends Value
implements IConstructor {
    protected final Type constructorType;
    protected final IValue[] children;

    protected Constructor(Type constructorType, IValue[] children) {
        this.constructorType = constructorType;
        this.children = children;
    }

    @Override
    public Type getType() {
        return this.constructorType.getAbstractDataType();
    }

    @Override
    public Type getConstructorType() {
        return this.constructorType;
    }

    @Override
    public Type getChildrenTypes() {
        return this.constructorType.getFieldTypes();
    }

    @Override
    public String getName() {
        return this.constructorType.getName();
    }

    @Override
    public int arity() {
        return this.children.length;
    }

    @Override
    public IValue get(int i) {
        return this.children[i];
    }

    @Override
    public IValue get(String label) {
        return this.get(this.constructorType.getFieldIndex(label));
    }

    @Override
    public Iterable<IValue> getChildren() {
        return this;
    }

    @Override
    public Iterator<IValue> iterator() {
        return new TreeIterator(this);
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitConstructor(this);
    }

    @Override
    public IConstructor set(int i, IValue newChild) {
        IValue[] newChildren = (IValue[])this.children.clone();
        newChildren[i] = newChild;
        return new Constructor(this.constructorType, newChildren);
    }

    @Override
    public IConstructor set(String label, IValue newChild) {
        IValue[] newChildren = (IValue[])this.children.clone();
        newChildren[this.constructorType.getFieldIndex((String)label)] = newChild;
        return new Constructor(this.constructorType, newChildren);
    }

    @Override
    public boolean declaresAnnotation(TypeStore store, String label) {
        return store.getAnnotationType(this.constructorType.getAbstractDataType(), label) != null;
    }

    @Override
    public boolean hasAnnotation(String label) {
        return false;
    }

    @Override
    public boolean hasAnnotations() {
        return false;
    }

    @Override
    public IValue getAnnotation(String label) {
        return null;
    }

    @Override
    public Map<String, IValue> getAnnotations() {
        return new ShareableHashMap<String, IValue>();
    }

    @Override
    public IConstructor setAnnotation(String label, IValue value) {
        return AnnotatedConstructor.createAnnotatedConstructor(this.constructorType, this.children, this.getUpdatedAnnotations(label, value));
    }

    @Override
    public IConstructor setAnnotations(Map<String, IValue> newAnnos) {
        if (newAnnos.isEmpty()) {
            return this;
        }
        return AnnotatedConstructor.createAnnotatedConstructor(this.constructorType, this.children, this.getSetAnnotations(newAnnos));
    }

    @Override
    public IConstructor joinAnnotations(Map<String, IValue> newAnnos) {
        return AnnotatedConstructor.createAnnotatedConstructor(this.constructorType, this.children, this.getUpdatedAnnotations(newAnnos));
    }

    @Override
    public IConstructor removeAnnotation(String label) {
        return AnnotatedConstructor.createAnnotatedConstructor(this.constructorType, this.children, this.getUpdatedAnnotations(label));
    }

    @Override
    public IConstructor removeAnnotations() {
        return this;
    }

    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label, IValue value) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
        newAnnotations.put(label, value);
        return newAnnotations;
    }

    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
        newAnnotations.remove(label);
        return newAnnotations;
    }

    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(Map<String, IValue> newAnnos) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
        for (Map.Entry<String, IValue> entry : newAnnos.entrySet()) {
            String key = entry.getKey();
            IValue value = entry.getValue();
            newAnnotations.put(key, value);
        }
        return newAnnotations;
    }

    protected ShareableHashMap<String, IValue> getSetAnnotations(Map<String, IValue> newAnnos) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
        for (Map.Entry<String, IValue> entry : newAnnos.entrySet()) {
            String key = entry.getKey();
            IValue value = entry.getValue();
            newAnnotations.put(key, value);
        }
        return newAnnotations;
    }

    public int hashCode() {
        int hash = this.constructorType.hashCode();
        for (int i = this.children.length - 1; i >= 0; --i) {
            hash = (hash << 23) + (hash >> 5);
            hash ^= this.children[i].hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            Constructor otherTree = (Constructor)o;
            if (this.constructorType != otherTree.constructorType) {
                return false;
            }
            IValue[] otherChildren = otherTree.children;
            int nrOfChildren = this.children.length;
            if (otherChildren.length == nrOfChildren) {
                for (int i = nrOfChildren - 1; i >= 0; --i) {
                    if (((Object)otherChildren[i]).equals(this.children[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEqual(IValue value) {
        if (value == this) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Constructor) {
            Constructor otherTree = (Constructor)value;
            if (!this.constructorType.comparable(otherTree.constructorType)) {
                return false;
            }
            IValue[] otherChildren = otherTree.children;
            int nrOfChildren = this.children.length;
            if (otherChildren.length == nrOfChildren) {
                for (int i = nrOfChildren - 1; i >= 0; --i) {
                    if (otherChildren[i].isEqual(this.children[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean has(String label) {
        return this.getConstructorType().hasField(label);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeIterator
    implements Iterator<IValue> {
        private final IValue[] children;
        private int index = 0;

        public TreeIterator(Constructor tree) {
            this.children = tree.children;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.children.length;
        }

        @Override
        public IValue next() {
            return this.children[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }
}

