/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.reference;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedMapKeyTypeException;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedMapValueTypeException;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.impl.Writer;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Map
extends Value
implements IMap {
    private final HashMap<IValue, IValue> content;
    private int fHash = 0;

    Map(Type keyType, Type valueType, HashMap<IValue, IValue> content) {
        super(TypeFactory.getInstance().mapType(keyType, valueType));
        this.content = content;
    }

    @Override
    public int size() {
        return this.content.size();
    }

    public int arity() {
        return this.content.size();
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public IValue get(IValue key) {
        return this.content.get(key);
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.content.keySet().iterator();
    }

    @Override
    public Iterator<Map.Entry<IValue, IValue>> entryIterator() {
        return this.content.entrySet().iterator();
    }

    @Override
    public Iterator<IValue> valueIterator() {
        return this.content.values().iterator();
    }

    @Override
    public boolean containsKey(IValue key) {
        return this.content.containsKey(key);
    }

    @Override
    public boolean containsValue(IValue value) {
        return this.content.containsValue(value);
    }

    @Override
    public IMap put(IValue key, IValue value) {
        MapWriter sw = new MapWriter(this.getKeyType().lub(key.getType()), this.getValueType().lub(value.getType()));
        sw.putAll(this);
        sw.put(key, value);
        return sw.done();
    }

    @Override
    public IMap join(IMap other) {
        MapWriter sw = new MapWriter(this.getKeyType().lub(other.getKeyType()), this.getValueType().lub(other.getValueType()));
        sw.putAll(this);
        sw.putAll(other);
        return sw.done();
    }

    @Override
    public IMap common(IMap other) {
        MapWriter sw = new MapWriter(this.getKeyType().lub(other.getKeyType()), this.getValueType().lub(other.getValueType()));
        for (IValue key : this) {
            IValue thisValue = this.get(key);
            IValue otherValue = other.get(key);
            if (otherValue == null || !thisValue.isEqual(otherValue)) continue;
            sw.put(key, thisValue);
        }
        return sw.done();
    }

    @Override
    public IMap remove(IMap other) {
        MapWriter sw = new MapWriter(this.getKeyType().lub(other.getKeyType()), this.getValueType().lub(other.getValueType()));
        for (IValue key : this) {
            if (other.containsKey(key)) continue;
            sw.put(key, this.get(key));
        }
        return sw.done();
    }

    @Override
    public boolean isSubMap(IMap other) {
        for (IValue key : this) {
            IValue thisValue = this.get(key);
            IValue otherValue = other.get(key);
            if (otherValue == null) {
                return false;
            }
            if (thisValue.isEqual(otherValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            Map other = (Map)o;
            return this.fType.comparable(other.fType) && this.content.equals(other.content);
        }
        return false;
    }

    public int hashCode() {
        if (this.fHash == 0) {
            this.fHash = this.content.hashCode();
        }
        return this.fHash;
    }

    @Override
    public Type getKeyType() {
        return this.fType.getKeyType();
    }

    @Override
    public Type getValueType() {
        return this.fType.getValueType();
    }

    private static void check(Type key, Type value, Type keyType, Type valueType) throws FactTypeUseException {
        if (!key.isSubtypeOf(keyType)) {
            throw new UnexpectedMapKeyTypeException(keyType, key);
        }
        if (!value.isSubtypeOf(valueType)) {
            throw new UnexpectedMapValueTypeException(valueType, value);
        }
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitMap(this);
    }

    static MapWriter createMapWriter(Type keyType, Type valueType) {
        return new MapWriter(keyType, valueType);
    }

    static MapWriter createMapWriter() {
        return new MapWriter();
    }

    @Override
    public IMap compose(IMap other) {
        MapWriter w = new MapWriter(this.getKeyType(), other.getValueType());
        Iterator<Map.Entry<IValue, IValue>> iter = this.entryIterator();
        while (iter.hasNext()) {
            Map.Entry<IValue, IValue> e = iter.next();
            IValue value = other.get(e.getValue());
            if (value == null) continue;
            w.put(e.getKey(), value);
        }
        return w.done();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapWriter
    extends Writer
    implements IMapWriter {
        private Type keyType;
        private Type valueType;
        private final boolean inferred;
        private final HashMap<IValue, IValue> mapContent;
        private Map constructedMap;

        public MapWriter(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.inferred = false;
            this.mapContent = new HashMap();
        }

        public MapWriter() {
            this.keyType = TypeFactory.getInstance().voidType();
            this.valueType = TypeFactory.getInstance().voidType();
            this.inferred = true;
            this.mapContent = new HashMap();
        }

        private void checkMutation() {
            if (this.constructedMap != null) {
                throw new UnsupportedOperationException("Mutation of a finalized list is not supported.");
            }
        }

        @Override
        public void putAll(IMap map) throws FactTypeUseException {
            this.checkMutation();
            Type mapType = map.getType();
            Map.check(mapType.getKeyType(), mapType.getValueType(), this.keyType, this.valueType);
            for (IValue key : map) {
                IValue value = map.get(key);
                this.updateTypes(key, value);
                this.mapContent.put(key, value);
            }
        }

        private void updateTypes(IValue key, IValue value) {
            if (this.inferred) {
                this.keyType = this.keyType.lub(key.getType());
                this.valueType = this.valueType.lub(value.getType());
            }
        }

        @Override
        public void putAll(java.util.Map<IValue, IValue> map) throws FactTypeUseException {
            this.checkMutation();
            for (IValue key : map.keySet()) {
                IValue value = map.get(key);
                this.updateTypes(key, value);
                Map.check(key.getType(), value.getType(), this.keyType, this.valueType);
                this.mapContent.put(key, value);
            }
        }

        @Override
        public void put(IValue key, IValue value) throws FactTypeUseException {
            this.checkMutation();
            this.updateTypes(key, value);
            this.mapContent.put(key, value);
        }

        @Override
        public void insert(IValue ... value) throws FactTypeUseException {
            for (IValue tuple : value) {
                ITuple t = (ITuple)tuple;
                IValue key = t.get(0);
                IValue value2 = t.get(1);
                this.updateTypes(key, value2);
                this.put(key, value2);
            }
        }

        @Override
        public IMap done() {
            if (this.constructedMap == null) {
                this.constructedMap = new Map(this.keyType, this.valueType, this.mapContent);
            }
            return this.constructedMap;
        }
    }
}

