/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.reference;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedElementTypeException;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.impl.Writer;
import org.eclipse.imp.pdb.facts.impl.reference.Relation;
import org.eclipse.imp.pdb.facts.impl.reference.Tuple;
import org.eclipse.imp.pdb.facts.impl.reference.ValueFactory;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Set
extends Value
implements ISet {
    final HashSet<IValue> content;
    private int fHash;

    Set(Type setType, HashSet<IValue> content) {
        super(setType);
        this.content = content;
    }

    @Override
    public boolean contains(IValue element) throws FactTypeUseException {
        return this.content.contains(element);
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    public <SetOrRel extends ISet> SetOrRel insert(IValue element) {
        ISetWriter sw = ValueFactory.getInstance().setWriter(this.getElementType().lub(element.getType()));
        sw.insertAll(this);
        sw.insert(element);
        return (SetOrRel)sw.done();
    }

    @Override
    public <SetOrRel extends ISet> SetOrRel intersect(ISet other) {
        ISetWriter w = ValueFactory.getInstance().setWriter(other.getElementType().lub(this.getElementType()));
        Set o = (Set)other;
        for (IValue v : this.content) {
            if (!o.content.contains(v)) continue;
            w.insert(v);
        }
        return (SetOrRel)w.done();
    }

    @Override
    public <SetOrRel extends ISet> SetOrRel subtract(ISet other) {
        ISetWriter sw = ValueFactory.getInstance().setWriter(this.getElementType());
        for (IValue a : this.content) {
            if (other.contains(a)) continue;
            sw.insert(a);
        }
        return (SetOrRel)sw.done();
    }

    @Override
    public <SetOrRel extends ISet> SetOrRel delete(IValue elem) {
        ISetWriter sw = ValueFactory.getInstance().setWriter(this.getElementType());
        sw.insertAll(this);
        sw.delete(elem);
        return (SetOrRel)sw.done();
    }

    @Override
    public boolean isSubsetOf(ISet other) {
        for (IValue elem : this) {
            if (other.contains(elem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <SetOrRel extends ISet> SetOrRel union(ISet other) {
        ISetWriter w = ValueFactory.getInstance().setWriter(other.getElementType().lub(this.getElementType()));
        w.insertAll(this);
        w.insertAll(other);
        ISet result = w.done();
        return (SetOrRel)result;
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.content.iterator();
    }

    @Override
    public Type getElementType() {
        return this.fType.getElementType();
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() == Set.class || o.getClass() == Relation.class) {
            Set other = (Set)o;
            return this.fType.comparable(other.fType) && this.content.equals(other.content);
        }
        return false;
    }

    public int hashCode() {
        if (this.fHash == 0) {
            this.fHash = this.content.hashCode();
        }
        return this.fHash;
    }

    @Override
    public IRelation product(ISet set) {
        Type resultType = TypeFactory.getInstance().tupleType(this.getElementType(), set.getElementType());
        Relation.RelationWriter w = new Relation.RelationWriter(resultType);
        for (IValue t1 : this) {
            for (IValue t2 : set) {
                Tuple t3 = new Tuple(t1, t2);
                w.insert(t3);
            }
        }
        return w.done();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitSet(this);
    }

    private static void checkInsert(IValue elem, Type eltType) throws FactTypeUseException {
        Type type = elem.getType();
        if (!type.isSubtypeOf(eltType)) {
            throw new UnexpectedElementTypeException(eltType, type);
        }
    }

    static ISetWriter createSetWriter(Type eltType) {
        return new SetWriter(eltType);
    }

    static ISetWriter createSetWriter() {
        return new SetWriter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SetWriter
    extends Writer
    implements ISetWriter {
        protected Type eltType;
        protected final HashSet<IValue> setContent;
        protected Set constructedSet;
        protected final boolean inferred;

        public SetWriter(Type eltType) {
            this.eltType = eltType;
            this.inferred = false;
            this.setContent = new HashSet();
        }

        public SetWriter() {
            this.eltType = TypeFactory.getInstance().voidType();
            this.inferred = true;
            this.setContent = new HashSet();
        }

        private void put(IValue elem) {
            this.updateType(elem);
            Set.checkInsert(elem, this.eltType);
            this.setContent.add(elem);
        }

        private void updateType(IValue elem) {
            if (this.inferred) {
                this.eltType = this.eltType.lub(elem.getType());
            }
        }

        @Override
        public void insert(IValue ... elems) throws FactTypeUseException {
            this.checkMutation();
            for (IValue elem : elems) {
                this.put(elem);
            }
        }

        @Override
        public void insertAll(Iterable<IValue> collection) throws FactTypeUseException {
            this.checkMutation();
            for (IValue v : collection) {
                this.put(v);
            }
        }

        @Override
        public ISet done() {
            if (this.constructedSet == null) {
                this.constructedSet = this.inferred && this.eltType.isTupleType() && !this.eltType.isVoidType() ? new Relation(this.eltType, this.setContent) : new Set(TypeFactory.getInstance().setType(this.eltType), this.setContent);
            }
            return this.constructedSet;
        }

        private void checkMutation() {
            if (this.constructedSet != null) {
                throw new UnsupportedOperationException("Mutation of a finalized set is not supported.");
            }
        }

        @Override
        public int size() {
            return this.constructedSet.size();
        }

        @Override
        public void delete(IValue v) {
            this.checkMutation();
            this.setContent.remove(v);
        }
    }
}

