/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeType
extends Type {
    private static final DateTimeType sInstance = new DateTimeType();

    static DateTimeType getInstance() {
        return sInstance;
    }

    private DateTimeType() {
    }

    @Override
    public boolean isDateTimeType() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof DateTimeType;
    }

    public int hashCode() {
        return 63097;
    }

    public String toString() {
        return "datetime";
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitDateTime(this);
    }

    @Override
    public IValue make(IValueFactory f, int year, int month, int day) {
        return f.date(year, month, day);
    }

    @Override
    public IValue make(IValueFactory f, int hour, int minute, int second, int millisecond) {
        return f.time(hour, minute, second, millisecond);
    }

    @Override
    public IValue make(IValueFactory f, int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
        return f.time(hour, minute, second, millisecond, hourOffset, minuteOffset);
    }

    @Override
    public IValue make(IValueFactory f, int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return f.datetime(year, month, day, hour, minute, second, millisecond);
    }

    @Override
    public IValue make(IValueFactory f, int year, int month, int day, int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
        return f.datetime(year, month, day, hour, minute, second, millisecond, hourOffset, minuteOffset);
    }

    @Override
    public IValue make(IValueFactory f, long instant) {
        return f.datetime(instant);
    }

    @Override
    public IValue make(IValueFactory f, int instant) {
        return f.datetime(instant);
    }
}

