/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.util.Map;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SetType
extends Type {
    private final Type fEltType;

    SetType(Type eltType) {
        this.fEltType = eltType;
    }

    @Override
    public Type getElementType() {
        return this.fEltType;
    }

    @Override
    public boolean isSetType() {
        return true;
    }

    @Override
    public boolean isSubtypeOf(Type other) {
        if (other.isSetType()) {
            return this.fEltType.isSubtypeOf(other.getElementType());
        }
        return super.isSubtypeOf(other);
    }

    @Override
    public Type carrier() {
        return this;
    }

    @Override
    public Type lub(Type o) {
        if (o.isSetType()) {
            return TypeFactory.getInstance().setType(this.fEltType.lub(o.getElementType()));
        }
        return super.lub(o);
    }

    public int hashCode() {
        return 56509 + 3511 * this.fEltType.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SetType)) {
            return false;
        }
        SetType other = (SetType)obj;
        return this.fEltType == other.fEltType;
    }

    public String toString() {
        return "set[" + this.fEltType + "]";
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitSet(this);
    }

    @Override
    public IValue make(IValueFactory f) {
        return f.set(this.fEltType);
    }

    @Override
    public IValue make(IValueFactory f, IValue ... elems) {
        return f.set(elems);
    }

    public ISetWriter writer(IValueFactory f) {
        return f.setWriter(this.fEltType);
    }

    @Override
    public void match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        super.match(matched, bindings);
        this.getElementType().match(matched.getElementType(), bindings);
    }

    @Override
    public Type instantiate(TypeStore store, Map<Type, Type> bindings) {
        return TypeFactory.getInstance().setType(this.getElementType().instantiate(store, bindings));
    }
}

