/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeDeclarationException;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeRedeclaredException;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.IllegalAnnotationDeclaration;
import org.eclipse.imp.pdb.facts.exceptions.IllegalIdentifierException;
import org.eclipse.imp.pdb.facts.exceptions.RedeclaredAnnotationException;
import org.eclipse.imp.pdb.facts.exceptions.RedeclaredConstructorException;
import org.eclipse.imp.pdb.facts.exceptions.RedeclaredFieldNameException;
import org.eclipse.imp.pdb.facts.exceptions.UndeclaredAbstractDataTypeException;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeStore {
    private final TypeFactory factory = TypeFactory.getInstance();
    private final Map<String, Type> fAliases = new HashMap<String, Type>();
    private final Map<String, Type> fADTs = new HashMap<String, Type>();
    private final Map<Type, Set<Type>> fConstructors = new HashMap<Type, Set<Type>>();
    private final Map<Type, Map<String, Type>> fAnnotations = new HashMap<Type, Map<String, Type>>();
    private final Set<TypeStore> fImports = new HashSet<TypeStore>();

    public TypeStore(TypeStore ... imports) {
        this.importStore(imports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStore(TypeStore ... stores) {
        Set<TypeStore> set = this.fImports;
        synchronized (set) {
            for (TypeStore s : stores) {
                this.doImport(s);
            }
        }
    }

    private void doImport(TypeStore s) {
        this.checkOverlappingAliases(s);
        this.checkConstructorOverloading(s);
        this.fImports.add(s);
    }

    private void checkConstructorOverloading(TypeStore s) {
        for (Type type : this.fADTs.values()) {
            Type other = s.fADTs.get(type.getName());
            if (other == null || other != type) continue;
            Set<Type> signature1 = this.fConstructors.get(type);
            Set<Type> signature2 = s.fConstructors.get(type);
            for (Type alt : signature2) {
                Type children = alt.getFieldTypes();
                this.checkOverloading(signature1, alt.getName(), children);
                this.checkFieldNames(signature1, children);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOverlappingAliases(TypeStore s) {
        Map<String, Type> map = this.fAliases;
        synchronized (map) {
            for (Type alias : this.fAliases.values()) {
                Type other = s.fAliases.get(alias.getName());
                if (other == null || other.comparable(alias)) continue;
                throw new FactTypeRedeclaredException(alias.getName(), other);
            }
        }
    }

    public TypeFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareAlias(Type alias) throws FactTypeDeclarationException {
        Map<String, Type> map = this.fADTs;
        synchronized (map) {
            Map<String, Type> map2 = this.fAliases;
            synchronized (map2) {
                String name = alias.getName();
                Type oldAdt = this.lookupAbstractDataType(name);
                if (oldAdt != null) {
                    throw new FactTypeRedeclaredException(name, oldAdt);
                }
                Type oldAlias = this.lookupAlias(name);
                if (oldAlias != null) {
                    if (alias.isSubtypeOf(oldAlias)) {
                        return;
                    }
                    throw new FactTypeRedeclaredException(name, oldAlias);
                }
                this.fAliases.put(name, alias);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareAbstractDataType(Type adt) throws FactTypeDeclarationException {
        Map<String, Type> map = this.fADTs;
        synchronized (map) {
            Map<String, Type> map2 = this.fAliases;
            synchronized (map2) {
                Map<Type, Set<Type>> map3 = this.fConstructors;
                synchronized (map3) {
                    String name = adt.getName();
                    Type oldAdt = this.lookupAbstractDataType(name);
                    if (oldAdt != null) {
                        if (adt.comparable(oldAdt)) {
                            return;
                        }
                        throw new FactTypeRedeclaredException(name, oldAdt);
                    }
                    Type oldAlias = this.lookupAlias(name);
                    if (oldAlias != null) {
                        throw new FactTypeRedeclaredException(name, oldAlias);
                    }
                    this.fADTs.put(name, adt);
                    if (this.fConstructors.get(adt) == null) {
                        this.fConstructors.put(adt, new HashSet());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareConstructor(Type constructor) throws FactTypeDeclarationException {
        Map<String, Type> map = this.fADTs;
        synchronized (map) {
            Map<Type, Set<Type>> map2 = this.fConstructors;
            synchronized (map2) {
                Type adt = constructor.getAbstractDataType();
                Type other = this.lookupAbstractDataType(adt.getName());
                if (other == null) {
                    throw new UndeclaredAbstractDataTypeException(adt);
                }
                Set<Type> signature = this.lookupAlternatives(adt);
                if (signature == null) {
                    throw new UndeclaredAbstractDataTypeException(adt);
                }
                this.checkOverloading(signature, constructor.getName(), constructor.getFieldTypes());
                this.checkFieldNames(signature, constructor.getFieldTypes());
                Set<Type> localSignature = this.fConstructors.get(adt);
                if (localSignature == null) {
                    localSignature = new HashSet<Type>();
                    this.fConstructors.put(adt, localSignature);
                    if (!this.fADTs.containsKey(adt.getName())) {
                        this.fADTs.put(adt.getName(), adt);
                    }
                }
                localSignature.add(constructor);
            }
        }
    }

    private void checkFieldNames(Set<Type> signature, Type tupleType) {
        if (!tupleType.hasFieldNames()) {
            return;
        }
        for (Type alt : signature) {
            Type altArgs = alt.getFieldTypes();
            if (!altArgs.hasFieldNames()) {
                return;
            }
            for (int i = tupleType.getArity() - 1; i >= 0; --i) {
                Type type = tupleType.getFieldType(i);
                String label = tupleType.getFieldName(i);
                for (int j = altArgs.getArity() - 1; j >= 0; --j) {
                    if (!altArgs.getFieldName(j).equals(label) || altArgs.getFieldType(j).equivalent(type)) continue;
                    throw new RedeclaredFieldNameException(label, type, altArgs.getFieldType(i));
                }
            }
        }
    }

    private void checkOverloading(Set<Type> signature, String name, Type tupleType) throws FactTypeDeclarationException {
        for (Type alt : signature) {
            Type fieldTypes;
            if (!alt.isConstructorType() || !alt.getName().equals(name) || (fieldTypes = alt.getFieldTypes()) == tupleType || !fieldTypes.comparable(tupleType)) continue;
            throw new RedeclaredConstructorException(name, fieldTypes, tupleType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type lookupAlias(String name) {
        Map<String, Type> map = this.fAliases;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                Type result = this.fAliases.get(name);
                if (result == null) {
                    for (TypeStore i : this.fImports) {
                        result = i.fAliases.get(name);
                        if (result == null) continue;
                        return result;
                    }
                }
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Type> lookupAlternatives(Type adt) {
        Map<Type, Set<Type>> map = this.fConstructors;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                Set<Type> result = this.fConstructors.get(adt);
                if (result == null) {
                    result = new HashSet<Type>();
                }
                for (TypeStore s : this.fImports) {
                    Set<Type> imported;
                    if (s == this || (imported = s.fConstructors.get(adt)) == null) continue;
                    result.addAll(imported);
                }
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Type> lookupConstructor(Type adt, String constructorName) throws FactTypeUseException {
        Map<Type, Set<Type>> map = this.fConstructors;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                Type parameterizedADT = this.fADTs.get(adt.getName());
                Set<Type> local = parameterizedADT != null ? this.fConstructors.get(parameterizedADT) : null;
                HashSet<Type> result = new HashSet<Type>();
                if (local != null) {
                    for (Type cand : local) {
                        if (!cand.getName().equals(constructorName)) continue;
                        result.add(cand);
                    }
                }
                for (TypeStore i : this.fImports) {
                    local = i.fConstructors.get(adt);
                    if (local == null) continue;
                    for (Type cand : local) {
                        if (!cand.getName().equals(constructorName)) continue;
                        result.add(cand);
                    }
                }
                return result;
            }
        }
    }

    public Type lookupFirstConstructor(String cons, Type args) {
        Set<Type> adts = this.allAbstractDataTypes();
        for (Type adt : adts) {
            Type cand = this.lookupConstructor(adt, cons, args);
            if (cand == null) continue;
            return cand;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Type> allAbstractDataTypes() {
        Map<String, Type> map = this.fADTs;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                HashSet<Type> result = new HashSet<Type>();
                result.addAll(this.fADTs.values());
                for (TypeStore s : this.fImports) {
                    result.addAll(s.fADTs.values());
                }
                return result;
            }
        }
    }

    public Type lookupConstructor(Type adt, String cons, Type args) {
        Set<Type> sig = this.lookupConstructor(adt, cons);
        if (sig != null) {
            for (Type cand : sig) {
                if (!args.isSubtypeOf(cand.getFieldTypes())) continue;
                return cand;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Type> lookupConstructors(String constructorName) {
        Map<Type, Set<Type>> map = this.fConstructors;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                HashSet<Type> result = new HashSet<Type>();
                for (Set<Type> adt : this.fConstructors.values()) {
                    for (Type type : adt) {
                        String name = type.getName();
                        if (!name.equals(constructorName)) continue;
                        result.add(type);
                    }
                }
                for (TypeStore i : this.fImports) {
                    if (i == this) continue;
                    for (Set set2 : i.fConstructors.values()) {
                        for (Type cand : set2) {
                            String name = cand.getName();
                            if (!name.equals(constructorName)) continue;
                            result.add(cand);
                        }
                    }
                }
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type lookupAbstractDataType(String name) {
        Map<String, Type> map = this.fADTs;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                Type result = this.fADTs.get(name);
                if (result != null) {
                    return result;
                }
                for (TypeStore s : this.fImports) {
                    result = s.fADTs.get(name);
                    if (result == null) continue;
                    return result;
                }
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareAnnotation(Type onType, String key, Type valueType) {
        if (!onType.isConstructorType() && !onType.isAbstractDataType()) {
            throw new IllegalAnnotationDeclaration(onType);
        }
        Map<Type, Map<String, Type>> map = this.fAnnotations;
        synchronized (map) {
            Map<String, Type> declaredEarlier;
            Map<String, Type> annotationsForType = this.fAnnotations.get(onType);
            if (!this.factory.isIdentifier(key)) {
                throw new IllegalIdentifierException(key);
            }
            if (annotationsForType == null) {
                annotationsForType = new HashMap<String, Type>();
                this.fAnnotations.put(onType, annotationsForType);
            }
            if (!(declaredEarlier = this.getAnnotations(onType)).containsKey(key)) {
                annotationsForType.put(key, valueType);
            } else if (!declaredEarlier.get(key).equivalent(valueType)) {
                throw new RedeclaredAnnotationException(key, declaredEarlier.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Type> getAnnotations(Type onType) {
        Map<Type, Map<String, Type>> map = this.fAnnotations;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                HashMap<String, Type> result = new HashMap<String, Type>();
                Map<String, Type> local = this.fAnnotations.get(onType);
                if (local != null) {
                    result.putAll(local);
                }
                for (TypeStore s : this.fImports) {
                    local = s.fAnnotations.get(onType);
                    if (local == null) continue;
                    result.putAll(local);
                }
                return result;
            }
        }
    }

    public Type getAnnotationType(Type onType, String key) {
        Map<String, Type> annotationsFor = this.getAnnotations(onType);
        Type result = annotationsFor.get(key);
        if (result != null) {
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getAlias(String name) {
        Map<String, Type> map = this.fAliases;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                Type result = this.fAliases.get(name);
                if (result != null) {
                    return result;
                }
                for (TypeStore s : this.fImports) {
                    result = s.fAliases.get(name);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
        }
    }
}

