/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis;

import org.eclipse.imp.analysis.CompilationUnitRange;
import org.eclipse.imp.analysis.ICompilationUnitRange;
import org.eclipse.imp.analysis.ISourceRange;
import org.eclipse.imp.analysis.SourceRange;
import org.eclipse.imp.model.ICompilationUnit;
import polyglot.ast.Node;
import polyglot.util.Position;

public class PolyglotUtils {
    private PolyglotUtils() {
    }

    public static ISourceRange srcRangeForNode(Node n, ICompilationUnit unit) {
        Position pos = n.position();
        return PolyglotUtils.srcRangeForPosition(pos, unit);
    }

    public static ISourceRange srcRangeForPosition(Position pos, ICompilationUnit unit) {
        if (pos == null) {
            return null;
        }
        int correctedOffset = pos.offset() - pos.line();
        int correctedEnd = pos.endOffset() - pos.endLine();
        return new SourceRange(unit != null ? unit.getFile() : null, correctedOffset, correctedEnd - correctedOffset + 1 + 1);
    }

    public static ICompilationUnitRange unitRangeForNode(Node n, ICompilationUnit unit) {
        Position pos = n.position();
        return PolyglotUtils.unitRangeForPosition(pos, unit);
    }

    public static ICompilationUnitRange unitRangeForPosition(Position pos, ICompilationUnit unit) {
        if (pos == null || unit == null) {
            return null;
        }
        return new CompilationUnitRange(unit, PolyglotUtils.srcRangeForPosition(pos, unit));
    }
}

