/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler.codegen;

import java.util.List;
import org.eclipse.imp.prefspecs.compiler.model.FieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.PageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldCodeGenerator {
    protected final FieldInfo fFieldInfo;

    public FieldCodeGenerator(FieldInfo fieldInfo) {
        this.fFieldInfo = fieldInfo;
    }

    public abstract String getFieldEditorTypeName();

    public abstract void genPreferenceInitializer(StringBuilder var1, String var2);

    public abstract void genTextToCreateField(StringBuilder var1, PageInfo var2, String var3, String var4);

    public void genTextToEnableField(StringBuilder srcText, String enablementExpr) {
        String fieldName = this.fFieldInfo.getName();
        srcText.append("\t\t\t\t" + fieldName + ".getTextControl().setEditable(" + enablementExpr + ");\n");
        srcText.append("\t\t\t\t" + fieldName + ".getTextControl().setEnabled(" + enablementExpr + ");\n");
        srcText.append("\t\t\t\t" + fieldName + ".setEnabled(" + enablementExpr + ", " + fieldName + ".getParent());\n");
    }

    protected String getPreferenceKey() {
        return "P_" + this.fFieldInfo.getName().toUpperCase();
    }

    protected String toStringArrayLiteral(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        sb.append("new String[] { ");
        for (int i = 0; i < strings.size(); ++i) {
            String s;
            if (i > 0) {
                sb.append(", ");
            }
            if ((s = strings.get(i)) != null) {
                this.appendWithQuotes(s, sb);
                continue;
            }
            sb.append("null");
        }
        sb.append(" }");
        return sb.toString();
    }

    protected String stripQuotes(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            if (s.charAt(0) == '\"') {
                return "";
            }
            return s;
        }
        int newStart = s.charAt(0) == '\"' ? 1 : 0;
        int newEnd = s.charAt(s.length() - 1) == '\"' ? s.length() - 1 : s.length();
        return s.substring(newStart, newEnd);
    }

    protected void appendWithQuotes(String s, StringBuilder sb) {
        if (!s.startsWith("\"")) {
            sb.append("\"");
        }
        sb.append(s);
        if (!s.endsWith("\"")) {
            sb.append("\"");
        }
    }

    protected String createLabelFor(String name) {
        StringBuilder sb = new StringBuilder();
        int from = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            if (i < name.length() - 1 && Character.isUpperCase(name.charAt(i + 1))) {
                sb.append(name.charAt(from));
                from = i;
                continue;
            }
            if (i == from) continue;
            if (i > 0 && from > 0) {
                sb.append(' ');
            }
            if (from > 0 && i > from + 1) {
                this.appendLowerWord(name, from, i, sb);
            } else {
                sb.append(name.substring(from, i));
            }
            from = i;
        }
        if (from < name.length()) {
            if (from > 0) {
                sb.append(' ');
                this.appendLowerWord(name, from, name.length(), sb);
            } else {
                sb.append(name.substring(from, name.length()));
            }
        }
        return sb.toString();
    }

    protected void appendLowerWord(String s, int from, int to, StringBuilder sb) {
        if (from > 0 && to > from + 1) {
            sb.append(Character.toLowerCase(s.charAt(from)));
        } else {
            sb.append(s.charAt(from));
        }
        sb.append(s.substring(from + 1, to));
    }
}

