/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler.model;

import org.eclipse.imp.prefspecs.compiler.codegen.DoubleFieldCodeGenerator;
import org.eclipse.imp.prefspecs.compiler.codegen.FieldCodeGenerator;
import org.eclipse.imp.prefspecs.compiler.model.FieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.IPageMemberContainer;
import org.eclipse.ui.console.MessageConsoleStream;

public class DoubleFieldInfo
extends FieldInfo {
    protected double defaultValue = 0.0;
    protected boolean hasRangeSpec = false;
    protected double rangeHigh = Double.MAX_VALUE;
    protected double rangeLow = Double.MIN_VALUE;

    public DoubleFieldInfo(IPageMemberContainer parentPage, String name) {
        this(parentPage, name, 0.0);
    }

    public DoubleFieldInfo(IPageMemberContainer parentPage, String name, double defValue) {
        super(parentPage, name);
        this.defaultValue = defValue;
    }

    public FieldCodeGenerator getCodeGenerator() {
        return new DoubleFieldCodeGenerator(this);
    }

    public void setDefaultValue(double d) {
        if (d < this.getRangeLow() || d > this.getRangeHigh()) {
            throw new IllegalArgumentException("DoubleFieldInfo.setDefaultValue(double): attempt to set default value = " + d + " outside of range = " + this.getRangeLow() + ".." + this.getRangeHigh());
        }
        this.defaultValue = d;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasRangeSpec() {
        return this.hasRangeSpec;
    }

    public void setRange(double low, double high) {
        if (high < low) {
            throw new IllegalArgumentException("DoubleFieldInfo.setRange(double,double): range upper bound = " + high + " is less than lower bound = " + low);
        }
        this.hasRangeSpec = true;
        this.rangeLow = low;
        this.rangeHigh = high;
    }

    public double getRangeHigh() {
        return this.rangeHigh;
    }

    public double getRangeLow() {
        return this.rangeLow;
    }

    public void dump(String prefix, MessageConsoleStream out) {
        super.dump(prefix, out);
        String indent = prefix + "  ";
        out.println(indent + "defaultValue    = " + this.getDefaultValue());
    }
}

